/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.client.renderer.entity;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import com.talhanation.smallships.client.model.CannonModel;
import com.talhanation.smallships.client.model.ShipModel;
import com.talhanation.smallships.client.model.sail.BriggSailModel;
import com.talhanation.smallships.client.model.sail.CogSailModel;
import com.talhanation.smallships.client.model.sail.DrakkarSailModel;
import com.talhanation.smallships.client.model.sail.GalleySailModel;
import com.talhanation.smallships.client.model.sail.SailModel;
import com.talhanation.smallships.world.entity.projectile.Cannon;
import com.talhanation.smallships.world.entity.ship.Attributes;
import com.talhanation.smallships.world.entity.ship.BriggEntity;
import com.talhanation.smallships.world.entity.ship.CogEntity;
import com.talhanation.smallships.world.entity.ship.DrakkarEntity;
import com.talhanation.smallships.world.entity.ship.GalleyEntity;
import com.talhanation.smallships.world.entity.ship.Ship;
import com.talhanation.smallships.world.entity.ship.abilities.Bannerable;
import com.talhanation.smallships.world.entity.ship.abilities.Cannonable;
import com.talhanation.smallships.world.entity.ship.abilities.Paddleable;
import com.talhanation.smallships.world.entity.ship.abilities.Sailable;
import com.talhanation.smallships.world.entity.ship.abilities.Shieldable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ShieldModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BannerRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;

public abstract class ShipRenderer<T extends Ship>
extends EntityRenderer<T> {
    protected final Map<Boat.Type, Pair<ResourceLocation, ShipModel<T>>> boatResources;
    private static final ModelPart bannerModel;
    private static final ShieldModel shieldModel;
    private static final Map<Class<? extends Ship>, SailModel> sailModels;

    public ShipRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.shadowRadius = 0.8f;
        this.boatResources = (Map)Stream.of(Boat.Type.values()).collect(ImmutableMap.toImmutableMap(type -> type, type -> Pair.of((Object)this.getTextureLocation((Boat.Type)type), this.createBoatModel(context, (Boat.Type)type))));
    }

    protected abstract ShipModel<T> createBoatModel(EntityRendererProvider.Context var1, Boat.Type var2);

    protected ResourceLocation getTextureLocation(Boat.Type type) {
        return ResourceLocation.fromNamespaceAndPath((String)"smallships", (String)("textures/entity/ship/" + ShipRenderer.getNameFromType(type) + ".png"));
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull T shipEntity) {
        return (ResourceLocation)this.boatResources.get(shipEntity.getVariant()).getFirst();
    }

    public void render(T shipEntity, float entityYaw, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int packedLight) {
        float k;
        Attributes shipAttributes = ((Ship)((Object)shipEntity)).getAttributes();
        float h = ((float)shipEntity.getHurtTime() - partialTicks) / (shipAttributes.maxHealth * shipEntity.getBbWidth() / 40.0f);
        float j = shipEntity.getDamage() - partialTicks;
        if (j < 0.0f) {
            j = 0.0f;
        } else if (j > shipAttributes.maxHealth * 0.5f) {
            shipEntity.level().addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, shipEntity.getRandomX(0.5), shipEntity.getY() + 1.0, shipEntity.getRandomZ(0.5), 0.0, 0.0, 0.0);
        }
        if (h > 0.0f) {
            poseStack.mulPose(Axis.XP.rotationDegrees(Mth.sin((float)h) * h * j / 10.0f * (float)shipEntity.getHurtDir()));
        }
        if (!Mth.equal((float)(k = shipEntity.getBubbleAngle(partialTicks)), (float)0.0f)) {
            poseStack.mulPose(new Quaternionf().rotateX(k * ((float)Math.PI / 180)).rotateZ(k * ((float)Math.PI / 180)));
        }
        float l = ((Ship)((Object)shipEntity)).getWaveAngle(partialTicks);
        if (!((Ship)((Object)shipEntity)).isSunken() && !Mth.equal((float)l, (float)0.0f)) {
            poseStack.mulPose(this.getWaveAngleRotation().rotationDegrees(l));
        }
        Pair<ResourceLocation, ShipModel<T>> pair = this.boatResources.get(shipEntity.getVariant());
        ResourceLocation resourceLocation = (ResourceLocation)pair.getFirst();
        ShipModel shipModel = (ShipModel)((Object)pair.getSecond());
        poseStack.scale(-1.3f, -1.3f, 1.3f);
        poseStack.mulPose(Axis.YP.rotationDegrees(270.0f));
        shipModel.setupAnim((Entity)shipEntity, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        if (shipEntity instanceof Cannonable) {
            Cannonable cannonShipEntity = (Cannonable)shipEntity;
            this.renderCannon(cannonShipEntity, entityYaw, partialTicks, poseStack, multiBufferSource, packedLight);
        }
        if (shipEntity instanceof Bannerable) {
            Bannerable bannerShipEntity = (Bannerable)shipEntity;
            this.renderBanner(bannerShipEntity, entityYaw, partialTicks, poseStack, multiBufferSource, packedLight);
        }
        if (shipEntity instanceof Paddleable) {
            Paddleable paddleShipEntity = (Paddleable)shipEntity;
            this.renderPaddle(paddleShipEntity, entityYaw, partialTicks, poseStack, multiBufferSource, packedLight);
        }
        if (shipEntity instanceof Sailable) {
            Sailable sailShipEntity = (Sailable)shipEntity;
            this.renderSail(sailShipEntity, entityYaw, partialTicks, poseStack, multiBufferSource, packedLight);
        }
        if (shipEntity instanceof Shieldable) {
            Shieldable shieldShipEntity = (Shieldable)shipEntity;
            this.renderShields(shieldShipEntity, entityYaw, partialTicks, poseStack, multiBufferSource, packedLight);
        }
        VertexConsumer vertexConsumer = multiBufferSource.getBuffer(shipModel.renderType(resourceLocation));
        shipModel.renderToBuffer(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY, -1);
        poseStack.popPose();
        super.render(shipEntity, entityYaw, partialTicks, poseStack, multiBufferSource, packedLight);
    }

    private void renderCannon(Cannonable cannonShipEntity, float entityYaw, float partialTicks, PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int packedLight) {
        for (byte i = 0; i < cannonShipEntity.getCannonCount(); i = (byte)(i + 1)) {
            Cannon cannon = new Cannon(cannonShipEntity.self(), cannonShipEntity.getCannonPosition(i));
            poseStack.pushPose();
            poseStack.mulPose(Axis.YN.rotationDegrees(this.getCannonAngleOffset() + cannon.getAngle()));
            poseStack.translate(cannon.isRightSided() ? -cannon.getOffsetX() : cannon.getOffsetX(), -cannon.getOffsetY() + (double)this.getCannonHeightOffset(), -cannon.getOffsetZ());
            poseStack.scale(0.6f, 0.6f, 0.6f);
            CannonModel cannonModel = new CannonModel();
            cannonModel.setupAnim((Ship)((Object)cannonShipEntity), partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
            VertexConsumer vertexConsumer = multiBufferSource.getBuffer(cannonModel.renderType(cannonShipEntity.getTextureLocation()));
            cannonModel.renderToBuffer(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY, 0xFFFFFF);
            poseStack.popPose();
        }
    }

    protected float getCannonAngleOffset() {
        return 0.0f;
    }

    protected float getCannonHeightOffset() {
        return 0.0f;
    }

    private void renderBanner(Bannerable bannerShipEntity, float entityYaw, float partialTicks, PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int packedLight) {
        ItemStack bannerItemStack = bannerShipEntity.self().getData(Ship.BANNER);
        Item item = bannerItemStack.getItem();
        if (item instanceof BannerItem) {
            BannerItem bannerItem = (BannerItem)item;
            poseStack.pushPose();
            Bannerable.BannerPosition pos = bannerShipEntity.getBannerPosition();
            poseStack.mulPose(Axis.YP.rotationDegrees(pos.yp));
            poseStack.mulPose(Axis.ZP.rotationDegrees(pos.zp));
            poseStack.translate(pos.x, pos.y, pos.z);
            poseStack.scale(0.5f, 0.5f, 0.5f);
            float bannerWaveAngle = bannerShipEntity.getBannerWaveAngle(partialTicks);
            if (!Mth.equal((float)bannerWaveAngle, (float)0.0f)) {
                poseStack.mulPose(Axis.ZP.rotationDegrees(bannerWaveAngle * 0.5f));
                poseStack.mulPose(Axis.XP.rotationDegrees(bannerWaveAngle));
            }
            BannerPatternLayers bannerPatternLayers = (BannerPatternLayers)bannerItemStack.getOrDefault(DataComponents.BANNER_PATTERNS, (Object)BannerPatternLayers.EMPTY);
            DyeColor dyeColor = ((BannerItem)bannerItemStack.getItem()).getColor();
            BannerRenderer.renderPatterns((PoseStack)poseStack, (MultiBufferSource)multiBufferSource, (int)packedLight, (int)OverlayTexture.NO_OVERLAY, (ModelPart)bannerModel, (Material)ModelBakery.BANNER_BASE, (boolean)true, (DyeColor)dyeColor, (BannerPatternLayers)bannerPatternLayers);
            poseStack.popPose();
        }
    }

    private void renderShields(Shieldable shieldShipEntity, float entityYaw, float partialTicks, PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int packedLight) {
        for (int i = 0; i < shieldShipEntity.getShields().size(); i = (int)((byte)(i + 1))) {
            ItemStack shieldItemStack = (ItemStack)shieldShipEntity.getShields().get(i);
            if (!shieldItemStack.is(Items.SHIELD)) continue;
            poseStack.pushPose();
            Shieldable.ShieldPosition pos = shieldShipEntity.getShieldPosition(i);
            poseStack.translate(pos.x, pos.y, pos.z);
            poseStack.scale(0.8f, -0.8f, -0.8f);
            if (pos.isRightSided) {
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            }
            poseStack.mulPose(Axis.XP.rotationDegrees(20.0f));
            poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
            BannerPatternLayers bannerPatternLayers = (BannerPatternLayers)shieldItemStack.getOrDefault(DataComponents.BANNER_PATTERNS, (Object)BannerPatternLayers.EMPTY);
            DyeColor dyeColor = (DyeColor)shieldItemStack.get(DataComponents.BASE_COLOR);
            boolean flag = !bannerPatternLayers.layers().isEmpty() || dyeColor != null;
            Material material = flag ? ModelBakery.SHIELD_BASE : ModelBakery.NO_PATTERN_SHIELD;
            VertexConsumer vertexConsumer = material.sprite().wrap(ItemRenderer.getFoilBufferDirect((MultiBufferSource)multiBufferSource, (RenderType)shieldModel.renderType(material.atlasLocation()), (boolean)true, (boolean)shieldItemStack.hasFoil()));
            if (flag) {
                BannerRenderer.renderPatterns((PoseStack)poseStack, (MultiBufferSource)multiBufferSource, (int)packedLight, (int)OverlayTexture.NO_OVERLAY, (ModelPart)shieldModel.plate(), (Material)material, (boolean)false, (DyeColor)Objects.requireNonNullElse(dyeColor, DyeColor.WHITE), (BannerPatternLayers)bannerPatternLayers, (boolean)shieldItemStack.hasFoil());
            } else {
                shieldModel.plate().render(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY, -1);
            }
            shieldModel.handle().render(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY, -1);
            poseStack.popPose();
        }
    }

    public Axis getWaveAngleRotation() {
        return Axis.ZN;
    }

    private void renderPaddle(Paddleable paddleShipEntity, float entityYaw, float partialTicks, PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int packedLight) {
    }

    private void renderSail(Sailable sailShipEntity, float entityYaw, float partialTicks, PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int packedLight) {
        SailModel sailModel = sailModels.get(sailShipEntity.getClass());
        sailModel.setupAnim((Entity)((Ship)((Object)sailShipEntity)), partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexConsumer = multiBufferSource.getBuffer(sailModel.renderType(SailModel.getSailColor((String)sailShipEntity.self().getData(Ship.SAIL_COLOR)).location));
        sailModel.renderToBuffer(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY, -1);
    }

    public static String getNameFromType(Boat.Type type) {
        return type.getName().replace(":", "/");
    }

    static {
        ModelPart model = BannerRenderer.createBodyLayer().bakeRoot();
        model.getChild((String)"pole").visible = false;
        model.getChild((String)"bar").visible = false;
        bannerModel = model;
        shieldModel = new ShieldModel(Minecraft.getInstance().getEntityModels().bakeLayer(ModelLayers.SHIELD));
        sailModels = new HashMap<Class<? extends Ship>, SailModel>();
        sailModels.put(CogEntity.class, new CogSailModel());
        sailModels.put(BriggEntity.class, new BriggSailModel());
        sailModels.put(GalleyEntity.class, new GalleySailModel());
        sailModels.put(DrakkarEntity.class, new DrakkarSailModel());
    }
}

