/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.client;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundSource;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.setup.SimplePlanesSounds;

public class PlaneSound
extends AbstractTickableSoundInstance {
    public static final Map<Integer, PlaneSound> PLAYING_FOR = Collections.synchronizedMap(new HashMap());
    private final PlaneEntity plane;
    private int fadeOut = -1;

    public PlaneSound(PlaneEntity plane) {
        super(SimplePlanesSounds.PLANE_LOOP_SOUND_EVENT.get(), SoundSource.NEUTRAL, SoundInstance.createUnseededRandom());
        this.plane = plane;
        this.looping = true;
        PLAYING_FOR.put(plane.getId(), this);
    }

    public static boolean isPlaying(int entityId) {
        if (!PLAYING_FOR.containsKey(entityId)) {
            return false;
        }
        PlaneSound sound = PLAYING_FOR.get(entityId);
        return sound != null && !sound.isStopped();
    }

    public static void tryToPlay(PlaneEntity planeEntity) {
        if (!PlaneSound.isPlaying(planeEntity.getId())) {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)new PlaneSound(planeEntity));
        }
    }

    public float getPitch() {
        return (float)this.plane.getThrottle() / 10.0f * 0.7f + 0.6f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        this.x = this.plane.getX();
        this.y = this.plane.getY();
        this.z = this.plane.getZ();
        if (!(this.fadeOut >= 0 || this.plane.isPowered() && this.plane.getThrottle() != 0)) {
            this.fadeOut = 0;
            Map<Integer, PlaneSound> map = PLAYING_FOR;
            synchronized (map) {
                PLAYING_FOR.remove(this.plane.getId());
            }
        } else if (this.fadeOut >= 10) {
            this.stop();
        } else if (this.fadeOut >= 0) {
            this.volume = 1.0f - (float)this.fadeOut / 10.0f;
            ++this.fadeOut;
        }
    }
}

