/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.sn.network;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.loader.api.FabricLoader;

public class NotificationConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File BASE_CONFIG_DIR = new File(FabricLoader.getInstance().getConfigDir().toFile(), "Server Notify");
    private static final File NOTIFICATIONS_FILE = new File(BASE_CONFIG_DIR, "notifications.json");

    public static void initConfig() {
        if (!BASE_CONFIG_DIR.exists()) {
            BASE_CONFIG_DIR.mkdirs();
        }
        if (!NOTIFICATIONS_FILE.exists()) {
            try {
                JsonObject root = new JsonObject();
                JsonArray notificationsArray = new JsonArray();
                root.add("notifications", (JsonElement)notificationsArray);
                NotificationConfig.writeConfig(root);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void writeConfig(JsonObject jsonObject) throws IOException {
        try (FileWriter writer = new FileWriter(NOTIFICATIONS_FILE);){
            GSON.toJson((JsonElement)jsonObject, (Appendable)writer);
        }
    }

    public static JsonObject loadConfig() {
        JsonObject jsonObject;
        FileReader reader = new FileReader(NOTIFICATIONS_FILE);
        try {
            jsonObject = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        ((Reader)reader).close();
        return jsonObject;
    }

    public static void saveConfig(JsonObject configObject) {
        try {
            NotificationConfig.writeConfig(configObject);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

