/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.sn.network;

import com.dooji.sn.config.ConfigManager;
import com.dooji.sn.config.NotificationConfig;
import com.dooji.sn.gui.TextNotificationScreen;
import com.dooji.sn.gui.TextureNotificationScreen;
import com.dooji.sn.gui.URLTextureNotificationScreen;
import com.dooji.sn.network.NotificationData;
import com.dooji.sn.network.TextNotificationPayload;
import com.dooji.sn.network.TextureNotificationPayload;
import com.dooji.sn.network.URLNotificationPayload;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.minecraft.class_310;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class ClientPacketHandler {
    private static final Queue<NotificationData> notificationQueue = new ArrayDeque<NotificationData>();
    public static boolean isDisplayingNotification = false;
    private static boolean isRegistered = false;
    private static final long NOTIFICATION_DELAY = 1000L;
    private static final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();

    public static void register() {
        if (!isRegistered) {
            PayloadTypeRegistry.playS2C().register(TextureNotificationPayload.ID, TextureNotificationPayload.CODEC);
            PayloadTypeRegistry.playS2C().register(TextNotificationPayload.ID, TextNotificationPayload.CODEC);
            PayloadTypeRegistry.playS2C().register(URLNotificationPayload.ID, URLNotificationPayload.CODEC);
            ClientPlayNetworking.registerGlobalReceiver(TextureNotificationPayload.ID, (payload, context) -> ClientPacketHandler.handleTextureNotification(context.client(), payload));
            ClientPlayNetworking.registerGlobalReceiver(TextNotificationPayload.ID, (payload, context) -> ClientPacketHandler.handleTextNotification(context.client(), payload));
            ClientPlayNetworking.registerGlobalReceiver(URLNotificationPayload.ID, (payload, context) -> ClientPacketHandler.handleURLNotification(context.client(), payload));
            isRegistered = true;
        }
    }

    private static void handleTextureNotification(class_310 client, TextureNotificationPayload payload) {
        NotificationConfig config = ConfigManager.loadConfig();
        String name = payload.name();
        boolean alwaysShow = payload.alwaysShow();
        if (config.getSeenNotifications().contains(name) && !alwaysShow) {
            return;
        }
        if (!config.getSeenNotifications().contains(name)) {
            config.getSeenNotifications().add(name);
            ConfigManager.saveConfig(config);
        }
        NotificationData notificationData = new NotificationData(name, payload.type(), payload.soundNamespace(), payload.soundPath(), payload.namespace(), payload.texture(), payload.width(), payload.height(), payload.dismissMessage(), payload.alwaysShow());
        client.execute(() -> {
            notificationQueue.add(notificationData);
            ClientPacketHandler.displayNextNotification(client);
        });
    }

    private static void handleTextNotification(class_310 client, TextNotificationPayload payload) {
        NotificationConfig config = ConfigManager.loadConfig();
        String name = payload.name();
        boolean alwaysShow = payload.alwaysShow();
        if (config.getSeenNotifications().contains(name) && !alwaysShow) {
            return;
        }
        if (!config.getSeenNotifications().contains(name)) {
            config.getSeenNotifications().add(name);
            ConfigManager.saveConfig(config);
        }
        NotificationData notificationData = new NotificationData(name, payload.type(), payload.soundNamespace(), payload.soundPath(), payload.message(), payload.dismissButton(), payload.dismissMessage(), payload.alwaysShow());
        client.execute(() -> {
            notificationQueue.add(notificationData);
            ClientPacketHandler.displayNextNotification(client);
        });
    }

    private static void handleURLNotification(class_310 client, URLNotificationPayload payload) {
        NotificationConfig config = ConfigManager.loadConfig();
        String name = payload.name();
        boolean alwaysShow = payload.alwaysShow();
        if (config.getSeenNotifications().contains(name) && !alwaysShow) {
            return;
        }
        if (!config.getSeenNotifications().contains(name)) {
            config.getSeenNotifications().add(name);
            ConfigManager.saveConfig(config);
        }
        NotificationData notificationData = new NotificationData(name, payload.type(), payload.soundNamespace(), payload.soundPath(), payload.url(), payload.width(), payload.height(), payload.dismissMessage(), payload.alwaysShow());
        client.execute(() -> {
            notificationQueue.add(notificationData);
            ClientPacketHandler.displayNextNotification(client);
        });
    }

    public static void displayNextNotification(class_310 client) {
        if (!isDisplayingNotification && !notificationQueue.isEmpty()) {
            NotificationData notificationData = notificationQueue.poll();
            String type = notificationData.getType();
            client.execute(() -> {
                if (type.equals("texture")) {
                    client.method_1507((class_437)new TextureNotificationScreen(notificationData, type));
                } else if (type.equals("text")) {
                    client.method_1507((class_437)new TextNotificationScreen(notificationData, type));
                } else if (type.equals("url")) {
                    client.method_1507((class_437)new URLTextureNotificationScreen(notificationData, type));
                }
            });
            isDisplayingNotification = true;
            executorService.schedule(() -> {
                isDisplayingNotification = false;
            }, 1000L, TimeUnit.MILLISECONDS);
        } else if (notificationQueue.isEmpty()) {
            isDisplayingNotification = false;
        }
    }
}

