/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.sn.gui;

import com.dooji.sn.network.ClientPacketHandler;
import com.dooji.sn.network.NotificationData;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class TextNotificationScreen
extends class_437 {
    private final NotificationData notificationData;
    private class_3414 notificationSound;
    private String type;
    private final int fadeDuration = 8;
    private final int stayDelay = 16;
    double startFadeOutTime = 24.0;
    double fullAnimationLength = this.startFadeOutTime + 8.0;
    double timer = 0.0;
    private boolean soundPlayed = false;

    public TextNotificationScreen(NotificationData notificationData, String type) {
        super((class_2561)class_2561.method_43470((String)notificationData.getMessage()));
        this.notificationData = notificationData;
        this.type = type;
        this.notificationSound = this.createSoundEvent(notificationData.getSoundNamespace(), notificationData.getSoundPath());
    }

    private class_3414 createSoundEvent(String namespace, String path) {
        class_2960 soundId = class_2960.method_60655((String)namespace, (String)path);
        if (!class_7923.field_41172.method_10250(soundId)) {
            class_3414 soundEvent = class_3414.method_47908((class_2960)soundId);
            class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)soundId, (Object)soundEvent);
        }
        return (class_3414)class_7923.field_41172.method_10223(soundId);
    }

    protected void method_25426() {
        super.method_25426();
        if (this.notificationData.isDismissButtonShow()) {
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Dismiss"), button -> this.method_25419()).method_46433(this.field_22789 / 2 - 50, this.field_22790 - 40).method_46437(100, 20).method_46431());
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        this.playNotificationSound();
        context.method_25300(this.field_22793, this.notificationData.getMessage(), this.field_22789 / 2, this.field_22790 / 2 - 10, 0xFFFFFF);
        if (this.notificationData.isDismissShow()) {
            double alpha = this.calculateAlpha();
            this.renderDismissText(context, class_310.method_1551().field_1772, alpha);
            this.timer += (double)delta;
            this.timer %= this.fullAnimationLength;
        }
    }

    private void renderDismissText(class_332 context, class_327 textRenderer, double alpha) {
        class_5250 dismissText = class_2561.method_43470((String)"Press ESC to dismiss");
        int textWidth = textRenderer.method_27525((class_5348)dismissText);
        int textX = (this.field_22789 - textWidth) / 2;
        int textY = this.field_22790 - 20;
        int color = 0xFFFFFF | (int)(255.0 * alpha) << 24;
        context.method_27535(textRenderer, (class_2561)dismissText, textX, textY, color);
    }

    double calculateAlpha() {
        if (this.timer < 8.0) {
            return this.timer / 8.0;
        }
        if (this.timer < this.startFadeOutTime) {
            return 1.0;
        }
        double fadeOutProgress = (this.timer - this.startFadeOutTime) / 8.0;
        return Math.max(0.0, 1.0 - fadeOutProgress);
    }

    public boolean method_25422() {
        return true;
    }

    public void method_25419() {
        super.method_25419();
        class_310.method_1551().method_1507(null);
        this.field_22787.execute(() -> {
            ClientPacketHandler.isDisplayingNotification = false;
            ClientPacketHandler.displayNextNotification(class_310.method_1551());
        });
    }

    private void playNotificationSound() {
        if (!this.soundPlayed && this.notificationSound != null && class_310.method_1551().method_1483() != null) {
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)this.notificationSound, (float)1.0f));
            this.soundPlayed = true;
        }
    }
}

