/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.sn.gui;

import com.dooji.sn.network.ClientPacketHandler;
import com.dooji.sn.network.NotificationData;
import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class ErrorScreen
extends class_437 {
    private final NotificationData notificationData;
    private class_3414 notificationSound;
    private String type;
    private String reason;
    private final int fadeDuration = 8;
    private final int stayDelay = 16;
    double startFadeOutTime = 24.0;
    double fullAnimationLength = this.startFadeOutTime + 8.0;
    double timer = 0.0;
    private boolean soundPlayed = false;

    public ErrorScreen(NotificationData notificationData, String type, String reason) {
        super((class_2561)class_2561.method_43470((String)""));
        this.notificationData = notificationData;
        this.type = type;
        this.reason = reason;
        this.notificationSound = this.createSoundEvent(notificationData.getSoundNamespace(), notificationData.getSoundPath());
    }

    private class_3414 createSoundEvent(String namespace, String path) {
        class_2960 soundId = class_2960.method_60655((String)namespace, (String)path);
        if (!class_7923.field_41172.method_10250(soundId)) {
            class_3414 soundEvent = class_3414.method_47908((class_2960)soundId);
            class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)soundId, (Object)soundEvent);
        }
        return (class_3414)class_7923.field_41172.method_10223(soundId);
    }

    protected void method_25426() {
        super.method_25426();
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        this.playNotificationSound();
        context.method_25294(0, 0, this.field_22789, 40, -16777216);
        context.method_25294(0, 40, this.field_22789, 70, -7667712);
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"Server Notify"), this.field_22789 / 2, 15, 0xFFFFFF);
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"Please report this error to the server owner!"), this.field_22789 / 2, 50, 0xFFFFFF);
        if (this.reason.equals("nullbimage")) {
            ArrayList<Object> errorLines = new ArrayList<Object>();
            errorLines.add(class_2561.method_43470((String)"The image could not be downloaded. Please check the URL."));
            errorLines.add(class_2561.method_30163((String)("URL: " + this.notificationData.getURL())));
            errorLines.add(class_2561.method_30163((String)("Notification UUID: " + this.notificationData.getName())));
            int lineHeight = 10;
            int totalHeight = errorLines.size() * lineHeight;
            int startY = this.field_22790 / 2 - totalHeight / 2;
            startY += 30;
            int color = 0xFFFFFF;
            for (class_2561 class_25612 : errorLines) {
                context.method_27534(this.field_22793, class_25612, this.field_22789 / 2, startY, color);
                startY += lineHeight;
            }
        }
        if (this.notificationData.isDismissShow()) {
            double alpha = this.calculateAlpha();
            this.renderDismissText(context, class_310.method_1551().field_1772, alpha);
            this.timer += (double)delta;
            this.timer %= this.fullAnimationLength;
        }
    }

    private void renderDismissText(class_332 context, class_327 textRenderer, double alpha) {
        class_5250 dismissText = class_2561.method_43470((String)"Press ESC to dismiss");
        int textWidth = textRenderer.method_27525((class_5348)dismissText);
        int textX = (this.field_22789 - textWidth) / 2;
        int textY = this.field_22790 - 20;
        int color = 0xFFFFFF | (int)(255.0 * alpha) << 24;
        context.method_27535(textRenderer, (class_2561)dismissText, textX, textY, color);
    }

    double calculateAlpha() {
        if (this.timer < 8.0) {
            return this.timer / 8.0;
        }
        if (this.timer < this.startFadeOutTime) {
            return 1.0;
        }
        double fadeOutProgress = (this.timer - this.startFadeOutTime) / 8.0;
        return Math.max(0.0, 1.0 - fadeOutProgress);
    }

    public boolean method_25422() {
        return true;
    }

    public void method_25419() {
        super.method_25419();
        class_310.method_1551().method_1507(null);
        this.field_22787.execute(() -> {
            ClientPacketHandler.isDisplayingNotification = false;
            ClientPacketHandler.displayNextNotification(class_310.method_1551());
        });
    }

    private void playNotificationSound() {
        if (!this.soundPlayed && this.notificationSound != null && class_310.method_1551().method_1483() != null) {
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)this.notificationSound, (float)1.0f));
            this.soundPlayed = true;
        }
    }
}

