/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.sn.config;

import com.dooji.sn.config.NotificationConfig;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public class ConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File BASE_CONFIG_DIR = new File(FabricLoader.getInstance().getConfigDir().toFile(), "Server Notify");
    private static final File SEEN_NOTIFICATIONS_FILE = new File(BASE_CONFIG_DIR, "seen_notifications.json");

    public static NotificationConfig loadConfig() {
        if (!BASE_CONFIG_DIR.exists()) {
            BASE_CONFIG_DIR.mkdirs();
        }
        if (SEEN_NOTIFICATIONS_FILE.exists()) {
            NotificationConfig notificationConfig;
            FileReader reader = new FileReader(SEEN_NOTIFICATIONS_FILE);
            try {
                notificationConfig = (NotificationConfig)GSON.fromJson((Reader)reader, NotificationConfig.class);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            reader.close();
            return notificationConfig;
        }
        return new NotificationConfig();
    }

    public static void saveConfig(NotificationConfig config) {
        if (!BASE_CONFIG_DIR.exists()) {
            BASE_CONFIG_DIR.mkdirs();
        }
        try (FileWriter writer = new FileWriter(SEEN_NOTIFICATIONS_FILE);){
            GSON.toJson((Object)config, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

