/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.sn.commands;

import com.dooji.sn.network.NotificationConfig;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;

public class NotificationCommands {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"server-notify").requires(source -> source.method_9259(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"new").then(class_2170.method_9247((String)"text").then(class_2170.method_9244((String)"friendly_name", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"sound_namespace", (ArgumentType)StringArgumentType.word()).then(class_2170.method_9244((String)"sound_path", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"message", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"dismissButton", (ArgumentType)BoolArgumentType.bool()).then(class_2170.method_9244((String)"dismissMessage", (ArgumentType)BoolArgumentType.bool()).then(class_2170.method_9244((String)"alwaysShow", (ArgumentType)BoolArgumentType.bool()).executes(NotificationCommands::executeAddTextNotification)))))))))).then(class_2170.method_9247((String)"url").then(class_2170.method_9244((String)"friendly_name", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"sound_namespace", (ArgumentType)StringArgumentType.word()).then(class_2170.method_9244((String)"sound_path", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"url", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"width", (ArgumentType)IntegerArgumentType.integer()).then(class_2170.method_9244((String)"height", (ArgumentType)IntegerArgumentType.integer()).then(class_2170.method_9244((String)"dismissMessage", (ArgumentType)BoolArgumentType.bool()).then(class_2170.method_9244((String)"alwaysShow", (ArgumentType)BoolArgumentType.bool()).executes(NotificationCommands::executeAddUrlNotification))))))))))).then(class_2170.method_9247((String)"texture").then(class_2170.method_9244((String)"friendly_name", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"sound_namespace", (ArgumentType)StringArgumentType.word()).then(class_2170.method_9244((String)"sound_path", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"namespace", (ArgumentType)StringArgumentType.word()).then(class_2170.method_9244((String)"texture", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"width", (ArgumentType)IntegerArgumentType.integer()).then(class_2170.method_9244((String)"height", (ArgumentType)IntegerArgumentType.integer()).then(class_2170.method_9244((String)"dismissMessage", (ArgumentType)BoolArgumentType.bool()).then(class_2170.method_9244((String)"alwaysShow", (ArgumentType)BoolArgumentType.bool()).executes(NotificationCommands::executeAddTextureNotification))))))))))))).then(class_2170.method_9247((String)"edit").then(class_2170.method_9244((String)"uuid", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            JsonObject configObject = NotificationConfig.loadConfig();
            JsonArray notificationsArray = configObject.getAsJsonArray("notifications");
            for (int i = 0; i < notificationsArray.size(); ++i) {
                String uuid = notificationsArray.get(i).getAsJsonObject().get("name").getAsString();
                builder.suggest(uuid);
            }
            return builder.buildFuture();
        }).then(class_2170.method_9244((String)"element", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            builder.suggest("friendly_name");
            builder.suggest("type");
            builder.suggest("sound_namespace");
            builder.suggest("sound_path");
            builder.suggest("namespace");
            builder.suggest("texture");
            builder.suggest("width");
            builder.suggest("height");
            builder.suggest("dismissMessage");
            builder.suggest("alwaysShow");
            builder.suggest("message");
            builder.suggest("url");
            builder.suggest("dismissButton");
            return builder.buildFuture();
        }).then(class_2170.method_9244((String)"newvalue", (ArgumentType)StringArgumentType.word()).executes(NotificationCommands::executeEditNotification)))))).then(class_2170.method_9247((String)"info").then(class_2170.method_9244((String)"uuid", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            JsonObject configObject = NotificationConfig.loadConfig();
            JsonArray notificationsArray = configObject.getAsJsonArray("notifications");
            for (int i = 0; i < notificationsArray.size(); ++i) {
                String uuid = notificationsArray.get(i).getAsJsonObject().get("name").getAsString();
                builder.suggest(uuid);
            }
            return builder.buildFuture();
        }).executes(NotificationCommands::executeNotificationInfo)))).then(class_2170.method_9247((String)"list").executes(NotificationCommands::executeListNotifications))).then(class_2170.method_9247((String)"uuid-list").executes(NotificationCommands::executeListNotificationUUIDs))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"uuid", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            JsonObject configObject = NotificationConfig.loadConfig();
            JsonArray notificationsArray = configObject.getAsJsonArray("notifications");
            for (int i = 0; i < notificationsArray.size(); ++i) {
                String uuid = notificationsArray.get(i).getAsJsonObject().get("name").getAsString();
                builder.suggest(uuid);
            }
            return builder.buildFuture();
        }).executes(NotificationCommands::executeRemoveNotification))));
    }

    private static int executeAddTextNotification(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        String type = "text";
        String friendlyName = (String)context.getArgument("friendly_name", String.class);
        String soundNamespace = (String)context.getArgument("sound_namespace", String.class);
        String soundPath = (String)context.getArgument("sound_path", String.class);
        String message = (String)context.getArgument("message", String.class);
        boolean dismissButton = (Boolean)context.getArgument("dismissButton", Boolean.class);
        boolean dismissMessage = (Boolean)context.getArgument("dismissMessage", Boolean.class);
        boolean alwaysShow = (Boolean)context.getArgument("alwaysShow", Boolean.class);
        NotificationCommands.addNotification(source, friendlyName, type, soundNamespace, soundPath, message, "", 0, 0, dismissButton, dismissMessage, alwaysShow);
        return 1;
    }

    private static int executeAddUrlNotification(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        String type = "url";
        String friendlyName = (String)context.getArgument("friendly_name", String.class);
        String soundNamespace = (String)context.getArgument("sound_namespace", String.class);
        String soundPath = (String)context.getArgument("sound_path", String.class);
        String urlValue = (String)context.getArgument("url", String.class);
        int width = (Integer)context.getArgument("width", Integer.class);
        int height = (Integer)context.getArgument("height", Integer.class);
        boolean dismissMessage = (Boolean)context.getArgument("dismissMessage", Boolean.class);
        boolean alwaysShow = (Boolean)context.getArgument("alwaysShow", Boolean.class);
        NotificationCommands.addNotification(source, friendlyName, type, soundNamespace, soundPath, urlValue, "", width, height, false, dismissMessage, alwaysShow);
        return 1;
    }

    private static int executeAddTextureNotification(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        String type = "texture";
        String friendlyName = (String)context.getArgument("friendly_name", String.class);
        String soundNamespace = (String)context.getArgument("sound_namespace", String.class);
        String soundPath = (String)context.getArgument("sound_path", String.class);
        String namespace = (String)context.getArgument("namespace", String.class);
        String texture = (String)context.getArgument("texture", String.class);
        int width = (Integer)context.getArgument("width", Integer.class);
        int height = (Integer)context.getArgument("height", Integer.class);
        boolean dismissMessage = (Boolean)context.getArgument("dismissMessage", Boolean.class);
        boolean alwaysShow = (Boolean)context.getArgument("alwaysShow", Boolean.class);
        NotificationCommands.addNotification(source, friendlyName, type, soundNamespace, soundPath, namespace, texture, width, height, false, dismissMessage, alwaysShow);
        return 1;
    }

    private static int executeListNotifications(CommandContext<class_2168> context) {
        NotificationCommands.listNotifications((class_2168)context.getSource());
        return 1;
    }

    private static int executeListNotificationUUIDs(CommandContext<class_2168> context) {
        NotificationCommands.listNotificationUUIDs((class_2168)context.getSource());
        return 1;
    }

    private static int executeRemoveNotification(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        String uuid = (String)context.getArgument("uuid", String.class);
        NotificationCommands.removeNotification(source, uuid);
        return 1;
    }

    private static int executeEditNotification(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        String uuid = (String)context.getArgument("uuid", String.class);
        String whatToEdit = (String)context.getArgument("element", String.class);
        if (whatToEdit == null) {
            source.method_9213(class_2561.method_30163((String)"You must specify what to edit."));
            return 0;
        }
        String newValue = (String)context.getArgument("newvalue", String.class);
        switch (whatToEdit.toLowerCase()) {
            case "friendly_name": 
            case "type": 
            case "sound_namespace": 
            case "sound_path": 
            case "namespace": 
            case "texture": 
            case "width": 
            case "height": 
            case "dismissmessage": 
            case "alwaysshow": 
            case "message": 
            case "url": 
            case "dismissbutton": {
                NotificationCommands.editNotification(source, uuid, whatToEdit, newValue);
                return 1;
            }
        }
        source.method_9213(class_2561.method_30163((String)"Invalid property to edit."));
        return 0;
    }

    private static int executeNotificationInfo(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        String uuid = (String)context.getArgument("uuid", String.class);
        JsonObject configObject = NotificationConfig.loadConfig();
        JsonArray notificationsArray = configObject.getAsJsonArray("notifications");
        for (int i = 0; i < notificationsArray.size(); ++i) {
            JsonObject notification = notificationsArray.get(i).getAsJsonObject();
            if (!notification.get("name").getAsString().equals(uuid)) continue;
            String type = notification.get("type").getAsString();
            switch (type.toLowerCase()) {
                case "texture": {
                    NotificationCommands.displayTextureNotificationInfo(source, notification);
                    break;
                }
                case "text": {
                    NotificationCommands.displayTextNotificationInfo(source, notification);
                    break;
                }
                case "url": {
                    NotificationCommands.displayURLNotificationInfo(source, notification);
                    break;
                }
                default: {
                    source.method_9213(class_2561.method_30163((String)"Invalid notification type."));
                    return 0;
                }
            }
            return 1;
        }
        source.method_9213((class_2561)class_2561.method_43470((String)("Notification with UUID " + uuid + " not found.")).method_27692(class_124.field_1061));
        return 0;
    }

    private static void displayTextureNotificationInfo(class_2168 source, JsonObject notification) {
        source.method_9226(() -> class_2561.method_43470((String)("Notification Info for UUID: " + notification.get("name").getAsString())).method_27692(class_124.field_1054), true);
        source.method_9226(() -> class_2561.method_43470((String)("Friendly Name: " + notification.get("friendly_name").getAsString())), false);
        source.method_9226(() -> class_2561.method_43470((String)"Type: Texture"), false);
        source.method_9226(() -> class_2561.method_43470((String)("Namespace: " + notification.get("namespace").getAsString())), false);
        source.method_9226(() -> class_2561.method_43470((String)("Texture: " + notification.get("texture").getAsString())), false);
        source.method_9226(() -> class_2561.method_43470((String)("Width: " + notification.get("width").getAsInt())), false);
        source.method_9226(() -> class_2561.method_43470((String)("Height: " + notification.get("height").getAsInt())), false);
        source.method_9226(() -> class_2561.method_43470((String)("Dismiss Message: " + notification.get("dismissMessage").getAsBoolean())), false);
        source.method_9226(() -> class_2561.method_43470((String)("Always Show: " + notification.get("alwaysShow").getAsBoolean())), false);
    }

    private static void displayTextNotificationInfo(class_2168 source, JsonObject notification) {
        source.method_9226(() -> class_2561.method_43470((String)("Notification Info for UUID: " + notification.get("name").getAsString())).method_27692(class_124.field_1054), true);
        source.method_9226(() -> class_2561.method_43470((String)("Friendly Name: " + notification.get("friendly_name").getAsString())), false);
        source.method_9226(() -> class_2561.method_43470((String)"Type: Text"), false);
        source.method_9226(() -> class_2561.method_43470((String)("Message: " + notification.get("message").getAsString())), false);
        source.method_9226(() -> class_2561.method_43470((String)("Dismiss Message: " + notification.get("dismissMessage").getAsBoolean())), false);
        source.method_9226(() -> class_2561.method_43470((String)("Always Show: " + notification.get("alwaysShow").getAsBoolean())), false);
    }

    private static void displayURLNotificationInfo(class_2168 source, JsonObject notification) {
        source.method_9226(() -> class_2561.method_43470((String)("Notification Info for UUID: " + notification.get("name").getAsString())).method_27692(class_124.field_1054), true);
        source.method_9226(() -> class_2561.method_43470((String)("Friendly Name: " + notification.get("friendly_name").getAsString())), false);
        source.method_9226(() -> class_2561.method_43470((String)"Type: URL"), false);
        source.method_9226(() -> class_2561.method_43470((String)("URL: " + notification.get("url").getAsString())), false);
        source.method_9226(() -> class_2561.method_43470((String)("Width: " + notification.get("width").getAsInt())), false);
        source.method_9226(() -> class_2561.method_43470((String)("Height: " + notification.get("height").getAsInt())), false);
        source.method_9226(() -> class_2561.method_43470((String)("Dismiss Message: " + notification.get("dismissMessage").getAsBoolean())), false);
        source.method_9226(() -> class_2561.method_43470((String)("Always Show: " + notification.get("alwaysShow").getAsBoolean())), false);
    }

    private static void addNotification(class_2168 source, String friendlyName, String type, String soundNamespace, String soundPath, String urlOrMessageOrNamespace, String texture, int width, int height, boolean dismissButton, boolean dismissMessage, boolean alwaysShow) {
        JsonObject notification = new JsonObject();
        notification.addProperty("friendly_name", friendlyName);
        notification.addProperty("name", UUID.randomUUID().toString());
        notification.addProperty("type", type);
        notification.addProperty("sound_namespace", soundNamespace);
        notification.addProperty("sound_path", soundPath);
        switch (type.toLowerCase()) {
            case "texture": {
                notification.addProperty("namespace", urlOrMessageOrNamespace);
                notification.addProperty("texture", texture);
                notification.addProperty("width", (Number)width);
                notification.addProperty("height", (Number)height);
                notification.addProperty("dismissMessage", Boolean.valueOf(dismissMessage));
                notification.addProperty("alwaysShow", Boolean.valueOf(alwaysShow));
                break;
            }
            case "text": {
                notification.addProperty("message", urlOrMessageOrNamespace);
                notification.addProperty("dismissButton", Boolean.valueOf(dismissButton));
                notification.addProperty("dismissMessage", Boolean.valueOf(dismissMessage));
                notification.addProperty("alwaysShow", Boolean.valueOf(alwaysShow));
                break;
            }
            case "url": {
                notification.addProperty("url", urlOrMessageOrNamespace);
                notification.addProperty("width", (Number)width);
                notification.addProperty("height", (Number)height);
                notification.addProperty("dismissMessage", Boolean.valueOf(dismissMessage));
                notification.addProperty("alwaysShow", Boolean.valueOf(alwaysShow));
                break;
            }
            default: {
                source.method_9213(class_2561.method_30163((String)"Invalid notification type."));
                return;
            }
        }
        JsonObject configObject = NotificationConfig.loadConfig();
        JsonArray notificationsArray = configObject.getAsJsonArray("notifications");
        notificationsArray.add((JsonElement)notification);
        NotificationConfig.saveConfig(configObject);
        source.method_9226(() -> class_2561.method_30163((String)"Notification added successfully."), true);
    }

    private static void listNotifications(class_2168 source) {
        JsonObject configObject = NotificationConfig.loadConfig();
        JsonArray notificationsArray = configObject.getAsJsonArray("notifications");
        source.method_9226(() -> class_2561.method_43470((String)"Notifications List:").method_27692(class_124.field_1054), false);
        for (int i = 0; i < notificationsArray.size(); ++i) {
            JsonObject notification = notificationsArray.get(i).getAsJsonObject();
            String friendlyName = notification.get("friendly_name").getAsString();
            String type = notification.get("type").getAsString();
            source.method_9226(() -> class_2561.method_43470((String)("- " + friendlyName + " - " + type)), false);
        }
    }

    private static void listNotificationUUIDs(class_2168 source) {
        JsonObject configObject = NotificationConfig.loadConfig();
        JsonArray notificationsArray = configObject.getAsJsonArray("notifications");
        source.method_9226(() -> class_2561.method_43470((String)"Notification UUIDs:").method_27692(class_124.field_1054), false);
        for (int i = 0; i < notificationsArray.size(); ++i) {
            JsonObject notification = notificationsArray.get(i).getAsJsonObject();
            String uuid = notification.get("name").getAsString();
            String friendlyName = notification.get("friendly_name").getAsString();
            source.method_9226(() -> class_2561.method_43470((String)("- " + uuid + " - " + friendlyName)), false);
        }
    }

    private static void removeNotification(class_2168 source, String uuid) {
        JsonObject configObject = NotificationConfig.loadConfig();
        JsonArray notificationsArray = configObject.getAsJsonArray("notifications");
        for (int i = 0; i < notificationsArray.size(); ++i) {
            JsonObject notification = notificationsArray.get(i).getAsJsonObject();
            if (!notification.get("name").getAsString().equals(uuid)) continue;
            notificationsArray.remove(i);
            NotificationConfig.saveConfig(configObject);
            source.method_9226(() -> class_2561.method_43470((String)("Notification with UUID " + uuid + " removed successfully.")).method_27692(class_124.field_1060), true);
            return;
        }
        source.method_9226(() -> class_2561.method_43470((String)("Notification with UUID " + uuid + " not found.")).method_27692(class_124.field_1061), true);
    }

    private static void editNotification(class_2168 source, String uuid, String whatToEdit, String newValue) {
        JsonObject configObject = NotificationConfig.loadConfig();
        JsonArray notificationsArray = configObject.getAsJsonArray("notifications");
        for (int i = 0; i < notificationsArray.size(); ++i) {
            JsonObject notification = notificationsArray.get(i).getAsJsonObject();
            if (!notification.get("name").getAsString().equals(uuid)) continue;
            switch (whatToEdit.toLowerCase()) {
                case "friendly_name": {
                    notification.addProperty("friendly_name", newValue);
                    break;
                }
                case "type": {
                    notification.addProperty("type", newValue);
                    break;
                }
                case "sound_namespace": {
                    notification.addProperty("sound_namespace", newValue);
                    break;
                }
                case "sound_path": {
                    notification.addProperty("sound_path", newValue);
                    break;
                }
                case "namespace": {
                    notification.addProperty("namespace", newValue);
                    break;
                }
                case "texture": {
                    notification.addProperty("texture", newValue);
                    break;
                }
                case "width": {
                    notification.addProperty("width", (Number)Integer.parseInt(newValue));
                    break;
                }
                case "height": {
                    notification.addProperty("height", (Number)Integer.parseInt(newValue));
                    break;
                }
                case "dismissmessage": {
                    notification.addProperty("dismissMessage", Boolean.valueOf(Boolean.parseBoolean(newValue)));
                    break;
                }
                case "alwaysshow": {
                    notification.addProperty("alwaysShow", Boolean.valueOf(Boolean.parseBoolean(newValue)));
                    break;
                }
                case "message": {
                    notification.addProperty("message", newValue);
                    break;
                }
                case "url": {
                    notification.addProperty("url", newValue);
                    break;
                }
                case "dismissbutton": {
                    notification.addProperty("dismissButton", Boolean.valueOf(Boolean.parseBoolean(newValue)));
                    break;
                }
                default: {
                    source.method_9213(class_2561.method_30163((String)"Invalid property to edit."));
                    return;
                }
            }
            NotificationConfig.saveConfig(configObject);
            source.method_9226(() -> class_2561.method_43470((String)("Notification with UUID " + uuid + " edited successfully.")).method_27692(class_124.field_1060), true);
            return;
        }
        source.method_9226(() -> class_2561.method_43470((String)("Notification with UUID " + uuid + " not found.")).method_27692(class_124.field_1061), true);
    }
}

