/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.sn;

import com.dooji.sn.commands.NotificationCommands;
import com.dooji.sn.network.NotificationConfig;
import com.dooji.sn.network.NotificationPacket;
import com.dooji.sn.network.PacketHandler;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;
import net.minecraft.server.MinecraftServer;

public class ServerNotify
implements ModInitializer {
    public void onInitialize() {
        NotificationConfig.initConfig();
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
            PacketHandler.register();
        }
        ServerLifecycleEvents.SERVER_STARTED.register(server -> ServerPlayConnectionEvents.JOIN.register((handler, sender, server1) -> {
            JsonObject config = NotificationConfig.loadConfig();
            if (config != null) {
                JsonArray notifications = config.getAsJsonArray("notifications");
                for (int i = 0; i < notifications.size(); ++i) {
                    JsonObject notification = notifications.get(i).getAsJsonObject();
                    String name = notification.get("name").getAsString();
                    String type = notification.get("type").getAsString();
                    String sound_namespace = notification.get("sound_namespace").getAsString();
                    String sound_path = notification.get("sound_path").getAsString();
                    if (type.equals("texture")) {
                        String namespace = notification.get("namespace").getAsString();
                        String texture = notification.get("texture").getAsString();
                        int width = notification.get("width").getAsInt();
                        int height = notification.get("height").getAsInt();
                        boolean dismissMessage = notification.get("dismissMessage").getAsBoolean();
                        boolean alwaysShow = notification.get("alwaysShow").getAsBoolean();
                        NotificationPacket.sendTextureNotification(handler.field_14140, name, type, sound_namespace, sound_path, namespace, texture, width, height, dismissMessage, alwaysShow);
                        continue;
                    }
                    if (type.equals("text")) {
                        String message = notification.get("message").getAsString();
                        boolean dismissButton = notification.get("dismissButton").getAsBoolean();
                        boolean dismissMessage = notification.get("dismissMessage").getAsBoolean();
                        boolean alwaysShow = notification.get("alwaysShow").getAsBoolean();
                        NotificationPacket.sendTextNotification(handler.field_14140, name, type, sound_namespace, sound_path, message, dismissButton, dismissMessage, alwaysShow);
                        continue;
                    }
                    if (!type.equals("url")) continue;
                    String url = notification.get("url").getAsString();
                    int width = notification.get("width").getAsInt();
                    int height = notification.get("height").getAsInt();
                    boolean dismissMessage = notification.get("dismissMessage").getAsBoolean();
                    boolean alwaysShow = notification.get("alwaysShow").getAsBoolean();
                    NotificationPacket.sendURLNotification(handler.field_14140, name, type, sound_namespace, sound_path, url, width, height, dismissMessage, alwaysShow);
                }
            }
        }));
        ServerLifecycleEvents.SERVER_STARTED.register(this::registerCommands);
    }

    private void registerCommands(MinecraftServer server) {
        CommandDispatcher dispatcher = server.method_3734().method_9235();
        NotificationCommands.register((CommandDispatcher<class_2168>)dispatcher);
    }
}

