/*
 * Decompiled with CFR 0.152.
 */
package wile.redstonepen.blocks;

import com.google.common.collect.ImmutableMap;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.piston.MovingPistonBlock;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import wile.redstonepen.ModContent;
import wile.redstonepen.items.RedstonePenItem;
import wile.redstonepen.libmc.Auxiliaries;
import wile.redstonepen.libmc.Networking;
import wile.redstonepen.libmc.Registries;
import wile.redstonepen.libmc.RsSignals;
import wile.redstonepen.libmc.StandardBlocks;
import wile.redstonepen.libmc.StandardEntityBlocks;

public class RedstoneTrack {

    public static class TrackBlockEntity
    extends StandardEntityBlocks.StandardBlockEntity
    implements Networking.IPacketTileNotifyReceiver {
        private long state_flags_ = 0L;
        private final List<TrackNet> nets_ = new ArrayList<TrackNet>();
        private final Block[] block_change_tracking_ = new Block[]{Blocks.AIR, Blocks.AIR, Blocks.AIR, Blocks.AIR, Blocks.AIR, Blocks.AIR};
        private boolean trace_ = false;
        private static final List<Vec3i> updatepower_order = new ArrayList<Vec3i>();

        public TrackBlockEntity(BlockPos pos, BlockState state) {
            super(Registries.getBlockEntityTypeOfBlock(state.getBlock()), pos, state);
        }

        @Override
        public CompoundTag readnbt(HolderLookup.Provider hlp, CompoundTag nbt) {
            this.state_flags_ = nbt.getLong("sflags");
            this.nets_.clear();
            if (nbt.contains("nets", 9)) {
                ListTag lst = nbt.getList("nets", 10);
                try {
                    for (int i = 0; i < lst.size(); ++i) {
                        CompoundTag route_nbt = lst.getCompound(i);
                        this.nets_.add(new TrackNet(Arrays.stream(route_nbt.getLongArray("npos")).mapToObj(BlockPos::of).collect(Collectors.toList()), Arrays.stream(route_nbt.getIntArray("nsid")).mapToObj(Direction::from3DDataValue).collect(Collectors.toList()), Arrays.stream(route_nbt.getIntArray("ifac")).mapToObj(Direction::from3DDataValue).collect(Collectors.toList()), Arrays.stream(route_nbt.getIntArray("pfac")).mapToObj(Direction::from3DDataValue).collect(Collectors.toList()), route_nbt.getInt("power")));
                    }
                }
                catch (Throwable ex) {
                    this.nets_.clear();
                    Auxiliaries.logError("Dropped invalid NBT for Redstone Track at pos " + String.valueOf(this.getBlockPos()));
                }
            }
            return nbt;
        }

        @Override
        public CompoundTag writenbt(HolderLookup.Provider hlp, CompoundTag nbt, boolean sync_packet) {
            nbt.putLong("sflags", this.state_flags_);
            if (sync_packet) {
                return nbt;
            }
            if (!this.nets_.isEmpty()) {
                ListTag lst = new ListTag();
                for (TrackNet net : this.nets_) {
                    CompoundTag route_nbt = new CompoundTag();
                    route_nbt.putInt("power", net.power);
                    route_nbt.put("npos", (Tag)new LongArrayTag(net.neighbour_positions.stream().map(BlockPos::asLong).collect(Collectors.toList())));
                    route_nbt.put("nsid", (Tag)new IntArrayTag(net.neighbour_sides.stream().map(Direction::get3DDataValue).collect(Collectors.toList())));
                    route_nbt.put("ifac", (Tag)new IntArrayTag(net.internal_sides.stream().map(Direction::get3DDataValue).collect(Collectors.toList())));
                    route_nbt.put("pfac", (Tag)new IntArrayTag(net.power_sides.stream().map(Direction::get3DDataValue).collect(Collectors.toList())));
                    lst.add((Object)route_nbt);
                }
                nbt.put("nets", (Tag)lst);
            }
            return nbt;
        }

        @Override
        public void onServerPacketReceived(CompoundTag nbt) {
            this.readnbt((HolderLookup.Provider)this.getLevel().registryAccess(), nbt);
        }

        @Override
        public void onClientPacketReceived(Player player, CompoundTag nbt) {
        }

        @OnlyIn(value=Dist.CLIENT)
        public double getViewDistance() {
            return 64.0;
        }

        public boolean sync(boolean schedule) {
            if (this.level.isClientSide()) {
                return true;
            }
            this.setChanged();
            if (schedule && !this.getLevel().getBlockTicks().hasScheduledTick(this.getBlockPos(), (Object)ModContent.references.TRACK_BLOCK)) {
                this.getLevel().scheduleTick(this.getBlockPos(), (Block)ModContent.references.TRACK_BLOCK, 1);
            } else {
                Networking.PacketTileNotifyServerToClient.sendToPlayers(this, this.writenbt((HolderLookup.Provider)this.getLevel().registryAccess(), new CompoundTag(), true));
            }
            return true;
        }

        public long getStateFlags() {
            return this.state_flags_;
        }

        public int addWireFlags(long flags) {
            int n_added = 0;
            for (int i = 0; i < this.getWireFlagCount(); ++i) {
                long mask = 1L << i;
                if ((flags & mask) == 0L || (this.state_flags_ & mask) != 0L) continue;
                this.state_flags_ |= mask;
                ++n_added;
            }
            return n_added;
        }

        public int getWireFlags() {
            return (int)((this.state_flags_ & 0xFFFFFFL) >> 0);
        }

        public boolean getWireFlag(int index) {
            return (this.state_flags_ & 1L << 0 + index) != 0L;
        }

        public int getWireFlagCount() {
            return 24;
        }

        public int getConnectionFlags() {
            return (int)((this.state_flags_ & 0x3F000000L) >> 24);
        }

        public boolean getConnectionFlag(int index) {
            return (this.state_flags_ & 1L << 24 + index) != 0L;
        }

        public int getConnectionFlagCount() {
            return 6;
        }

        public int getSidePower(Direction side) {
            int shift = 32 + 4 * (Integer)defs.connections.CONNECTION_BIT_ORDER_REV.getOrDefault((Object)side, (Object)0);
            return (int)(this.state_flags_ >> shift & 0xFL);
        }

        public void setSidePower(Direction side, int p) {
            int shift = 32 + 4 * (Integer)defs.connections.CONNECTION_BIT_ORDER_REV.getOrDefault((Object)side, (Object)0);
            this.state_flags_ = this.state_flags_ & (15L << shift ^ 0xFFFFFFFFFFFFFFFFL) | (long)(p & 0xF) << shift;
        }

        public boolean hasVanillaRedstoneConnection(Direction side) {
            return defs.connections.hasVanillaWireConnection(this.getStateFlags(), side) || (this.state_flags_ & defs.connections.getBulkConnectorBit(side)) != 0L;
        }

        public int getRedstonePower(Direction redstone_side, boolean weak) {
            if (this.isRemoved()) {
                return 0;
            }
            Direction own_side = redstone_side.getOpposite();
            int p = 0;
            for (TrackNet net : this.nets_) {
                if (!net.power_sides.contains(own_side) || (p = Math.max(p, net.power)) < 15) continue;
                break;
            }
            p = p <= 0 || !this.getLevel().getBlockState(this.getBlockPos().relative(own_side)).is(Blocks.REDSTONE_WIRE) ? p : p - 1;
            return p;
        }

        public int getRedstoneDustCount() {
            int i;
            int n = 0;
            int rem = this.getWireFlags();
            for (i = 0; rem != 0 && i < 24; rem >>= 1, ++i) {
                if (((long)rem & 1L) == 0L) continue;
                ++n;
            }
            rem = this.getConnectionFlags();
            for (i = 0; rem != 0 && i < 6; rem >>= 1, ++i) {
                if (((long)rem & 1L) == 0L) continue;
                ++n;
            }
            return n;
        }

        public void toggle_trace(@Nullable Player player) {
            if (!Auxiliaries.isDevelopmentMode()) {
                this.trace_ = false;
                if (player != null) {
                    Auxiliaries.playerChatMessage(player, "Trace disabled, not in development mode.");
                }
            } else {
                boolean bl = this.trace_ = !this.trace_;
                if (player != null) {
                    Auxiliaries.playerChatMessage(player, "Trace: " + this.trace_);
                }
            }
        }

        private int modifySegments(BlockPos pos, Player player, ItemStack used_stack, Direction clicked_face, Vec3 hitvec, boolean no_add, boolean no_remove, boolean no_bulk) {
            int material_use;
            Direction face;
            block23: {
                long flip_mask;
                block22: {
                    boolean face_is_empty;
                    if (!used_stack.isEmpty() && used_stack.getItem() != Items.REDSTONE && !RedstonePenItem.isPen(used_stack)) {
                        return 0;
                    }
                    face = clicked_face.getOpposite();
                    Vec3 hit_r = hitvec.subtract(Vec3.atCenterOf((Vec3i)pos));
                    Vec3 hit = switch (clicked_face) {
                        case Direction.EAST, Direction.WEST -> hit_r.multiply(0.0, 1.0, 1.0);
                        case Direction.NORTH, Direction.SOUTH -> hit_r.multiply(1.0, 1.0, 0.0);
                        default -> hit_r.multiply(1.0, 0.0, 1.0);
                    };
                    Direction dir = Direction.getNearest((double)hit.x(), (double)hit.y(), (double)hit.z());
                    boolean bl = face_is_empty = ((long)this.getWireFlags() & defs.connections.getAllElementsOnFace(face)) == 0L;
                    if (!(no_bulk || face_is_empty || !(hit.length() < 0.1) || no_add && this.getConnectionFlags() == 0)) {
                        flip_mask = defs.connections.getBulkConnectorBit(face);
                    } else if (no_add || hit.length() > 0.11) {
                        flip_mask = defs.connections.getWireBit(face, dir);
                        if (!no_add) {
                            if (this.isAdjacentWireSegmentAddable(face, dir.getOpposite())) {
                                flip_mask |= defs.connections.getWireBit(face, dir.getOpposite());
                            }
                            if (this.isAdjacentWireSegmentAddable(face, dir.getClockWise(face.getAxis()))) {
                                flip_mask |= defs.connections.getWireBit(face, dir.getClockWise(face.getAxis()));
                            }
                            if (this.isAdjacentWireSegmentAddable(face, dir.getCounterClockWise(face.getAxis()))) {
                                flip_mask |= defs.connections.getWireBit(face, dir.getCounterClockWise(face.getAxis()));
                            }
                        }
                    } else {
                        flip_mask = 0L;
                    }
                    material_use = 0;
                    if ((this.state_flags_ & flip_mask) == 0L) break block22;
                    if (no_remove) break block23;
                    this.state_flags_ &= flip_mask ^ 0xFFFFFFFFFFFFFFFFL;
                    --material_use;
                    long bc = defs.connections.getBulkConnectorBit(face);
                    if ((this.state_flags_ & defs.connections.getAllElementsOnFace(face)) == bc) {
                        this.state_flags_ &= bc ^ 0xFFFFFFFFFFFFFFFFL;
                        --material_use;
                    }
                    if (this.getWireFlags() != 0) break block23;
                    material_use -= this.getRedstoneDustCount();
                    this.state_flags_ = 0L;
                    break block23;
                }
                if (!no_add) {
                    for (int i = 0; i < 32; ++i) {
                        long mask = 1L << i;
                        if ((flip_mask & mask) == 0L || (this.getStateFlags() & mask) != 0L) continue;
                        if (!RedstonePenItem.hasEnoughRedstone(used_stack, material_use + 1, player)) break;
                        this.state_flags_ |= mask;
                        ++material_use;
                    }
                }
            }
            if (material_use != 0) {
                int initial_side_power = this.getSidePower(face);
                this.setSidePower(face, 0);
                Map<BlockPos, BlockPos> change_notifications_before = this.updateAllPowerValuesFromAdjacent();
                Set net_neighbours_before = this.nets_.stream().filter(net -> net.internal_sides.contains(face)).map(net -> net.neighbour_positions).findFirst().map(HashSet::new).orElse(new HashSet());
                this.updateConnections(1);
                this.setSidePower(face, 0);
                Map<BlockPos, BlockPos> change_notifications_after = this.updateAllPowerValuesFromAdjacent();
                List<BlockPos> disconnected = change_notifications_before.keySet().stream().filter(p -> !change_notifications_after.containsKey(p)).collect(Collectors.toList());
                List<BlockPos> connected = change_notifications_after.keySet().stream().filter(p -> !change_notifications_before.containsKey(p)).collect(Collectors.toList());
                if (connected.isEmpty() && disconnected.isEmpty() && defs.connections.hasBulkConnection(this.getStateFlags(), face)) {
                    Set net_neighbours_after = this.nets_.stream().filter(net -> net.internal_sides.contains(face)).map(net -> net.neighbour_positions).findFirst().map(HashSet::new).orElse(new HashSet());
                    for (BlockPos p2 : net_neighbours_after) {
                        if (net_neighbours_before.contains(p2)) continue;
                        connected.add(p2);
                    }
                    for (BlockPos p2 : net_neighbours_before) {
                        if (net_neighbours_after.contains(p2)) continue;
                        disconnected.add(p2);
                    }
                }
                if (connected.isEmpty() && disconnected.isEmpty()) {
                    this.setSidePower(face, initial_side_power);
                } else {
                    this.setSidePower(face, 0);
                    this.nets_.forEach(net -> {
                        if (net.internal_sides.contains(face)) {
                            net.power = 0;
                        }
                    });
                    disconnected.forEach(p -> {
                        BlockEntity te = this.getLevel().getBlockEntity(p);
                        this.getLevel().getBlockState(p).handleNeighborChanged(this.getLevel(), p, (Block)this.getBlock(), pos, false);
                        if (te instanceof TrackBlockEntity) {
                            ((TrackBlockEntity)te).updateConnections(1);
                        }
                    });
                    connected.forEach(p -> {
                        BlockEntity te = this.getLevel().getBlockEntity(p);
                        if (te instanceof TrackBlockEntity) {
                            ((TrackBlockEntity)te).updateConnections(1);
                        }
                        this.getLevel().getBlockState(p).handleNeighborChanged(this.getLevel(), p, (Block)this.getBlock(), pos, false);
                        this.getBlock().neighborChanged(this.getBlockState(), this.getLevel(), this.getBlockPos(), this.getBlock(), (BlockPos)p, false);
                    });
                }
                this.sync(true);
            }
            return material_use;
        }

        private boolean isAdjacentWireSegmentAddable(Direction face, Direction dir) {
            if ((this.getStateFlags() & defs.connections.getWireBit(face, dir)) != 0L) {
                return false;
            }
            BlockPos pos = this.getBlockPos().relative(dir);
            TrackBlockEntity te = RedstoneTrackBlock.tile((BlockGetter)this.getLevel(), pos).orElse(null);
            if (te != null) {
                return (te.getStateFlags() & defs.connections.getWireBit(face, dir.getOpposite())) != 0L;
            }
            BlockState state = this.getLevel().getBlockState(pos);
            return state.is(Blocks.REDSTONE_WIRE) || state.isSignalSource();
        }

        public Map<BlockPos, BlockPos> updateAllPowerValuesFromAdjacent() {
            if (updatepower_order.isEmpty()) {
                for (Direction side : Direction.values()) {
                    updatepower_order.add(new Vec3i(0, 0, 0).relative(side, 1));
                }
                for (int x = -1; x <= 1; ++x) {
                    for (int y = -1; y <= 1; ++y) {
                        for (int z = -1; z <= 1; ++z) {
                            if (Math.abs(x) + Math.abs(y) + Math.abs(z) != 2) continue;
                            updatepower_order.add(new Vec3i(x, y, z));
                        }
                    }
                }
            }
            HashMap<BlockPos, BlockPos> all_change_notifications = new HashMap<BlockPos, BlockPos>();
            for (Vec3i ofs : updatepower_order) {
                this.handleNeighborChanged(this.getBlockPos().offset(ofs)).forEach(all_change_notifications::putIfAbsent);
            }
            return all_change_notifications;
        }

        private void spawnRedsoneItems(int count) {
            if (count <= 0) {
                return;
            }
            ItemEntity e = new ItemEntity(this.getLevel(), (double)this.getBlockPos().getX() + 0.5, (double)this.getBlockPos().getY() + 0.5, (double)this.getBlockPos().getZ() + 0.5, new ItemStack((ItemLike)Items.REDSTONE, count));
            e.setDefaultPickUpDelay();
            e.setDeltaMovement(new Vec3(this.getLevel().getRandom().nextDouble() - 0.5, this.getLevel().getRandom().nextDouble() - 0.5, this.getLevel().getRandom().nextDouble()).scale(0.1));
            this.getLevel().addFreshEntity((Entity)e);
        }

        private RedstoneTrackBlock getBlock() {
            return ModContent.references.TRACK_BLOCK;
        }

        public boolean handleShapeUpdate(Direction facing, BlockState facingState, BlockPos fromPos, boolean isMoving) {
            Block bltv;
            long to_remove;
            long new_flags;
            boolean update_neighbours = false;
            if (!RedstoneTrackBlock.canBePlacedOnFace(facingState, this.getLevel(), fromPos, facing.getOpposite()) && (new_flags = this.state_flags_ & ((to_remove = defs.connections.getAllElementsOnFace(facing)) ^ 0xFFFFFFFFFFFFFFFFL)) != this.state_flags_) {
                if (this.trace_) {
                    Auxiliaries.logWarn(String.format("SHUP: %s <-%s(=%s) removed.", TrackBlockEntity.posstr(this.getBlockPos()), TrackBlockEntity.posstr(fromPos), facingState.getBlock().getDescriptionId()));
                }
                int count = this.getRedstoneDustCount();
                this.state_flags_ = new_flags;
                this.spawnRedsoneItems(count -= this.getRedstoneDustCount());
                this.updateConnections(1);
                update_neighbours = true;
            }
            if ((bltv = this.block_change_tracking_[facing.get3DDataValue()]) != facingState.getBlock()) {
                if (bltv == null) {
                    bltv = Blocks.AIR;
                }
                if (this.trace_) {
                    Auxiliaries.logWarn(String.format("SHUP: %s <-%s changed (%s->%s).", TrackBlockEntity.posstr(this.getBlockPos()), TrackBlockEntity.posstr(fromPos), bltv.getDescriptionId(), facingState.getBlock().getDescriptionId()));
                }
                this.block_change_tracking_[facing.get3DDataValue()] = facingState.getBlock();
                if (!isMoving && bltv != Blocks.REDSTONE_BLOCK) {
                    this.updateConnections(1);
                }
                update_neighbours = true;
            }
            if (update_neighbours) {
                Level world = this.getLevel();
                RedstoneTrackBlock block = this.getBlock();
                this.handleNeighborChanged(fromPos).forEach((chpos, frpos) -> world.neighborChanged(chpos, block, frpos));
            }
            return this.getWireFlags() != 0;
        }

        private int getNonWireSignal(Level world, BlockPos pos, Direction redstone_side) {
            int p_in;
            Direction rs_side;
            BlockPos side_pos;
            BlockState side_state;
            int p;
            this.getBlock().disablePower(true);
            BlockState state = world.getBlockState(pos);
            int n = p = !state.is(Blocks.REDSTONE_WIRE) && !state.is((Block)this.getBlock()) ? state.getSignal((BlockGetter)world, pos, redstone_side) : 0;
            if (!RsSignals.canEmitWeakPower(state, world, pos, redstone_side)) {
                this.getBlock().disablePower(false);
                return p;
            }
            Direction[] directionArray = Direction.values();
            int n2 = directionArray.length;
            for (int i = 0; i < n2 && ((side_state = world.getBlockState(side_pos = pos.relative(rs_side = directionArray[i]))).is(Blocks.REDSTONE_WIRE) || side_state.is((Block)this.getBlock()) || (p_in = side_state.getDirectSignal((BlockGetter)world, side_pos, rs_side)) <= p || (p = p_in) < 15); ++i) {
            }
            this.getBlock().disablePower(false);
            return p;
        }

        private boolean isNetConnectedTo(BlockPos pos, TrackNet net, BlockPos otherPos, @Nullable Direction otherSide, @Nullable TrackNet otherNet) {
            if (otherNet == null) {
                return net.neighbour_positions.stream().anyMatch(np -> np.equals((Object)otherPos));
            }
            for (int i = 0; i < net.neighbour_positions.size(); ++i) {
                if (!net.neighbour_positions.get(i).equals((Object)otherPos)) continue;
                Direction nb_side = net.neighbour_sides.get(i);
                if (otherSide != null && !otherSide.equals((Object)nb_side) || !otherNet.internal_sides.contains(nb_side)) continue;
                return true;
            }
            return false;
        }

        public Map<BlockPos, BlockPos> handleNeighborChanged(BlockPos fromPos) {
            LinkedHashMap<BlockPos, BlockPos> notifications = new LinkedHashMap<BlockPos, BlockPos>();
            this.nets_.stream().filter(net -> net.neighbour_positions.contains(fromPos)).forEach(net -> this.handleNetNeighborChanged((TrackNet)net, fromPos, null, (Map<BlockPos, BlockPos>)notifications));
            notifications.remove(fromPos);
            if (this.trace_ && notifications.size() > 0) {
                Auxiliaries.logWarn(String.format("NBCH: %s updates: [%s]", TrackBlockEntity.posstr(this.getBlockPos()), notifications.entrySet().stream().map(kv -> TrackBlockEntity.posstr((BlockPos)kv.getValue()) + ">" + TrackBlockEntity.posstr((BlockPos)kv.getKey())).collect(Collectors.joining(", "))));
            }
            return notifications;
        }

        public void handleNetNeighborChanged(TrackNet net, BlockPos fromPos, @Nullable TrackNet fromNet, @Nullable Map<BlockPos, BlockPos> change_notifications) {
            BlockPos my_pos = this.getBlockPos();
            if (!this.isNetConnectedTo(my_pos, net, fromPos, null, fromNet)) {
                return;
            }
            Level world = this.getLevel();
            record Neighbor(BlockPos pos, Direction side, int power, boolean direct_update, boolean needs_indirect) {
            }
            LinkedList<Neighbor> neighbors = new LinkedList<Neighbor>();
            if (this.trace_) {
                Auxiliaries.logWarn(String.format("NBCH: %s from %s (%s)", TrackBlockEntity.posstr(my_pos), TrackBlockEntity.posstr(fromPos), world.getBlockState(fromPos).getBlock().getDescriptionId()));
            }
            int pmax = 0;
            for (int i = 0; i < net.neighbour_positions.size(); ++i) {
                int p_nowire;
                BlockPos ext_pos = net.neighbour_positions.get(i);
                Direction ext_side = net.neighbour_sides.get(i);
                BlockState ext_state = this.level.getBlockState(ext_pos);
                if (ext_state.is(Blocks.REDSTONE_WIRE)) {
                    int p_vanilla_wire = (Integer)ext_state.getValue((Property)RedStoneWireBlock.POWER);
                    neighbors.add(new Neighbor(ext_pos, ext_side, p_vanilla_wire, false, false));
                    pmax = Math.max(pmax, p_vanilla_wire - 1);
                    continue;
                }
                if (ext_state.is((Block)this.getBlock())) {
                    TrackNet nb_net = RedstoneTrackBlock.tile((BlockGetter)world, ext_pos).flatMap(te -> te.nets_.stream().filter(nbn -> this.isNetConnectedTo(my_pos, net, ext_pos, ext_side, (TrackNet)nbn)).findFirst()).orElse(null);
                    if (nb_net == null) continue;
                    int p_track = Math.max(0, nb_net.power);
                    neighbors.add(new Neighbor(ext_pos, ext_side, p_track, true, false));
                    pmax = Math.max(pmax, p_track - 1);
                    continue;
                }
                if (ext_state.is((Block)ModContent.references.BRIDGE_RELAY_BLOCK)) {
                    p_nowire = this.getNonWireSignal(world, ext_pos, ext_side.getOpposite());
                    neighbors.add(new Neighbor(ext_pos, ext_side, p_nowire, true, false));
                    pmax = Math.max(pmax, p_nowire);
                    continue;
                }
                p_nowire = this.getNonWireSignal(world, ext_pos, ext_side.getOpposite());
                boolean weak_updates = !ext_state.isSignalSource() && p_nowire == 0 && ext_state.isRedstoneConductor((BlockGetter)world, ext_pos);
                neighbors.add(new Neighbor(ext_pos, ext_side, p_nowire, false, weak_updates));
                pmax = Math.max(pmax, p_nowire);
            }
            boolean power_changed = false;
            if (net.power != pmax) {
                if (this.trace_) {
                    Auxiliaries.logWarn(String.format("NBCH: %s net power %d->%d", TrackBlockEntity.posstr(my_pos), net.power, pmax));
                }
                net.power = pmax;
                power_changed = true;
            }
            for (Direction side : net.internal_sides) {
                if (this.getSidePower(side) == pmax) continue;
                this.setSidePower(side, pmax);
                power_changed = true;
            }
            if (!power_changed) {
                return;
            }
            for (Neighbor neighbor : neighbors) {
                if (neighbor.direct_update) {
                    BlockEntity blockEntity = world.getBlockEntity(neighbor.pos);
                    if (blockEntity instanceof TrackBlockEntity) {
                        TrackBlockEntity te2 = (TrackBlockEntity)blockEntity;
                        for (TrackNet nb_net : te2.nets_) {
                            te2.handleNetNeighborChanged(nb_net, my_pos, net, change_notifications);
                        }
                        continue;
                    }
                    world.getBlockState(neighbor.pos).handleNeighborChanged(world, neighbor.pos, (Block)this.getBlock(), my_pos, false);
                    continue;
                }
                change_notifications.putIfAbsent(neighbor.pos, my_pos);
                if (!neighbor.needs_indirect) continue;
                for (Direction update_direction : defs.REDSTONE_UPDATE_DIRECTIONS) {
                    if (neighbor.side == update_direction) continue;
                    change_notifications.putIfAbsent(neighbor.pos.relative(update_direction), neighbor.pos);
                }
            }
            this.sync(true);
        }

        private static String posstr(BlockPos pos) {
            return "[" + pos.getX() + "," + pos.getY() + "," + pos.getZ() + "]";
        }

        private static String dirstr(@Nullable Direction dir) {
            return dir == null ? "?" : dir.toString().substring(0, 1);
        }

        private boolean isRedstoneInsulator(BlockState state, BlockPos pos) {
            return state.is(Blocks.GLASS) || state.is(Blocks.AIR);
        }

        private void updateConnections(int recursion_left) {
            HashSet all_neighbours = new HashSet();
            int[] current_side_powers = new int[]{0, 0, 0, 0, 0, 0};
            HashSet<TrackBlockEntity> track_connection_updates = new HashSet<TrackBlockEntity>();
            long[] internal_connected_sides = new long[]{0L, 0L, 0L, 0L, 0L, 0L};
            long[] external_connected_routes = new long[]{0L, 0L, 0L, 0L, 0L, 0L};
            this.nets_.forEach(net -> {
                net.internal_sides.forEach(ps -> {
                    current_side_powers[ps.ordinal()] = net.power;
                });
                all_neighbours.addAll(net.neighbour_positions);
            });
            if (this.trace_) {
                Auxiliaries.logWarn(String.format("UCON: %s SIDPW: [%01x %01x %01x %01x %01x %01x]", TrackBlockEntity.posstr(this.getBlockPos()), current_side_powers[0], current_side_powers[1], current_side_powers[2], current_side_powers[3], current_side_powers[4], current_side_powers[5]));
            }
            this.nets_.clear();
            long external_connection_flags = this.getStateFlags() & 0x3FFFFFFFL;
            for (Map.Entry kv : defs.connections.INTERNAL_EDGE_CONNECTION_MAPPING.entrySet()) {
                long wire_bit_pair = (Long)kv.getKey();
                if ((this.getStateFlags() & wire_bit_pair) != wire_bit_pair) continue;
                external_connection_flags &= wire_bit_pair ^ 0xFFFFFFFFFFFFFFFFL;
                for (int i = 0; i < 6; ++i) {
                    if ((15L << 4 * i & wire_bit_pair) == 0L) continue;
                    int n = i;
                    internal_connected_sides[n] = internal_connected_sides[n] | wire_bit_pair;
                }
            }
            if (this.trace_) {
                Auxiliaries.logWarn(String.format("UCON: %s CONFL: ext:%08x | int:[%08x %08x %08x %08x %08x %08x]", TrackBlockEntity.posstr(this.getBlockPos()), external_connection_flags, internal_connected_sides[0], internal_connected_sides[1], internal_connected_sides[2], internal_connected_sides[3], internal_connected_sides[4], internal_connected_sides[5]));
            }
            for (int k = 0; k < 2; ++k) {
                for (int i = 0; i < 6; ++i) {
                    if (internal_connected_sides[i] == 0L) continue;
                    for (int j = i + 1; j < 6; ++j) {
                        if ((internal_connected_sides[i] & internal_connected_sides[j]) == 0L) continue;
                        int n = i;
                        internal_connected_sides[n] = internal_connected_sides[n] | internal_connected_sides[j];
                        internal_connected_sides[j] = 0L;
                    }
                }
            }
            for (int i = 0; i < 6; ++i) {
                if (internal_connected_sides[i] != 0L) {
                    for (int j = i; j < 6; ++j) {
                        long mask = 15L << 4 * j;
                        if ((internal_connected_sides[i] & mask) == 0L) continue;
                        long bulk = 1L << 24 + j;
                        int n = i;
                        external_connected_routes[n] = external_connected_routes[n] | external_connection_flags & (mask | bulk);
                        external_connection_flags &= (mask | bulk) ^ 0xFFFFFFFFFFFFFFFFL;
                    }
                    continue;
                }
                long mask = 15L << 4 * i;
                long bulk = 1L << 24 + i;
                int n = i;
                external_connected_routes[n] = external_connected_routes[n] | external_connection_flags & (mask | bulk);
                external_connection_flags &= (mask | bulk) ^ 0xFFFFFFFFFFFFFFFFL;
            }
            if (this.trace_) {
                Auxiliaries.logWarn(String.format("UCON: %s CONSD: ext:%08x | int:[%08x %08x %08x %08x %08x %08x]", TrackBlockEntity.posstr(this.getBlockPos()), external_connection_flags, internal_connected_sides[0], internal_connected_sides[1], internal_connected_sides[2], internal_connected_sides[3], internal_connected_sides[4], internal_connected_sides[5]));
                Auxiliaries.logWarn(String.format("UCON: %s CONRT: ext:%08x | ext:[%08x %08x %08x %08x %08x %08x]", TrackBlockEntity.posstr(this.getBlockPos()), external_connection_flags, external_connected_routes[0], external_connected_routes[1], external_connected_routes[2], external_connected_routes[3], external_connected_routes[4], external_connected_routes[5]));
            }
            HashSet used_sides = new HashSet();
            for (int i = 0; i < 6; ++i) {
                if (external_connected_routes[i] == 0L) continue;
                HashSet<Direction> int_sides = new HashSet<Direction>();
                ArrayList<Direction> pwr_sides = new ArrayList<Direction>(6);
                ArrayList<BlockPos> positions = new ArrayList<BlockPos>(6);
                ArrayList<Direction> ext_sides = new ArrayList<Direction>(6);
                for (int j = 0; j < 6; ++j) {
                    long mask = 15L << 4 * j;
                    long bulk = 1L << 24 + j;
                    Direction side2 = defs.connections.CONNECTION_BIT_ORDER[j];
                    if ((internal_connected_sides[i] & mask) != 0L) {
                        int_sides.add(side2);
                    }
                    if ((external_connected_routes[i] & mask) != 0L) {
                        for (int k = 0; k < 4; ++k) {
                            long wire_bit = 1L << 4 * j + k;
                            if ((external_connected_routes[i] & wire_bit) == 0L) continue;
                            Tuple<Direction, Direction> side_dir = defs.connections.getWireBitSideAndDirection(wire_bit);
                            Direction tsid = (Direction)side_dir.getA();
                            Direction tdir = (Direction)side_dir.getB();
                            BlockPos wire_pos = this.getBlockPos().relative(tdir);
                            BlockState wire_state = this.getLevel().getBlockState(wire_pos);
                            boolean diagonal_check = false;
                            if (wire_state.is((Block)this.getBlock())) {
                                long adjacent_mask = defs.connections.getWireBit(tsid, tdir.getOpposite());
                                TrackBlockEntity adj_te = RedstoneTrackBlock.tile((BlockGetter)this.getLevel(), wire_pos).orElse(null);
                                if (adj_te == null || (adj_te.getStateFlags() & adjacent_mask) != adjacent_mask) {
                                    diagonal_check = true;
                                } else {
                                    positions.add(wire_pos);
                                    ext_sides.add(tsid);
                                    int_sides.add(side2);
                                    pwr_sides.add(tdir);
                                    track_connection_updates.add(adj_te);
                                    continue;
                                }
                            }
                            if (!diagonal_check && wire_state.is(Blocks.REDSTONE_WIRE)) {
                                if (side2 != Direction.DOWN) {
                                    diagonal_check = true;
                                } else {
                                    positions.add(wire_pos);
                                    ext_sides.add(tdir.getOpposite());
                                    int_sides.add(side2);
                                    pwr_sides.add(tdir);
                                    continue;
                                }
                            }
                            if (!diagonal_check && wire_state.isSignalSource()) {
                                positions.add(wire_pos);
                                ext_sides.add(tdir.getOpposite());
                                int_sides.add(side2);
                                pwr_sides.add(tdir);
                                continue;
                            }
                            BlockPos track_pos = wire_pos.relative(tsid);
                            BlockState track_state = this.getLevel().getBlockState(track_pos);
                            if (track_state.is((Block)this.getBlock())) {
                                long adjacent_mask = defs.connections.getWireBit(tdir.getOpposite(), tsid.getOpposite());
                                TrackBlockEntity adj_te = RedstoneTrackBlock.tile((BlockGetter)this.getLevel(), track_pos).orElse(null);
                                if (adj_te == null || (adj_te.getStateFlags() & adjacent_mask) != adjacent_mask) continue;
                                positions.add(track_pos);
                                ext_sides.add(tdir.getOpposite());
                                int_sides.add(side2);
                                pwr_sides.add(tdir);
                                track_connection_updates.add(adj_te);
                                continue;
                            }
                            if (this.isRedstoneInsulator(wire_state, wire_pos)) continue;
                            positions.add(wire_pos);
                            ext_sides.add(tdir.getOpposite());
                            int_sides.add(side2);
                            pwr_sides.add(tdir);
                        }
                    }
                    if ((external_connected_routes[i] & bulk) == 0L) continue;
                    BlockPos bulk_pos = this.getBlockPos().relative(side2);
                    BlockState bulk_state = this.getLevel().getBlockState(bulk_pos);
                    if (this.isRedstoneInsulator(bulk_state, bulk_pos)) continue;
                    positions.add(bulk_pos);
                    ext_sides.add(side2.getOpposite());
                    int_sides.add(side2);
                    pwr_sides.add(side2);
                }
                if (positions.isEmpty()) continue;
                TrackNet net2 = new TrackNet(positions, ext_sides, new ArrayList<Direction>(int_sides), new ArrayList<Direction>(pwr_sides));
                net2.power = net2.internal_sides.stream().mapToInt(side -> current_side_powers[side.ordinal()]).max().orElse(0);
                this.nets_.add(net2);
                used_sides.addAll(int_sides);
            }
            Arrays.stream(Direction.values()).filter(side -> !used_sides.contains(side)).forEach(side -> this.setSidePower((Direction)side, 0));
            this.setChanged();
            HashSet disconnected_neighbours = new HashSet(all_neighbours);
            HashSet connected_neighbours = new HashSet();
            this.nets_.forEach(net -> net.neighbour_positions.forEach(disconnected_neighbours::remove));
            this.nets_.forEach(net -> connected_neighbours.addAll(net.neighbour_positions));
            all_neighbours.forEach(connected_neighbours::remove);
            if (this.trace_) {
                String poss = TrackBlockEntity.posstr(this.getBlockPos());
                for (TrackNet net3 : this.nets_) {
                    ArrayList<CallSite> ss = new ArrayList<CallSite>();
                    for (int i = 0; i < net3.neighbour_positions.size(); ++i) {
                        ss.add((CallSite)((Object)(TrackBlockEntity.posstr(net3.neighbour_positions.get(i)) + ":" + net3.neighbour_sides.get(i).toString())));
                    }
                    String int_sides = net3.internal_sides.stream().map(Direction::toString).collect(Collectors.joining(","));
                    String pwr_sides = net3.power_sides.stream().map(Direction::toString).collect(Collectors.joining(","));
                    Auxiliaries.logWarn(String.format("UCON: %s adj:%s | ints:%s | pwrs:%s", poss, String.join((CharSequence)", ", ss), int_sides, pwr_sides));
                }
                if (!disconnected_neighbours.isEmpty()) {
                    Auxiliaries.logWarn(String.format("UCON: %s DISCONNECTED NEIGHBOURS: %s", TrackBlockEntity.posstr(this.getBlockPos()), disconnected_neighbours.stream().map(TrackBlockEntity::posstr).collect(Collectors.joining(","))));
                }
                if (!connected_neighbours.isEmpty()) {
                    Auxiliaries.logWarn(String.format("UCON: %s CONNECTED NEIGHBOURS: %s", TrackBlockEntity.posstr(this.getBlockPos()), connected_neighbours.stream().map(TrackBlockEntity::posstr).collect(Collectors.joining(","))));
                }
            }
            new HashSet(disconnected_neighbours).forEach(p -> RedstoneTrackBlock.tile((BlockGetter)this.getLevel(), p).ifPresent(te -> {
                track_connection_updates.add((TrackBlockEntity)te);
                disconnected_neighbours.remove(p);
            }));
            if (this.trace_ && !disconnected_neighbours.isEmpty()) {
                Auxiliaries.logWarn(String.format("UCON: %s DISCONNECTED NONTRACK: %s", TrackBlockEntity.posstr(this.getBlockPos()), disconnected_neighbours.stream().map(TrackBlockEntity::posstr).collect(Collectors.joining(","))));
            }
            if (recursion_left > 0) {
                for (TrackBlockEntity te : track_connection_updates) {
                    if (this.trace_) {
                        Auxiliaries.logWarn(String.format("UCON: %s UPDATE NET OF %s", TrackBlockEntity.posstr(this.getBlockPos()), TrackBlockEntity.posstr(te.getBlockPos())));
                    }
                    te.updateConnections(recursion_left - 1);
                }
            }
            this.nets_.stream().filter(net -> net.power > 0).forEach(net -> all_neighbours.addAll(net.neighbour_positions));
            Level world = this.getLevel();
            BlockState state = this.getBlockState();
            all_neighbours.forEach(pos -> {
                BlockState st = world.getBlockState(pos);
                if (this.trace_) {
                    Auxiliaries.logWarn(String.format("UCON: %s UPDATE TRACK CHANGES TO %s.", TrackBlockEntity.posstr(this.getBlockPos()), TrackBlockEntity.posstr(pos)));
                }
                st.handleNeighborChanged(world, pos, state.getBlock(), this.getBlockPos(), false);
                world.updateNeighborsAt(pos, st.getBlock());
            });
        }

        public static class TrackNet {
            public final List<BlockPos> neighbour_positions;
            public final List<Direction> neighbour_sides;
            public final List<Direction> internal_sides;
            public final List<Direction> power_sides;
            public int power;

            public TrackNet(List<BlockPos> positions, List<Direction> ext_sides, List<Direction> int_sides, List<Direction> pwr_sides) {
                this.neighbour_positions = positions;
                this.neighbour_sides = ext_sides;
                this.internal_sides = int_sides;
                this.power_sides = pwr_sides;
                this.power = 0;
            }

            public TrackNet(List<BlockPos> positions, List<Direction> ext_sides, List<Direction> int_sides, List<Direction> pwr_sides, int power_setval) {
                this.neighbour_positions = positions;
                this.neighbour_sides = ext_sides;
                this.internal_sides = int_sides;
                this.power_sides = pwr_sides;
                this.power = power_setval;
            }

            public String toString() {
                Object s = "NET{";
                s = (String)s + "p:" + this.power;
                s = (String)s + ", intsides:" + String.join((CharSequence)"", this.internal_sides.stream().map(TrackBlockEntity::dirstr).toList());
                s = (String)s + ", pwrsides:" + String.join((CharSequence)"", this.power_sides.stream().map(TrackBlockEntity::dirstr).toList());
                s = (String)s + ", nbsides:" + String.join((CharSequence)"", this.neighbour_sides.stream().map(TrackBlockEntity::dirstr).toList());
                s = (String)s + ", nbpos:" + String.join((CharSequence)",", this.neighbour_positions.stream().map(TrackBlockEntity::posstr).toList());
                return (String)s + "}";
            }
        }
    }

    public static class RedstoneTrackBlock
    extends StandardBlocks.WaterLoggable
    implements EntityBlock {
        private boolean can_provide_power_ = true;

        public RedstoneTrackBlock(long config, BlockBehaviour.Properties builder) {
            super(config, builder.pushReaction(PushReaction.DESTROY));
        }

        public static Optional<TrackBlockEntity> tile(BlockGetter world, BlockPos pos) {
            BlockEntity te = world.getBlockEntity(pos);
            return te instanceof TrackBlockEntity && !te.isRemoved() ? Optional.of((TrackBlockEntity)te) : Optional.empty();
        }

        public static boolean canBePlacedOnFace(BlockState state, Level world, BlockPos pos, Direction face) {
            if (state.getBlock() instanceof PistonBaseBlock) {
                Direction pface = (Direction)state.getValue((Property)PistonBaseBlock.FACING);
                return face != pface;
            }
            if (state.getBlock() instanceof MovingPistonBlock) {
                return true;
            }
            if (state.is(Blocks.HOPPER)) {
                return face == Direction.UP;
            }
            return state.isFaceSturdy((BlockGetter)world, pos, face);
        }

        @Override
        protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
            super.createBlockStateDefinition(builder);
        }

        public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
            return new TrackBlockEntity(pos, state);
        }

        @Override
        public boolean hasDynamicDropList() {
            return true;
        }

        @Override
        public List<ItemStack> dropList(BlockState state, Level world, @Nullable BlockEntity te, boolean explosion) {
            if (!(te instanceof TrackBlockEntity)) {
                return Collections.emptyList();
            }
            int num_connections = ((TrackBlockEntity)te).getRedstoneDustCount();
            if (num_connections <= 0) {
                return Collections.emptyList();
            }
            return Collections.singletonList(new ItemStack((ItemLike)Items.REDSTONE, num_connections));
        }

        @Override
        @Nullable
        public BlockState getStateForPlacement(BlockPlaceContext context) {
            return context.getLevel().getBlockState(context.getClickedPos()).canBeReplaced(context) ? super.getStateForPlacement(context) : null;
        }

        public Item asItem() {
            return Items.REDSTONE;
        }

        @Override
        public boolean isPathfindable(BlockState state, PathComputationType type) {
            return true;
        }

        @Override
        public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
            int wires = RedstoneTrackBlock.tile(world, pos).map(TrackBlockEntity::getWireFlags).orElse(0);
            int faces = ((wires & 0xF) != 0 ? 1 : 0) | ((wires & 0xF0) != 0 ? 2 : 0) | ((wires & 0xF00) != 0 ? 4 : 0) | ((wires & 0xF000) != 0 ? 8 : 0) | ((wires & 0xF0000) != 0 ? 16 : 0) | ((wires & 0xF00000) != 0 ? 32 : 0);
            return defs.shape.get(faces);
        }

        @Override
        public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
            return Shapes.empty();
        }

        @Override
        public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
            return (Boolean)state.getValue((Property)WATERLOGGED) == false;
        }

        public boolean useShapeForLightOcclusion(BlockState state) {
            return true;
        }

        public RenderShape getRenderShape(BlockState state) {
            return RenderShape.ENTITYBLOCK_ANIMATED;
        }

        public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
            return true;
        }

        @Deprecated
        public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, @Nullable Direction side) {
            return side != null && RedstoneTrackBlock.tile(world, pos).map(te -> te.hasVanillaRedstoneConnection(side.getOpposite())).orElse(false) != false;
        }

        public boolean isSignalSource(BlockState state) {
            return this.can_provide_power_;
        }

        public int getSignal(BlockState state, BlockGetter world, BlockPos pos, Direction redstone_side) {
            return this.can_provide_power_ ? RedstoneTrackBlock.tile(world, pos).map(te -> te.getRedstonePower(redstone_side, true)).orElse(0) : 0;
        }

        public int getDirectSignal(BlockState state, BlockGetter world, BlockPos pos, Direction redstone_side) {
            return this.can_provide_power_ ? RedstoneTrackBlock.tile(world, pos).map(te -> te.getRedstonePower(redstone_side, false)).orElse(0) : 0;
        }

        @Override
        public boolean shouldCheckWeakPower(BlockState state, LevelReader level, BlockPos pos, Direction side) {
            return false;
        }

        public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource rnd) {
            if (!RedstoneTrackBlock.tile((BlockGetter)world, pos).map(te -> te.sync(false)).orElse(false).booleanValue()) {
                world.removeBlock(pos, false);
            }
        }

        @Override
        public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos pos, BlockPos facingPos) {
            if (!world.isClientSide()) {
                if (RedstoneTrackBlock.tile((BlockGetter)world, pos).map(te -> te.handleShapeUpdate(facing, facingState, facingPos, false)).orElse(true).booleanValue()) {
                    world.scheduleTick(pos, (Block)this, 1);
                } else {
                    world.removeBlock(pos, false);
                }
            }
            return super.updateShape(state, facing, facingState, world, pos, facingPos);
        }

        @Override
        public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
            if (isMoving || state.is(newState.getBlock())) {
                return;
            }
            super.onRemove(state, world, pos, newState, isMoving);
            if (world.isClientSide()) {
                return;
            }
            this.notifyAdjacent(world, pos);
        }

        protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult rtr) {
            return this.modifySegments(state, world, pos, player, ItemStack.EMPTY, InteractionHand.MAIN_HAND, rtr, true, false);
        }

        protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rtr) {
            if (stack.is(Items.DEBUG_STICK)) {
                if (world.isClientSide) {
                    return ItemInteractionResult.SUCCESS;
                }
                BlockEntity blockEntity = world.getBlockEntity(pos);
                if (blockEntity instanceof TrackBlockEntity) {
                    TrackBlockEntity te = (TrackBlockEntity)blockEntity;
                    te.toggle_trace(player);
                }
                return ItemInteractionResult.CONSUME;
            }
            return switch (this.modifySegments(state, world, pos, player, stack, hand, rtr, false, RedstonePenItem.isPen(stack))) {
                default -> throw new MatchException(null, null);
                case InteractionResult.SUCCESS -> ItemInteractionResult.SUCCESS;
                case InteractionResult.CONSUME -> ItemInteractionResult.CONSUME;
                case InteractionResult.PASS -> ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
                case InteractionResult.FAIL -> ItemInteractionResult.FAIL;
                case InteractionResult.CONSUME_PARTIAL -> ItemInteractionResult.CONSUME_PARTIAL;
                case InteractionResult.SUCCESS_NO_ITEM_USED -> ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            };
        }

        public void neighborChanged(BlockState state, Level world, BlockPos pos, Block fromBlock, BlockPos fromPos, boolean isMoving) {
            block5: {
                if (world.isClientSide()) {
                    return;
                }
                try {
                    Map blocks_to_update = RedstoneTrackBlock.tile((BlockGetter)world, pos).map(te -> te.handleNeighborChanged(fromPos)).orElse(Collections.emptyMap());
                    if (blocks_to_update.isEmpty()) {
                        return;
                    }
                    for (Map.Entry update_pos : blocks_to_update.entrySet()) {
                        if (((BlockPos)update_pos.getKey()).equals(update_pos.getValue())) continue;
                        world.neighborChanged((BlockPos)update_pos.getKey(), (Block)this, (BlockPos)update_pos.getValue());
                    }
                }
                catch (Throwable ex) {
                    Auxiliaries.logError("Track neighborChanged recursion detected, dropping!");
                    int num_redstone = RedstoneTrackBlock.tile((BlockGetter)world, pos).map(TrackBlockEntity::getRedstoneDustCount).orElse(0);
                    if (num_redstone <= 0) break block5;
                    Vec3 p = Vec3.atCenterOf((Vec3i)pos);
                    world.addFreshEntity((Entity)new ItemEntity(world, p.x, p.y, p.z, new ItemStack((ItemLike)Items.REDSTONE, num_redstone)));
                    world.setBlock(pos, world.getBlockState(pos).getFluidState().createLegacyBlock(), 18);
                }
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        private void spawnPoweredParticle(Level world, RandomSource rand, BlockPos pos, Vec3 color, Direction from, Direction to, float minChance, float maxChance) {
            float f = maxChance - minChance;
            if (rand.nextFloat() < 0.3f * f) {
                double c1 = 0.4375;
                double c2 = minChance + f * rand.nextFloat();
                double p0 = 0.5 + c1 * (double)from.getStepX() + c2 * 0.4 * (double)to.getStepX();
                double p1 = 0.5 + c1 * (double)from.getStepY() + c2 * 0.4 * (double)to.getStepY();
                double p2 = 0.5 + c1 * (double)from.getStepZ() + c2 * 0.4 * (double)to.getStepZ();
                world.addParticle((ParticleOptions)new DustParticleOptions(new Vector3f((Vector3fc)color.toVector3f()), 1.0f), (double)pos.getX() + p0, (double)pos.getY() + p1, (double)pos.getZ() + p2, 0.0, 0.0, 0.0);
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource rand) {
            if ((double)rand.nextFloat() > 0.4) {
                return;
            }
            TrackBlockEntity te = RedstoneTrackBlock.tile((BlockGetter)world, pos).orElse(null);
            if (te == null || (te.getStateFlags() & 0xFFFFFF00000000L) == 0L) {
                return;
            }
            Vec3 color = new Vec3((double)0.6f, 0.0, 0.0);
            for (Direction side : Direction.values()) {
                int p = te.getSidePower(side);
                if (p == 0) continue;
                this.spawnPoweredParticle(world, rand, pos, color, side, side.getOpposite(), -0.5f, 0.5f);
            }
        }

        public InteractionResult modifySegments(BlockState state, Level world, BlockPos pos, Player player, ItemStack stack, InteractionHand hand, BlockHitResult rtr, boolean no_add, boolean no_remove) {
            TrackBlockEntity te;
            if (!stack.isEmpty() && stack.getItem() != Items.REDSTONE && !RedstonePenItem.isPen(stack)) {
                BlockPos behind_pos = pos.relative(rtr.getDirection());
                BlockState behind_state = world.getBlockState(behind_pos);
                if (behind_state.isRedstoneConductor((BlockGetter)world, behind_pos)) {
                    return behind_state.useWithoutItem(world, player, rtr);
                }
                return InteractionResult.sidedSuccess((boolean)world.isClientSide());
            }
            if (world.isClientSide()) {
                return InteractionResult.SUCCESS;
            }
            if (!RedstonePenItem.hasEnoughRedstone(stack, 1, player)) {
                boolean bl = no_add = !no_remove;
            }
            if ((te = (TrackBlockEntity)RedstoneTrackBlock.tile((BlockGetter)world, pos).orElse(null)) == null) {
                return InteractionResult.FAIL;
            }
            boolean no_bulk = false;
            int redstone_use = te.modifySegments(pos, player, player.getItemInHand(hand), rtr.getDirection(), rtr.getLocation(), no_add, no_remove, false);
            if (redstone_use == 0) {
                return InteractionResult.CONSUME;
            }
            if (redstone_use < 0) {
                RedstonePenItem.pushRedstone(stack, -redstone_use, player);
                if (te.getWireFlags() == 0) {
                    world.setBlock(pos, state.getFluidState().createLegacyBlock(), 3);
                } else {
                    Map<BlockPos, BlockPos> blocks_to_update = te.updateAllPowerValuesFromAdjacent();
                    for (Map.Entry<BlockPos, BlockPos> update_pos : blocks_to_update.entrySet()) {
                        world.neighborChanged(update_pos.getKey(), (Block)this, update_pos.getValue());
                    }
                }
                world.playSound(null, pos, SoundEvents.ITEM_FRAME_REMOVE_ITEM, SoundSource.BLOCKS, 0.4f, 2.0f);
            } else {
                RedstonePenItem.popRedstone(stack, redstone_use, player, hand);
                world.playSound(null, pos, SoundEvents.METAL_PLACE, SoundSource.BLOCKS, 0.4f, 2.4f);
            }
            this.updateNeighbourShapes(state, world, pos);
            this.notifyAdjacent(world, pos);
            return InteractionResult.CONSUME;
        }

        private void disablePower(boolean disable) {
            this.can_provide_power_ = !disable;
        }

        private void updateNeighbourShapes(BlockState state, Level world, BlockPos pos) {
            state.updateNeighbourShapes((LevelAccessor)world, pos, 3);
        }

        public void notifyAdjacent(Level world, BlockPos pos) {
            world.updateNeighborsAt(pos, (Block)this);
            for (Direction dir0 : BlockBehaviour.UPDATE_SHAPE_ORDER) {
                BlockPos ppos = pos.relative(dir0);
                world.updateNeighborsAtExceptFromFacing(ppos, world.getBlockState(ppos).getBlock(), dir0.getOpposite());
                for (Direction dir1 : BlockBehaviour.UPDATE_SHAPE_ORDER) {
                    BlockState diagonal_state;
                    if (dir0 == dir1.getOpposite()) {
                        return;
                    }
                    ppos = pos.relative(dir0).relative(dir1);
                    if (ppos == pos || (diagonal_state = world.getBlockState(ppos)).getBlock() != this) continue;
                    world.neighborChanged(ppos, (Block)this, pos);
                }
            }
        }
    }

    public static final class defs {
        public static final long STATE_FLAG_WIR_MASK = 0xFFFFFFL;
        public static final long STATE_FLAG_CON_MASK = 0x3F000000L;
        public static final long STATE_FLAG_PWR_MASK = 0xFFFFFF00000000L;
        public static final int STATE_FLAG_WIR_COUNT = 24;
        public static final int STATE_FLAG_CON_COUNT = 6;
        public static final int STATE_FLAG_WIR_POS = 0;
        public static final int STATE_FLAG_CON_POS = 24;
        public static final int STATE_FLAG_PWR_POS = 32;
        public static final Direction[] REDSTONE_UPDATE_DIRECTIONS = new Direction[]{Direction.WEST, Direction.EAST, Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH};

        public static final class models {
            public static final ImmutableMap<Long, String> STATE_WIRE_MAPPING = new ImmutableMap.Builder().put((Object)0L, (Object)"none").put((Object)1L, (Object)"dn").put((Object)2L, (Object)"ds").put((Object)4L, (Object)"de").put((Object)8L, (Object)"dw").put((Object)16L, (Object)"un").put((Object)32L, (Object)"us").put((Object)64L, (Object)"ue").put((Object)128L, (Object)"uw").put((Object)256L, (Object)"nu").put((Object)512L, (Object)"nd").put((Object)1024L, (Object)"ne").put((Object)2048L, (Object)"nw").put((Object)4096L, (Object)"su").put((Object)8192L, (Object)"sd").put((Object)16384L, (Object)"se").put((Object)32768L, (Object)"sw").put((Object)65536L, (Object)"eu").put((Object)131072L, (Object)"ed").put((Object)262144L, (Object)"en").put((Object)524288L, (Object)"es").put((Object)0x100000L, (Object)"wu").put((Object)0x200000L, (Object)"wd").put((Object)0x400000L, (Object)"wn").put((Object)0x800000L, (Object)"ws").build();
            public static final ImmutableMap<Long, String> STATE_CONNECT_MAPPING = new ImmutableMap.Builder().put((Object)0L, (Object)"none").put((Object)0x1000000L, (Object)"dc").put((Object)0x2000000L, (Object)"uc").put((Object)0x4000000L, (Object)"nc").put((Object)0x8000000L, (Object)"sc").put((Object)0x10000000L, (Object)"ec").put((Object)0x20000000L, (Object)"wc").build();
            public static final ImmutableMap<Long, String> STATE_CNTWIRE_MAPPING = new ImmutableMap.Builder().put((Object)0L, (Object)"none").put((Object)0x1000000L, (Object)"dm").put((Object)0x2000000L, (Object)"um").put((Object)0x4000000L, (Object)"nm").put((Object)0x8000000L, (Object)"sm").put((Object)0x10000000L, (Object)"em").put((Object)0x20000000L, (Object)"wm").build();
        }

        public static class shape {
            private static final double SHAPE_LAYER_THICKNESS = 0.01;
            private static final double SHAPE_TRACK_HALFWIDTH = 2.0;
            private static final VoxelShape DOWN_SHAPE = Auxiliaries.getUnionShape(Auxiliaries.getPixeledAABB(6.0, 0.0, 0.0, 10.0, 0.01, 16.0), Auxiliaries.getPixeledAABB(0.0, 0.0, 6.0, 16.0, 0.01, 10.0));
            private static final VoxelShape UP_SHAPE = Auxiliaries.getUnionShape(Auxiliaries.getPixeledAABB(6.0, 15.99, 0.0, 10.0, 16.0, 16.0), Auxiliaries.getPixeledAABB(0.0, 15.99, 6.0, 16.0, 16.0, 10.0));
            private static final VoxelShape WEST_SHAPE = Auxiliaries.getUnionShape(Auxiliaries.getPixeledAABB(0.0, 0.0, 6.0, 0.01, 16.0, 10.0), Auxiliaries.getPixeledAABB(0.0, 6.0, 0.0, 0.01, 10.0, 16.0));
            private static final VoxelShape EAST_SHAPE = Auxiliaries.getUnionShape(Auxiliaries.getPixeledAABB(15.99, 0.0, 6.0, 16.0, 16.0, 10.0), Auxiliaries.getPixeledAABB(15.99, 6.0, 0.0, 16.0, 10.0, 16.0));
            private static final VoxelShape NORTH_SHAPE = Auxiliaries.getUnionShape(Auxiliaries.getPixeledAABB(0.0, 6.0, 0.0, 16.0, 10.0, 0.01), Auxiliaries.getPixeledAABB(6.0, 0.0, 0.0, 10.0, 16.0, 0.01));
            private static final VoxelShape SOUTH_SHAPE = Auxiliaries.getUnionShape(Auxiliaries.getPixeledAABB(0.0, 6.0, 15.99, 16.0, 10.0, 16.0), Auxiliaries.getPixeledAABB(6.0, 0.0, 15.99, 10.0, 16.0, 16.0));
            private static final VoxelShape[] shape_cache = new VoxelShape[64];

            public static VoxelShape get(int faces) {
                if (shape_cache[faces] == null) {
                    VoxelShape shape2 = Shapes.empty();
                    if ((faces & 1) != 0) {
                        shape2 = Shapes.join((VoxelShape)shape2, (VoxelShape)DOWN_SHAPE, (BooleanOp)BooleanOp.OR);
                    }
                    if ((faces & 2) != 0) {
                        shape2 = Shapes.join((VoxelShape)shape2, (VoxelShape)UP_SHAPE, (BooleanOp)BooleanOp.OR);
                    }
                    if ((faces & 4) != 0) {
                        shape2 = Shapes.join((VoxelShape)shape2, (VoxelShape)NORTH_SHAPE, (BooleanOp)BooleanOp.OR);
                    }
                    if ((faces & 8) != 0) {
                        shape2 = Shapes.join((VoxelShape)shape2, (VoxelShape)SOUTH_SHAPE, (BooleanOp)BooleanOp.OR);
                    }
                    if ((faces & 0x10) != 0) {
                        shape2 = Shapes.join((VoxelShape)shape2, (VoxelShape)EAST_SHAPE, (BooleanOp)BooleanOp.OR);
                    }
                    if ((faces & 0x20) != 0) {
                        shape2 = Shapes.join((VoxelShape)shape2, (VoxelShape)WEST_SHAPE, (BooleanOp)BooleanOp.OR);
                    }
                    shape.shape_cache[faces] = shape2;
                }
                return shape_cache[faces];
            }
        }

        public static final class connections {
            public static final Direction[] CONNECTION_BIT_ORDER = new Direction[]{Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST};
            public static final ImmutableMap<Direction, Integer> CONNECTION_BIT_ORDER_REV = new ImmutableMap.Builder().put((Object)Direction.DOWN, (Object)0).put((Object)Direction.UP, (Object)1).put((Object)Direction.NORTH, (Object)2).put((Object)Direction.SOUTH, (Object)3).put((Object)Direction.EAST, (Object)4).put((Object)Direction.WEST, (Object)5).build();
            public static final ImmutableMap<Long, Direction> BULK_FACE_MAPPING = new ImmutableMap.Builder().put((Object)0L, (Object)Direction.DOWN).put((Object)0x1000000L, (Object)Direction.DOWN).put((Object)0x2000000L, (Object)Direction.UP).put((Object)0x4000000L, (Object)Direction.NORTH).put((Object)0x8000000L, (Object)Direction.SOUTH).put((Object)0x10000000L, (Object)Direction.EAST).put((Object)0x20000000L, (Object)Direction.WEST).build();
            public static final ImmutableMap<Direction, Long> BULK_FACE_MAPPING_REV = new ImmutableMap.Builder().put((Object)Direction.DOWN, (Object)0x1000000L).put((Object)Direction.UP, (Object)0x2000000L).put((Object)Direction.NORTH, (Object)0x4000000L).put((Object)Direction.SOUTH, (Object)0x8000000L).put((Object)Direction.EAST, (Object)0x10000000L).put((Object)Direction.WEST, (Object)0x20000000L).build();
            public static final ImmutableMap<Long, Tuple<Direction, Direction>> WIRE_FACE_DIRECTION_MAPPING = new ImmutableMap.Builder().put((Object)0L, (Object)new Tuple((Object)Direction.DOWN, (Object)Direction.DOWN)).put((Object)1L, (Object)new Tuple((Object)Direction.DOWN, (Object)Direction.NORTH)).put((Object)2L, (Object)new Tuple((Object)Direction.DOWN, (Object)Direction.SOUTH)).put((Object)4L, (Object)new Tuple((Object)Direction.DOWN, (Object)Direction.EAST)).put((Object)8L, (Object)new Tuple((Object)Direction.DOWN, (Object)Direction.WEST)).put((Object)16L, (Object)new Tuple((Object)Direction.UP, (Object)Direction.NORTH)).put((Object)32L, (Object)new Tuple((Object)Direction.UP, (Object)Direction.SOUTH)).put((Object)64L, (Object)new Tuple((Object)Direction.UP, (Object)Direction.EAST)).put((Object)128L, (Object)new Tuple((Object)Direction.UP, (Object)Direction.WEST)).put((Object)256L, (Object)new Tuple((Object)Direction.NORTH, (Object)Direction.UP)).put((Object)512L, (Object)new Tuple((Object)Direction.NORTH, (Object)Direction.DOWN)).put((Object)1024L, (Object)new Tuple((Object)Direction.NORTH, (Object)Direction.EAST)).put((Object)2048L, (Object)new Tuple((Object)Direction.NORTH, (Object)Direction.WEST)).put((Object)4096L, (Object)new Tuple((Object)Direction.SOUTH, (Object)Direction.UP)).put((Object)8192L, (Object)new Tuple((Object)Direction.SOUTH, (Object)Direction.DOWN)).put((Object)16384L, (Object)new Tuple((Object)Direction.SOUTH, (Object)Direction.EAST)).put((Object)32768L, (Object)new Tuple((Object)Direction.SOUTH, (Object)Direction.WEST)).put((Object)65536L, (Object)new Tuple((Object)Direction.EAST, (Object)Direction.UP)).put((Object)131072L, (Object)new Tuple((Object)Direction.EAST, (Object)Direction.DOWN)).put((Object)262144L, (Object)new Tuple((Object)Direction.EAST, (Object)Direction.NORTH)).put((Object)524288L, (Object)new Tuple((Object)Direction.EAST, (Object)Direction.SOUTH)).put((Object)0x100000L, (Object)new Tuple((Object)Direction.WEST, (Object)Direction.UP)).put((Object)0x200000L, (Object)new Tuple((Object)Direction.WEST, (Object)Direction.DOWN)).put((Object)0x400000L, (Object)new Tuple((Object)Direction.WEST, (Object)Direction.NORTH)).put((Object)0x800000L, (Object)new Tuple((Object)Direction.WEST, (Object)Direction.SOUTH)).build();
            public static final ImmutableMap<Long, Tuple<Direction, Direction>> INTERNAL_EDGE_CONNECTION_MAPPING = new ImmutableMap.Builder().put((Object)513L, (Object)new Tuple((Object)Direction.DOWN, (Object)Direction.NORTH)).put((Object)8194L, (Object)new Tuple((Object)Direction.DOWN, (Object)Direction.SOUTH)).put((Object)131076L, (Object)new Tuple((Object)Direction.DOWN, (Object)Direction.EAST)).put((Object)0x200008L, (Object)new Tuple((Object)Direction.DOWN, (Object)Direction.WEST)).put((Object)272L, (Object)new Tuple((Object)Direction.UP, (Object)Direction.NORTH)).put((Object)4128L, (Object)new Tuple((Object)Direction.UP, (Object)Direction.SOUTH)).put((Object)65600L, (Object)new Tuple((Object)Direction.UP, (Object)Direction.EAST)).put((Object)0x100080L, (Object)new Tuple((Object)Direction.UP, (Object)Direction.WEST)).put((Object)263168L, (Object)new Tuple((Object)Direction.NORTH, (Object)Direction.EAST)).put((Object)0x400800L, (Object)new Tuple((Object)Direction.NORTH, (Object)Direction.WEST)).put((Object)540672L, (Object)new Tuple((Object)Direction.SOUTH, (Object)Direction.EAST)).put((Object)0x808000L, (Object)new Tuple((Object)Direction.SOUTH, (Object)Direction.WEST)).build();

            public static long getBulkConnectorBit(Direction face) {
                return (Long)BULK_FACE_MAPPING_REV.get((Object)face);
            }

            public static long getWireBit(Direction face, Direction wire_direction) {
                return WIRE_FACE_DIRECTION_MAPPING.entrySet().stream().filter(kv -> ((Tuple)kv.getValue()).getA() == face && ((Tuple)kv.getValue()).getB() == wire_direction).findFirst().map(Map.Entry::getKey).orElse(0L);
            }

            public static Tuple<Direction, Direction> getWireBitSideAndDirection(long wirebit) {
                return (Tuple)WIRE_FACE_DIRECTION_MAPPING.getOrDefault((Object)wirebit, (Object)new Tuple((Object)Direction.DOWN, (Object)Direction.DOWN));
            }

            public static List<Direction> getVanillaWireConnectionDirections(long mask) {
                if ((mask & 0xFL) == 0L) {
                    return Collections.emptyList();
                }
                ArrayList<Direction> r = new ArrayList<Direction>(4);
                if ((mask & 1L) != 0L) {
                    r.add(Direction.NORTH);
                }
                if ((mask & 2L) != 0L) {
                    r.add(Direction.SOUTH);
                }
                if ((mask & 4L) != 0L) {
                    r.add(Direction.EAST);
                }
                if ((mask & 8L) != 0L) {
                    r.add(Direction.WEST);
                }
                return r;
            }

            public static boolean hasVanillaWireConnection(long mask, Direction side) {
                return switch (side) {
                    case Direction.NORTH -> {
                        if ((mask & 1L) != 0L) {
                            yield true;
                        }
                        yield false;
                    }
                    case Direction.SOUTH -> {
                        if ((mask & 2L) != 0L) {
                            yield true;
                        }
                        yield false;
                    }
                    case Direction.EAST -> {
                        if ((mask & 4L) != 0L) {
                            yield true;
                        }
                        yield false;
                    }
                    case Direction.WEST -> {
                        if ((mask & 8L) != 0L) {
                            yield true;
                        }
                        yield false;
                    }
                    default -> false;
                };
            }

            public static boolean hasBulkConnection(long mask, Direction side) {
                return ((Long)BULK_FACE_MAPPING_REV.get((Object)side) & mask) != 0L;
            }

            public static boolean hasRedstoneConnection(long mask, Direction side) {
                return switch (side) {
                    default -> throw new MatchException(null, null);
                    case Direction.DOWN -> {
                        if ((mask & 0x1222200L) != 0L) {
                            yield true;
                        }
                        yield false;
                    }
                    case Direction.UP -> {
                        if ((mask & 0x2111100L) != 0L) {
                            yield true;
                        }
                        yield false;
                    }
                    case Direction.NORTH -> {
                        if ((mask & 0x4440011L) != 0L) {
                            yield true;
                        }
                        yield false;
                    }
                    case Direction.SOUTH -> {
                        if ((mask & 0x8880022L) != 0L) {
                            yield true;
                        }
                        yield false;
                    }
                    case Direction.EAST -> {
                        if ((mask & 0x10004444L) != 0L) {
                            yield true;
                        }
                        yield false;
                    }
                    case Direction.WEST -> (mask & 0x20008888L) != 0L;
                };
            }

            public static long getWireElementsOnFace(Direction face) {
                return 15L << (Integer)CONNECTION_BIT_ORDER_REV.get((Object)face) * 4 + 0;
            }

            public static long getAllElementsOnFace(Direction face) {
                int index = (Integer)CONNECTION_BIT_ORDER_REV.get((Object)face);
                return 15L << index * 4 + 0 | 1L << index + 24;
            }
        }
    }
}

