/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.pvp_flagging.network;

import io.redspace.pvp_flagging.client.ClientHelper;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class SyncPvpDataPacket
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<SyncPvpDataPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"pvp_flagging", (String)"sync_pvp_data"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncPvpDataPacket> STREAM_CODEC = CustomPacketPayload.codec(SyncPvpDataPacket::write, SyncPvpDataPacket::new);
    private final ObjectSet<UUID> flaggedPlayers;

    public SyncPvpDataPacket(ObjectSet<UUID> flaggedPlayers) {
        this.flaggedPlayers = flaggedPlayers;
    }

    public SyncPvpDataPacket(FriendlyByteBuf buf) {
        this.flaggedPlayers = (ObjectSet)buf.readCollection(ObjectOpenHashSet::new, b -> b.readUUID());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeCollection(this.flaggedPlayers, (b, v) -> b.writeUUID(v));
    }

    public static void handle(SyncPvpDataPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> ClientHelper.handleFullPvpDataSync(packet.flaggedPlayers));
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

