/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.pvp_flagging.core;

import io.redspace.pvp_flagging.PvpFlagging;
import io.redspace.pvp_flagging.config.PvpConfig;
import io.redspace.pvp_flagging.data.PvpDataStorage;
import io.redspace.pvp_flagging.network.PvpCancelScheduledUnflagPacket;
import io.redspace.pvp_flagging.network.PvpFlagUpdatePacket;
import io.redspace.pvp_flagging.network.PvpUnflagScheduledPacket;
import io.redspace.pvp_flagging.network.SyncPvpDataPacket;
import io.redspace.pvp_flagging.network.WarnPlayerPacket;
import io.redspace.pvp_flagging.util.Logging;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

@EventBusSubscriber(modid="pvp_flagging", bus=EventBusSubscriber.Bus.GAME)
public class PlayerFlagManager
implements INBTSerializable<CompoundTag> {
    public static PlayerFlagManager INSTANCE;
    private final int EXPECTED_SIZE = 20;
    private final ObjectSet<UUID> flaggedPlayers = new ObjectOpenHashSet(20);
    private final Int2ObjectMap<ScheduleUnflagItem> playersScheduledToUnflag = new Int2ObjectOpenHashMap(20);

    public static void init() {
        INSTANCE = new PlayerFlagManager();
    }

    public boolean isPlayerFlagged(@Nullable Player player) {
        return player != null && this.flaggedPlayers.contains((Object)player.getUUID());
    }

    public boolean anyPlayersScheduledToUnflag() {
        return !this.playersScheduledToUnflag.isEmpty();
    }

    public boolean isScheduledToUnflag(ServerPlayer player) {
        return this.playersScheduledToUnflag.containsKey(player.getId());
    }

    public boolean areBothPlayersFlagged(Player player1, Player player2) {
        return this.flaggedPlayers.contains((Object)player1.getUUID()) && this.flaggedPlayers.contains((Object)player2.getUUID());
    }

    public void flagPlayer(@Nullable ServerPlayer serverPlayer) {
        if (Logging.PLAYER_FLAG_MANAGER) {
            PvpFlagging.LOGGER.debug("PlayerFlagManger flagPlayer:{}", (Object)serverPlayer);
        }
        if (serverPlayer != null) {
            this.cancelScheduledUnflag(serverPlayer);
            this.flaggedPlayers.add((Object)serverPlayer.getUUID());
            PvpDataStorage.INSTANCE.setDirty();
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new PvpFlagUpdatePacket(serverPlayer.getUUID(), true), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void warnPlayer(@Nullable ServerPlayer serverPlayer) {
        if (Logging.PLAYER_FLAG_MANAGER) {
            PvpFlagging.LOGGER.debug("PlayerFlagManger warnPlayer:{}", (Object)serverPlayer);
        }
        if (serverPlayer != null) {
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new WarnPlayerPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void cancelScheduledUnflag(@Nullable ServerPlayer serverPlayer) {
        if (serverPlayer != null && !this.playersScheduledToUnflag.isEmpty() && this.playersScheduledToUnflag.remove(serverPlayer.getId()) != null) {
            if (Logging.PLAYER_FLAG_MANAGER) {
                PvpFlagging.LOGGER.debug("PlayerFlagManger cancelScheduledUnflag:{}", (Object)serverPlayer);
            }
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new PvpCancelScheduledUnflagPacket(0), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void unflagPlayerImmediate(@Nullable ServerPlayer serverPlayer) {
        if (Logging.PLAYER_FLAG_MANAGER) {
            PvpFlagging.LOGGER.debug("PlayerFlagManger unflagPlayerImmediate:{}", (Object)serverPlayer);
        }
        if (serverPlayer != null && this.flaggedPlayers.contains((Object)serverPlayer.getUUID())) {
            this.flaggedPlayers.remove((Object)serverPlayer.getUUID());
            PvpDataStorage.INSTANCE.setDirty();
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new PvpFlagUpdatePacket(serverPlayer.getUUID(), false), (CustomPacketPayload[])new CustomPacketPayload[0]);
            if (!this.playersScheduledToUnflag.isEmpty()) {
                this.playersScheduledToUnflag.remove(serverPlayer.getId());
            }
        }
    }

    public void unflagPlayer(@Nullable ServerPlayer serverPlayer) {
        if (Logging.PLAYER_FLAG_MANAGER) {
            PvpFlagging.LOGGER.debug("PlayerFlagManger unflagPlayer:{}", (Object)serverPlayer);
        }
        if (serverPlayer != null && this.flaggedPlayers.contains((Object)serverPlayer.getUUID())) {
            if (Logging.PLAYER_FLAG_MANAGER) {
                PvpFlagging.LOGGER.debug("Player {} is scheduled to be unflagged", (Object)serverPlayer.getUUID());
            }
            MinecraftServer server = serverPlayer.getServer();
            long scheduledTick = 0L;
            int waitTicks = 0;
            if (server != null) {
                waitTicks = (Integer)PvpConfig.SERVER.UNFLAG_WAIT_TIME_TICKS.get();
                scheduledTick = server.overworld().getGameTime() + (long)waitTicks;
            }
            this.playersScheduledToUnflag.put(serverPlayer.getId(), (Object)new ScheduleUnflagItem(serverPlayer, scheduledTick));
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new PvpUnflagScheduledPacket(waitTicks), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void syncToPlayer(ServerPlayer serverPlayer) {
        if (Logging.PLAYER_FLAG_MANAGER) {
            PvpFlagging.LOGGER.debug("PlayerFlagManger syncToPlayer:{}, count:{}", (Object)serverPlayer, (Object)this.flaggedPlayers.size());
        }
        if (!this.flaggedPlayers.isEmpty()) {
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SyncPvpDataPacket(this.flaggedPlayers), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void processScheduledUnflags(long gameTime) {
        if (!this.playersScheduledToUnflag.isEmpty()) {
            this.playersScheduledToUnflag.values().stream().filter(unflagItem -> unflagItem.scheduledTick < gameTime).toList().forEach(unflagItem -> {
                this.playersScheduledToUnflag.remove(unflagItem.serverPlayer.getId());
                if (this.flaggedPlayers.contains((Object)unflagItem.serverPlayer.getUUID())) {
                    this.flaggedPlayers.remove((Object)unflagItem.serverPlayer.getUUID());
                    PvpDataStorage.INSTANCE.setDirty();
                    PacketDistributor.sendToAllPlayers((CustomPacketPayload)new PvpFlagUpdatePacket(unflagItem.serverPlayer.getUUID(), false), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                if (Logging.PLAYER_FLAG_MANAGER) {
                    PvpFlagging.LOGGER.debug("PlayerFlagManger processScheduledUnflags unflagged:{} ", (Object)unflagItem.serverPlayer);
                }
            });
        }
    }

    @SubscribeEvent
    public static void handleServerTick(ServerTickEvent.Post event) {
        long gameTime = event.getServer().overworld().getGameTime();
        if (gameTime % 20L == 0L) {
            INSTANCE.processScheduledUnflags(gameTime);
        }
    }

    public @UnknownNullability CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        ListTag uuids = new ListTag();
        for (UUID flaggedPlayer : this.flaggedPlayers) {
            uuids.add((Object)NbtUtils.createUUID((UUID)flaggedPlayer));
        }
        tag.put("flaggedPlayers", (Tag)uuids);
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        ListTag list = nbt.getList("flaggedPlayers", 11);
        for (Tag uuidTag : list) {
            try {
                UUID uuid = NbtUtils.loadUUID((Tag)uuidTag);
                this.flaggedPlayers.add((Object)uuid);
            }
            catch (Exception exception) {}
        }
    }

    public static class ScheduleUnflagItem {
        private final ServerPlayer serverPlayer;
        private final long scheduledTick;

        public ScheduleUnflagItem(ServerPlayer serverPlayer, long scheduledTick) {
            this.serverPlayer = serverPlayer;
            this.scheduledTick = scheduledTick;
        }

        public int hashCode() {
            return this.serverPlayer.hashCode();
        }

        public boolean equals(Object obj) {
            return this.serverPlayer.equals(obj);
        }
    }
}

