/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.pvp_flagging.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.redspace.pvp_flagging.core.PlayerFlagManager;
import io.redspace.pvp_flagging.core.PvpZoneManager;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class PvpFlagCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralCommandNode command = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"pvpFlag").requires(p -> p.hasPermission(0))).executes(context -> PvpFlagCommand.toggleFlag((CommandSourceStack)context.getSource()))).then(Commands.literal((String)"on").executes(context -> PvpFlagCommand.flag((CommandSourceStack)context.getSource())))).then(Commands.literal((String)"off").executes(context -> PvpFlagCommand.unflag((CommandSourceStack)context.getSource())))).then(Commands.literal((String)"status").executes(context -> PvpFlagCommand.status((CommandSourceStack)context.getSource()))));
    }

    private static int toggleFlag(CommandSourceStack source) {
        if (source.getPlayer() != null && PlayerFlagManager.INSTANCE.isPlayerFlagged((Player)source.getPlayer()) && !PlayerFlagManager.INSTANCE.isScheduledToUnflag(source.getPlayer())) {
            if (PvpZoneManager.INSTANCE.boundsCheckShouldFlag((Player)source.getPlayer())) {
                source.sendFailure((Component)Component.translatable((String)"ui.pvp_flagging.pvp_zone.prevent_unflag"));
            } else {
                PvpFlagCommand.unflag(source);
            }
        } else {
            PvpFlagCommand.flag(source);
        }
        return 1;
    }

    private static int unflag(CommandSourceStack source) {
        PlayerFlagManager.INSTANCE.unflagPlayer(source.getPlayer());
        return 1;
    }

    private static int flag(CommandSourceStack source) {
        PlayerFlagManager.INSTANCE.flagPlayer(source.getPlayer());
        return 1;
    }

    private static int status(CommandSourceStack source) {
        boolean isPlayerFlagged = PlayerFlagManager.INSTANCE.isPlayerFlagged((Player)source.getPlayer());
        source.sendSuccess(() -> Component.translatable((String)"ui.pvp_flagging.pvp_status", (Object[])new Object[]{isPlayerFlagged}), true);
        return 1;
    }
}

