/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.pvp_flagging.client;

import io.redspace.pvp_flagging.client.ClientHelper;
import io.redspace.pvp_flagging.config.PvpConfig;
import java.util.function.Function;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;

public class FlagIndicatorOverlay
implements LayeredDraw.Layer {
    public static final FlagIndicatorOverlay INSTANCE = new FlagIndicatorOverlay();
    ResourceLocation FLAG = ResourceLocation.fromNamespaceAndPath((String)"pvp_flagging", (String)"textures/gui/pvp_flag.png");

    public void render(GuiGraphics guiGraphics, DeltaTracker pDeltaTracker) {
        int screenWidth = guiGraphics.guiWidth();
        int screenHeight = guiGraphics.guiHeight();
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || !((Boolean)PvpConfig.CLIENT.INDICATOR_ENABLED.get()).booleanValue() || player.isSpectator() || Minecraft.getInstance().options.hideGui) {
            return;
        }
        boolean flagged = ClientHelper.isFlagged((Player)player);
        if (!flagged) {
            return;
        }
        int unflagTimestamp = ClientHelper.getUnflagTimestamp();
        boolean unflagging = unflagTimestamp >= player.tickCount;
        HudAnchor anchor = (HudAnchor)((Object)PvpConfig.CLIENT.INDICATOR_HUD_ANCHOR.get());
        int halfHeight = screenHeight / 2;
        int halfWidth = screenWidth / 2;
        int spriteSize = 21;
        float spriteScale = 1.5f;
        int iconSize = (int)(21.0f * spriteScale);
        int buffer = 5 + iconSize / 2;
        int xOffset = (Integer)PvpConfig.CLIENT.INDICATOR_X_OFFSET.get();
        int yOffset = (Integer)PvpConfig.CLIENT.INDICATOR_Y_OFFSET.get();
        int x = anchor.widthToX.apply(screenWidth) - iconSize / 2;
        int y = anchor.heightToY.apply(screenHeight) - iconSize / 2;
        int n = x > halfWidth ? -buffer : buffer + iconSize / 2;
        int n2 = y > halfHeight ? -buffer : buffer + iconSize / 2;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().scale(spriteScale, spriteScale, spriteScale);
        guiGraphics.blit(this.FLAG, (int)((float)(x += n + xOffset) / spriteScale) - spriteSize / 2, (int)((float)(y += n2 + yOffset) / spriteScale) - spriteSize / 2, 0.0f, 0.0f, 21, 21, 21, 21);
        guiGraphics.pose().popPose();
        if (unflagging) {
            float secondsLeft = (float)(unflagTimestamp - player.tickCount) / 20.0f;
            String timer = secondsLeft >= 60.0f ? String.format("%s:%s", (int)secondsLeft / 60, (int)secondsLeft % 60) : String.valueOf((float)((int)(secondsLeft * 10.0f)) / 10.0f);
            float f = 1.0f - (float)(unflagTimestamp - player.tickCount) / (float)((Integer)PvpConfig.SERVER.UNFLAG_WAIT_TIME_TICKS.get()).intValue();
            int colorL = (int)Mth.lerp((float)(f * f), (float)50.0f, (float)255.0f);
            int color = 0xFFFF0000 | colorL << 8 | colorL;
            guiGraphics.drawString(Minecraft.getInstance().font, timer, x - Minecraft.getInstance().font.width(timer) / 2, y + iconSize - 14, color, true);
        }
    }

    public static enum HudAnchor {
        TopLeft(width -> 0, height -> 0),
        TopRight(width -> width, height -> 0),
        BottomLeft(width -> 0, height -> height),
        BottomRight(width -> width, height -> height),
        MiddleBottomLeft(width -> width / 4 - 21, height -> height),
        MiddleBottomRight(width -> 3 * width / 4 + 21, height -> height);

        final Function<Integer, Integer> widthToX;
        final Function<Integer, Integer> heightToY;

        private HudAnchor(Function<Integer, Integer> widthToX, Function<Integer, Integer> heightToY) {
            this.widthToX = widthToX;
            this.heightToY = heightToY;
        }
    }
}

