/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.attributesmod.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.player.Player;
import net.puffish.attributesmod.AttributesMod;
import net.puffish.attributesmod.api.DynamicModification;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class}, priority=1100)
public abstract class PlayerEntityMixin {
    private static final double VANILLA_KNOCKBACK = 0.4;

    @ModifyExpressionValue(method={"createAttributes()Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;createLivingAttributes()Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;")})
    private static AttributeSupplier.Builder modifyExpressionValueAtCreateLivingAttributes(AttributeSupplier.Builder builder) {
        return builder.add(AttributesMod.STAMINA).add(AttributesMod.FORTUNE).add(AttributesMod.MINING_SPEED).add(AttributesMod.PICKAXE_SPEED).add(AttributesMod.AXE_SPEED).add(AttributesMod.SHOVEL_SPEED).add(AttributesMod.SPRINTING_SPEED).add(AttributesMod.KNOCKBACK).add(AttributesMod.REPAIR_COST).add(AttributesMod.NATURAL_REGENERATION);
    }

    @Inject(method={"attack(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/enchantment/EnchantmentHelper;doPostAttackEffects(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/damagesource/DamageSource;)V")})
    private void injectAtAttack(Entity target, CallbackInfo ci) {
        Player player = (Player)this;
        double knockback = DynamicModification.create().withPositive(AttributesMod.KNOCKBACK, (LivingEntity)player).applyTo(0.4) - 0.4;
        float yaw = player.getYRot() * ((float)Math.PI / 180);
        float sin = Mth.sin((float)yaw);
        float cos = Mth.cos((float)yaw);
        if (target instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)target;
            livingEntity.knockback(knockback, (double)sin, (double)(-cos));
        } else {
            target.push((double)(-sin) * knockback, 0.0, (double)cos * knockback);
        }
    }

    @ModifyReturnValue(method={"getSpeed()F"}, at={@At(value="RETURN")})
    private float injectAtGetMovementSpeed(float speed) {
        Player player = (Player)this;
        if (!player.isSprinting()) {
            return speed;
        }
        return DynamicModification.create().withPositive(AttributesMod.SPRINTING_SPEED, (LivingEntity)player).applyTo(speed);
    }
}

