/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.attributesmod;

import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.puffish.attributesmod.api.DynamicEntityAttribute;
import net.puffish.attributesmod.util.DynamicModificationImpl;
import net.puffish.attributesmod.util.Platform;
import net.puffish.attributesmod.util.Signed;

public class AttributesMod {
    public static final String MOD_ID = "puffish_attributes";
    public static final ResourceLocation STAMINA_ID = AttributesMod.createIdentifier("stamina");
    public static final Holder<Attribute> STAMINA = AttributesMod.registerAttribute(STAMINA_ID, AttributesMod.createClampedAttribute(STAMINA_ID, 4.0, 0.0, 1024.0).setSyncable(true));
    public static final ResourceLocation MAGIC_DAMAGE_ID = AttributesMod.createIdentifier("magic_damage");
    public static final Holder<Attribute> MAGIC_DAMAGE = AttributesMod.registerAttribute(MAGIC_DAMAGE_ID, DynamicEntityAttribute.create(MAGIC_DAMAGE_ID).setSyncable(true));
    public static final ResourceLocation MELEE_DAMAGE_ID = AttributesMod.createIdentifier("melee_damage");
    public static final Holder<Attribute> MELEE_DAMAGE = AttributesMod.registerAttribute(MELEE_DAMAGE_ID, DynamicEntityAttribute.create(MELEE_DAMAGE_ID).setSyncable(true));
    public static final ResourceLocation RANGED_DAMAGE_ID = AttributesMod.createIdentifier("ranged_damage");
    public static final Holder<Attribute> RANGED_DAMAGE = AttributesMod.registerAttribute(RANGED_DAMAGE_ID, DynamicEntityAttribute.create(RANGED_DAMAGE_ID).setSyncable(true));
    public static final ResourceLocation FORTUNE_ID = AttributesMod.createIdentifier("fortune");
    public static final Holder<Attribute> FORTUNE = AttributesMod.registerAttribute(FORTUNE_ID, DynamicEntityAttribute.create(FORTUNE_ID).setSyncable(true));
    public static final ResourceLocation HEALING_ID = AttributesMod.createIdentifier("healing");
    public static final Holder<Attribute> HEALING = AttributesMod.registerAttribute(HEALING_ID, DynamicEntityAttribute.create(HEALING_ID).setSyncable(true));
    public static final ResourceLocation JUMP_ID = AttributesMod.createIdentifier("jump");
    public static final Holder<Attribute> JUMP = AttributesMod.registerAttribute(JUMP_ID, DynamicEntityAttribute.create(JUMP_ID).setSyncable(true));
    public static final ResourceLocation RESISTANCE_ID = AttributesMod.createIdentifier("resistance");
    public static final Holder<Attribute> RESISTANCE = AttributesMod.registerAttribute(RESISTANCE_ID, DynamicEntityAttribute.create(RESISTANCE_ID).setSyncable(true));
    public static final ResourceLocation MAGIC_RESISTANCE_ID = AttributesMod.createIdentifier("magic_resistance");
    public static final Holder<Attribute> MAGIC_RESISTANCE = AttributesMod.registerAttribute(MAGIC_RESISTANCE_ID, DynamicEntityAttribute.create(MAGIC_RESISTANCE_ID).setSyncable(true));
    public static final ResourceLocation MELEE_RESISTANCE_ID = AttributesMod.createIdentifier("melee_resistance");
    public static final Holder<Attribute> MELEE_RESISTANCE = AttributesMod.registerAttribute(MELEE_RESISTANCE_ID, DynamicEntityAttribute.create(MELEE_RESISTANCE_ID).setSyncable(true));
    public static final ResourceLocation RANGED_RESISTANCE_ID = AttributesMod.createIdentifier("ranged_resistance");
    public static final Holder<Attribute> RANGED_RESISTANCE = AttributesMod.registerAttribute(RANGED_RESISTANCE_ID, DynamicEntityAttribute.create(RANGED_RESISTANCE_ID).setSyncable(true));
    public static final ResourceLocation MINING_SPEED_ID = AttributesMod.createIdentifier("mining_speed");
    public static final Holder<Attribute> MINING_SPEED = AttributesMod.registerAttribute(MINING_SPEED_ID, DynamicEntityAttribute.create(MINING_SPEED_ID).setSyncable(true));
    public static final ResourceLocation PICKAXE_SPEED_ID = AttributesMod.createIdentifier("pickaxe_speed");
    public static final Holder<Attribute> PICKAXE_SPEED = AttributesMod.registerAttribute(PICKAXE_SPEED_ID, DynamicEntityAttribute.create(PICKAXE_SPEED_ID).setSyncable(true));
    public static final ResourceLocation AXE_SPEED_ID = AttributesMod.createIdentifier("axe_speed");
    public static final Holder<Attribute> AXE_SPEED = AttributesMod.registerAttribute(AXE_SPEED_ID, DynamicEntityAttribute.create(AXE_SPEED_ID).setSyncable(true));
    public static final ResourceLocation SHOVEL_SPEED_ID = AttributesMod.createIdentifier("shovel_speed");
    public static final Holder<Attribute> SHOVEL_SPEED = AttributesMod.registerAttribute(SHOVEL_SPEED_ID, DynamicEntityAttribute.create(SHOVEL_SPEED_ID).setSyncable(true));
    public static final ResourceLocation SPRINTING_SPEED_ID = AttributesMod.createIdentifier("sprinting_speed");
    public static final Holder<Attribute> SPRINTING_SPEED = AttributesMod.registerAttribute(SPRINTING_SPEED_ID, DynamicEntityAttribute.create(SPRINTING_SPEED_ID).setSyncable(true));
    public static final ResourceLocation KNOCKBACK_ID = AttributesMod.createIdentifier("knockback");
    public static final Holder<Attribute> KNOCKBACK = AttributesMod.registerAttribute(KNOCKBACK_ID, DynamicEntityAttribute.create(KNOCKBACK_ID).setSyncable(true));
    public static final ResourceLocation REPAIR_COST_ID = AttributesMod.createIdentifier("repair_cost");
    public static final Holder<Attribute> REPAIR_COST = AttributesMod.registerAttribute(REPAIR_COST_ID, DynamicEntityAttribute.create(REPAIR_COST_ID).setSyncable(true));
    public static final ResourceLocation ARMOR_SHRED_ID = AttributesMod.createIdentifier("armor_shred");
    public static final Holder<Attribute> ARMOR_SHRED = AttributesMod.registerAttribute(ARMOR_SHRED_ID, DynamicEntityAttribute.create(ARMOR_SHRED_ID).setSyncable(true));
    public static final ResourceLocation TOUGHNESS_SHRED_ID = AttributesMod.createIdentifier("toughness_shred");
    public static final Holder<Attribute> TOUGHNESS_SHRED = AttributesMod.registerAttribute(TOUGHNESS_SHRED_ID, DynamicEntityAttribute.create(TOUGHNESS_SHRED_ID).setSyncable(true));
    public static final ResourceLocation PROTECTION_SHRED_ID = AttributesMod.createIdentifier("protection_shred");
    public static final Holder<Attribute> PROTECTION_SHRED = AttributesMod.registerAttribute(PROTECTION_SHRED_ID, DynamicEntityAttribute.create(PROTECTION_SHRED_ID).setSyncable(true));
    public static final ResourceLocation RESISTANCE_SHRED_ID = AttributesMod.createIdentifier("resistance_shred");
    public static final Holder<Attribute> RESISTANCE_SHRED = AttributesMod.registerAttribute(RESISTANCE_SHRED_ID, DynamicEntityAttribute.create(RESISTANCE_SHRED_ID).setSyncable(true));
    public static final ResourceLocation MAGIC_RESISTANCE_SHRED_ID = AttributesMod.createIdentifier("magic_resistance_shred");
    public static final Holder<Attribute> MAGIC_RESISTANCE_SHRED = AttributesMod.registerAttribute(MAGIC_RESISTANCE_SHRED_ID, DynamicEntityAttribute.create(MAGIC_RESISTANCE_SHRED_ID).setSyncable(true));
    public static final ResourceLocation MELEE_RESISTANCE_SHRED_ID = AttributesMod.createIdentifier("melee_resistance_shred");
    public static final Holder<Attribute> MELEE_RESISTANCE_SHRED = AttributesMod.registerAttribute(MELEE_RESISTANCE_SHRED_ID, DynamicEntityAttribute.create(MELEE_RESISTANCE_SHRED_ID).setSyncable(true));
    public static final ResourceLocation RANGED_RESISTANCE_SHRED_ID = AttributesMod.createIdentifier("ranged_resistance_shred");
    public static final Holder<Attribute> RANGED_RESISTANCE_SHRED = AttributesMod.registerAttribute(RANGED_RESISTANCE_SHRED_ID, DynamicEntityAttribute.create(RANGED_RESISTANCE_SHRED_ID).setSyncable(true));
    public static final ResourceLocation NATURAL_REGENERATION_ID = AttributesMod.createIdentifier("natural_regeneration");
    public static final Holder<Attribute> NATURAL_REGENERATION = AttributesMod.registerAttribute(NATURAL_REGENERATION_ID, DynamicEntityAttribute.create(NATURAL_REGENERATION_ID).setSyncable(true));
    public static final ResourceLocation STEALTH_ID = AttributesMod.createIdentifier("stealth");
    public static final Holder<Attribute> STEALTH = AttributesMod.registerAttribute(STEALTH_ID, DynamicEntityAttribute.create(STEALTH_ID).setSyncable(true));
    public static final ResourceLocation LIFE_STEAL_ID = AttributesMod.createIdentifier("life_steal");
    public static final Holder<Attribute> LIFE_STEAL = AttributesMod.registerAttribute(LIFE_STEAL_ID, DynamicEntityAttribute.create(LIFE_STEAL_ID).setSyncable(true));
    public static final ResourceLocation FALL_REDUCTION_ID = AttributesMod.createIdentifier("fall_reduction");
    public static final Holder<Attribute> FALL_REDUCTION = AttributesMod.registerAttribute(FALL_REDUCTION_ID, DynamicEntityAttribute.create(FALL_REDUCTION_ID).setSyncable(true));
    public static final ResourceLocation BOW_PROJECTILE_SPEED_ID = AttributesMod.createIdentifier("bow_projectile_speed");
    public static final Holder<Attribute> BOW_PROJECTILE_SPEED = AttributesMod.registerAttribute(BOW_PROJECTILE_SPEED_ID, DynamicEntityAttribute.create(BOW_PROJECTILE_SPEED_ID).setSyncable(true));
    public static final ResourceLocation CROSSBOW_PROJECTILE_SPEED_ID = AttributesMod.createIdentifier("crossbow_projectile_speed");
    public static final Holder<Attribute> CROSSBOW_PROJECTILE_SPEED = AttributesMod.registerAttribute(CROSSBOW_PROJECTILE_SPEED_ID, DynamicEntityAttribute.create(CROSSBOW_PROJECTILE_SPEED_ID).setSyncable(true));

    public static void setup() {
    }

    public static ResourceLocation createIdentifier(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    public static Attribute createClampedAttribute(ResourceLocation id, double fallback, double min, double max) {
        return new RangedAttribute(id.toLanguageKey("attribute"), fallback, min, max);
    }

    public static Holder<Attribute> registerAttribute(ResourceLocation id, Attribute attribute) {
        Holder<Attribute> ref = Platform.INSTANCE.registerReference(BuiltInRegistries.ATTRIBUTE, id, attribute);
        Platform.INSTANCE.registerAlias(BuiltInRegistries.ATTRIBUTE, id.withPrefix("player."), id);
        return ref;
    }

    @SafeVarargs
    public static double applyAttributeModifiers(double initial, Signed<AttributeInstance> ... attributes) {
        DynamicModificationImpl dm = new DynamicModificationImpl();
        for (Signed<AttributeInstance> signedAttribute : attributes) {
            dm.with(signedAttribute);
        }
        return dm.applyTo(initial);
    }
}

