/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.polymorph.common.network;

import com.illusivesoulworks.polymorph.common.network.client.CPacketBlockEntityListener;
import com.illusivesoulworks.polymorph.common.network.client.CPacketPersistentRecipeSelection;
import com.illusivesoulworks.polymorph.common.network.client.CPacketPlayerRecipeSelection;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ServerPayloadHandler {
    private static final ServerPayloadHandler INSTANCE = new ServerPayloadHandler();

    public static ServerPayloadHandler getInstance() {
        return INSTANCE;
    }

    private static void handleData(IPayloadContext context, Runnable handler) {
        context.enqueueWork(handler).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"polymorph.networking.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public void handlePacket(CPacketBlockEntityListener packet, IPayloadContext ctx) {
        ServerPayloadHandler.handleData(ctx, () -> {
            Player patt0$temp = ctx.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                CPacketBlockEntityListener.handle(packet, serverPlayer);
            }
        });
    }

    public void handlePacket(CPacketPersistentRecipeSelection packet, IPayloadContext ctx) {
        ServerPayloadHandler.handleData(ctx, () -> {
            Player patt0$temp = ctx.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                CPacketPersistentRecipeSelection.handle(packet, serverPlayer);
            }
        });
    }

    public void handlePacket(CPacketPlayerRecipeSelection packet, IPayloadContext ctx) {
        ServerPayloadHandler.handleData(ctx, () -> {
            Player patt0$temp = ctx.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                CPacketPlayerRecipeSelection.handle(packet, serverPlayer);
            }
        });
    }
}

