/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.inventory.power;

import com.mojang.datafixers.util.Pair;
import net.creeperhost.polylib.PolyLibPlatform;
import net.creeperhost.polylib.inventory.power.IPolyEnergyStorage;
import net.creeperhost.polylib.inventory.power.IPolyEnergyStorageItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public interface EnergyManager {
    @Nullable
    public IPolyEnergyStorage getBlockEnergyStorage(BlockEntity var1, @Nullable Direction var2);

    @Nullable
    public IPolyEnergyStorageItem getItemEnergyStorage(ItemStack var1);

    public static IPolyEnergyStorage getHandler(BlockEntity tile, @Nullable Direction side) {
        return PolyLibPlatform.getEnergyManager().getBlockEnergyStorage(tile, side);
    }

    public static IPolyEnergyStorageItem getHandler(ItemStack stack) {
        return stack.isEmpty() ? null : PolyLibPlatform.getEnergyManager().getItemEnergyStorage(stack);
    }

    public static long insertEnergy(BlockEntity tile, long energy, Direction side, boolean simulate) {
        IPolyEnergyStorage storage = EnergyManager.getHandler(tile, side);
        if (storage != null && storage.canReceive()) {
            return storage.receiveEnergy(energy, simulate);
        }
        return 0L;
    }

    public static long insertEnergy(ItemStack stack, long energy, boolean simulate) {
        IPolyEnergyStorageItem storage = EnergyManager.getHandler(stack);
        if (storage != null && storage.canReceive()) {
            return storage.receiveEnergy(energy, simulate);
        }
        return 0L;
    }

    public static long extractEnergy(BlockEntity tile, long energy, Direction side, boolean simulate) {
        IPolyEnergyStorage storage = EnergyManager.getHandler(tile, side);
        if (storage != null && storage.canExtract()) {
            return storage.extractEnergy(energy, simulate);
        }
        return 0L;
    }

    public static long transferEnergy(IPolyEnergyStorage source, IPolyEnergyStorage target) {
        return target.receiveEnergy(source.extractEnergy(target.receiveEnergy(target.getMaxEnergyStored(), true), false), false);
    }

    public static long transferEnergy(BlockEntity source, Direction sourceSide, IPolyEnergyStorage target) {
        IPolyEnergyStorage storage = EnergyManager.getHandler(source, sourceSide);
        return storage == null ? 0L : EnergyManager.transferEnergy(storage, target);
    }

    public static long transferEnergy(IPolyEnergyStorage source, BlockEntity target, Direction targetSide) {
        IPolyEnergyStorage storage = EnergyManager.getHandler(target, targetSide);
        return storage == null ? 0L : EnergyManager.transferEnergy(source, storage);
    }

    public static long transferEnergy(ItemStack source, BlockEntity target, Direction targetSide) {
        IPolyEnergyStorageItem storage = EnergyManager.getHandler(source);
        return storage == null ? 0L : EnergyManager.transferEnergy(storage, target, targetSide);
    }

    public static long transferEnergy(BlockEntity source, Direction sourceSide, BlockEntity target, Direction targetSide) {
        IPolyEnergyStorage sourceStorage = EnergyManager.getHandler(source, sourceSide);
        if (sourceStorage == null) {
            return 0L;
        }
        IPolyEnergyStorage targetHandler = EnergyManager.getHandler(target, targetSide);
        return targetHandler == null ? 0L : EnergyManager.transferEnergy(sourceStorage, targetHandler);
    }

    public static void distributeEnergyNearby(BlockEntity source, long amount) {
        BlockPos blockPos = source.getBlockPos();
        Level level = source.getLevel();
        if (level == null || amount == 0L) {
            return;
        }
        Direction.stream().map(direction -> Pair.of((Object)direction, (Object)level.getBlockEntity(blockPos.relative(direction)))).filter(pair -> pair.getSecond() != null).map(pair -> Pair.of((Object)EnergyManager.getHandler((BlockEntity)pair.getSecond(), ((Direction)pair.getFirst()).getOpposite()), (Object)((Direction)pair.getFirst()))).filter(pair -> pair.getFirst() != null).forEach(pair -> EnergyManager.transferEnergy(source, (Direction)pair.getSecond(), (IPolyEnergyStorage)pair.getFirst()));
    }

    public static void distributeEnergyNearby(BlockEntity energyBlock) {
        EnergyManager.distributeEnergyNearby(energyBlock, Long.MAX_VALUE);
    }

    public static boolean canExtractEnergy(ItemStack stack) {
        IPolyEnergyStorageItem storage = EnergyManager.getHandler(stack);
        return storage != null && storage.canExtract();
    }

    public static boolean canReceiveEnergy(ItemStack stack) {
        IPolyEnergyStorageItem storage = EnergyManager.getHandler(stack);
        return storage != null && storage.canReceive();
    }

    public static boolean canExtractEnergy(BlockEntity tile, Direction side) {
        IPolyEnergyStorage storage = EnergyManager.getHandler(tile, side);
        return storage != null && storage.canExtract();
    }

    public static boolean canReceiveEnergy(BlockEntity tile, Direction side) {
        IPolyEnergyStorage storage = EnergyManager.getHandler(tile, side);
        return storage != null && storage.canReceive();
    }

    public static long getEnergyStored(BlockEntity tile, Direction side) {
        IPolyEnergyStorage storage = EnergyManager.getHandler(tile, side);
        return storage == null ? 0L : storage.getEnergyStored();
    }

    public static long getMaxEnergyStored(BlockEntity tile, Direction side) {
        IPolyEnergyStorage storage = EnergyManager.getHandler(tile, side);
        return storage == null ? 0L : storage.getMaxEnergyStored();
    }

    public static long getEnergyStored(ItemStack stack) {
        IPolyEnergyStorageItem storage = EnergyManager.getHandler(stack);
        return storage == null ? 0L : storage.getEnergyStored();
    }

    public static long getMaxEnergyStored(ItemStack stack) {
        IPolyEnergyStorageItem storage = EnergyManager.getHandler(stack);
        return storage == null ? 0L : storage.getMaxEnergyStored();
    }

    public static boolean isEnergyItem(ItemStack stack) {
        return EnergyManager.getHandler(stack) != null;
    }

    public static boolean isEnergyBlock(BlockEntity tile) {
        return EnergyManager.getHandler(tile, null) != null;
    }

    public static boolean isEnergyBlock(BlockEntity tile, Direction direction) {
        return EnergyManager.getHandler(tile, null) != null;
    }
}

