/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.render;

import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Map;
import java.util.SequencedMap;
import net.creeperhost.polylib.client.render.rendertypes.GhostRenderType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;

public class GhostBlockRenderer {
    public static void renderBlock(BlockState state, BlockPos pos, PoseStack ms, MultiBufferSource buffers) {
        if (state == null) {
            return;
        }
        if (pos != null) {
            ms.pushPose();
            ms.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
            Minecraft.getInstance().getBlockRenderer().renderSingleBlock(state, ms, buffers, 0xF000F0, OverlayTexture.NO_OVERLAY);
            ms.popPose();
        }
    }

    public static MultiBufferSource.BufferSource initBuffers(MultiBufferSource.BufferSource original) {
        ByteBufferBuilder fallback = original.sharedBuffer;
        SequencedMap layerBuffers = original.fixedBuffers;
        Object2ObjectLinkedOpenHashMap remapped = new Object2ObjectLinkedOpenHashMap();
        for (Map.Entry e : layerBuffers.entrySet()) {
            remapped.put(GhostRenderType.remap((RenderType)e.getKey()), (ByteBufferBuilder)e.getValue());
        }
        return new GhostRenderType.GhostBuffers(fallback, (SequencedMap<RenderType, ByteBufferBuilder>)remapped);
    }
}

