/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.packedup;

import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.core.gui.BaseContainerType;
import com.supermartijn642.core.item.CreativeItemGroup;
import com.supermartijn642.core.network.PacketChannel;
import com.supermartijn642.core.registry.GeneratorRegistrationHandler;
import com.supermartijn642.core.registry.RegistrationHandler;
import com.supermartijn642.core.registry.RegistryEntryAcceptor;
import com.supermartijn642.packedup.BackpackItem;
import com.supermartijn642.packedup.BackpackRecipeCondition;
import com.supermartijn642.packedup.BackpackType;
import com.supermartijn642.packedup.BackpackUpgradeRecipe;
import com.supermartijn642.packedup.PackedUpClient;
import com.supermartijn642.packedup.compat.Compatibility;
import com.supermartijn642.packedup.generators.PackedUpAdvancementGenerator;
import com.supermartijn642.packedup.generators.PackedUpLanguageGenerator;
import com.supermartijn642.packedup.generators.PackedUpModelGenerator;
import com.supermartijn642.packedup.generators.PackedUpRecipeGenerator;
import com.supermartijn642.packedup.generators.PackedUpTagGenerator;
import com.supermartijn642.packedup.packets.PacketOpenBag;
import com.supermartijn642.packedup.packets.PacketRename;
import com.supermartijn642.packedup.packets.PacketSetIcon;
import com.supermartijn642.packedup.screen.BackpackContainer;
import com.supermartijn642.packedup.storage.BackpackInventory;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;

@Mod(value="packedup")
public class PackedUp {
    public static final PacketChannel CHANNEL = PacketChannel.create((String)"packedup");
    @RegistryEntryAcceptor(namespace="packedup", identifier="container", registry=RegistryEntryAcceptor.Registry.MENU_TYPES)
    public static BaseContainerType<BackpackContainer> container;
    @RegistryEntryAcceptor(namespace="packedup", identifier="basicbackpack", registry=RegistryEntryAcceptor.Registry.ITEMS)
    public static BackpackItem basicbackpack;
    @RegistryEntryAcceptor(namespace="packedup", identifier="ironbackpack", registry=RegistryEntryAcceptor.Registry.ITEMS)
    public static BackpackItem ironbackpack;
    @RegistryEntryAcceptor(namespace="packedup", identifier="copperbackpack", registry=RegistryEntryAcceptor.Registry.ITEMS)
    public static BackpackItem copperbackpack;
    @RegistryEntryAcceptor(namespace="packedup", identifier="silverbackpack", registry=RegistryEntryAcceptor.Registry.ITEMS)
    public static BackpackItem silverbackpack;
    @RegistryEntryAcceptor(namespace="packedup", identifier="goldbackpack", registry=RegistryEntryAcceptor.Registry.ITEMS)
    public static BackpackItem goldbackpack;
    @RegistryEntryAcceptor(namespace="packedup", identifier="diamondbackpack", registry=RegistryEntryAcceptor.Registry.ITEMS)
    public static BackpackItem diamondbackpack;
    @RegistryEntryAcceptor(namespace="packedup", identifier="obsidianbackpack", registry=RegistryEntryAcceptor.Registry.ITEMS)
    public static BackpackItem obsidianbackpack;
    public static final CreativeModeTab ITEM_GROUP;

    public PackedUp(IEventBus eventBus) {
        eventBus.addListener(this::init);
        CHANNEL.registerMessage(PacketRename.class, PacketRename::new, true);
        CHANNEL.registerMessage(PacketOpenBag.class, PacketOpenBag::new, true);
        CHANNEL.registerMessage(PacketSetIcon.class, PacketSetIcon::new, true);
        PackedUp.register();
        if (CommonUtils.getEnvironmentSide().isClient()) {
            PackedUpClient.register();
        }
        PackedUp.registerGenerators();
    }

    public void init(FMLCommonSetupEvent e) {
        Compatibility.init();
    }

    private static void register() {
        RegistrationHandler handler = RegistrationHandler.get((String)"packedup");
        for (BackpackType type : BackpackType.values()) {
            handler.registerItemCallback(type::registerItem);
        }
        handler.registerDataComponentType("inventory_id", BackpackItem.INVENTORY_ID);
        handler.registerDataComponentType("icon", BackpackItem.ICON_ITEM);
        handler.registerMenuType("container", () -> BaseContainerType.create((container, data) -> {
            data.writeInt(container.type.ordinal());
            data.writeInt(container.bagSlot);
            data.writeUtf(Component.Serializer.toJson((Component)container.bagName, (HolderLookup.Provider)HolderLookup.Provider.create(Stream.of(new HolderLookup.RegistryLookup[0]))));
            BackpackInventory inventory = container.inventory;
            data.writeInt(inventory.getInventoryIndex());
            data.writeInt(inventory.bagsInThisBag.size());
            inventory.bagsInThisBag.forEach(arg_0 -> ((FriendlyByteBuf)data).writeInt(arg_0));
            data.writeInt(inventory.bagsThisBagIsIn.size());
            inventory.bagsThisBagIsIn.forEach(arg_0 -> ((FriendlyByteBuf)data).writeInt(arg_0));
            data.writeInt(inventory.layer);
        }, (player, data) -> {
            BackpackType type = BackpackType.values()[data.readInt()];
            int bagSlot = data.readInt();
            MutableComponent bagName = Component.Serializer.fromJson((String)data.readUtf(), (HolderLookup.Provider)HolderLookup.Provider.create(Stream.of(new HolderLookup.RegistryLookup[0])));
            int inventoryIndex = data.readInt();
            int size = data.readInt();
            HashSet<Integer> bagsInThisBag = new HashSet<Integer>(size);
            for (int i = 0; i < size; ++i) {
                bagsInThisBag.add(data.readInt());
            }
            size = data.readInt();
            HashSet<Integer> bagsThisBagIsIn = new HashSet<Integer>(size);
            for (int i = 0; i < size; ++i) {
                bagsThisBagIsIn.add(data.readInt());
            }
            int layer = data.readInt();
            return new BackpackContainer((Player)player, bagSlot, (Component)bagName, inventoryIndex, type, (Set<Integer>)bagsInThisBag, (Set<Integer>)bagsThisBagIsIn, layer);
        }));
        handler.registerRecipeSerializer("upgrade_backpack", BackpackUpgradeRecipe.SERIALIZER);
        handler.registerResourceConditionSerializer("is_backpack_enabled", BackpackRecipeCondition.SERIALIZER);
    }

    private static void registerGenerators() {
        GeneratorRegistrationHandler handler = GeneratorRegistrationHandler.get((String)"packedup");
        handler.addGenerator(PackedUpAdvancementGenerator::new);
        handler.addGenerator(PackedUpLanguageGenerator::new);
        handler.addGenerator(PackedUpModelGenerator::new);
        handler.addGenerator(PackedUpRecipeGenerator::new);
        handler.addGenerator(PackedUpTagGenerator::new);
    }

    static {
        ITEM_GROUP = CreativeItemGroup.create((String)"packedup", () -> basicbackpack);
    }
}

