/*
 * Decompiled with CFR 0.152.
 */
package io.github.avacadowizard120.cameraoverhaulneoforge.core.utils;

public class MathUtils {
    public static float Clamp(float value, float min, float max) {
        return value < min ? min : Math.min(value, max);
    }

    public static double Clamp(double value, double min, double max) {
        return value < min ? min : Math.min(value, max);
    }

    public static float Clamp01(float value) {
        return value < 0.0f ? 0.0f : Math.min(value, 1.0f);
    }

    public static double Clamp01(double value) {
        return value < 0.0 ? 0.0 : Math.min(value, 1.0);
    }

    public static float Lerp(float a, float b, float time) {
        return a + (b - a) * MathUtils.Clamp01(time);
    }

    public static double Lerp(double a, double b, double time) {
        return a + (b - a) * MathUtils.Clamp01(time);
    }

    public static float Damp(float source, float destination, float smoothing, float dt) {
        return MathUtils.Lerp(source, destination, 1.0f - (float)Math.pow(smoothing, dt));
    }

    public static double Damp(double source, double destination, double smoothing, double dt) {
        return MathUtils.Lerp(source, destination, 1.0 - Math.pow(smoothing, dt));
    }
}

