/*
 * Decompiled with CFR 0.152.
 */
package fudge.notenoughcrashes.mixins.client;

import fudge.notenoughcrashes.NotEnoughCrashes;
import fudge.notenoughcrashes.gui.InitErrorScreen;
import fudge.notenoughcrashes.mixinhandlers.EntryPointCatcher;
import fudge.notenoughcrashes.mixinhandlers.InGameCatcher;
import fudge.notenoughcrashes.patches.MinecraftClientAccess;
import java.util.Queue;
import java.util.function.Supplier;
import net.minecraft.CrashReport;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.util.profiling.metrics.profiling.MetricsRecorder;
import net.minecraft.util.thread.ReentrantBlockableEventLoop;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class})
public abstract class MixinMinecraftClient
extends ReentrantBlockableEventLoop<Runnable>
implements MinecraftClientAccess {
    @Shadow
    @Nullable
    private Supplier<CrashReport> delayedCrash;
    @Shadow
    @Final
    private Queue<Runnable> progressTasks;
    @Shadow
    private MetricsRecorder metricsRecorder;

    @Shadow
    public void emergencySaveAndCrash(CrashReport report) {
    }

    @Override
    public MetricsRecorder getRecorder() {
        return this.metricsRecorder;
    }

    @Override
    public void setRecorder(MetricsRecorder recorder) {
        this.metricsRecorder = recorder;
    }

    public MixinMinecraftClient(String string_1) {
        super(string_1);
    }

    @Inject(method={"setScreen(Lnet/minecraft/client/gui/screens/Screen;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void setScreenDontResetCrashScreen(Screen screen, CallbackInfo ci) {
        if (EntryPointCatcher.crashedDuringStartup() && !(screen instanceof InitErrorScreen)) {
            ci.cancel();
        }
    }

    @Inject(method={"run()V"}, at={@At(value="HEAD")})
    private void beforeRun(CallbackInfo ci) {
        if (EntryPointCatcher.crashedDuringStartup()) {
            EntryPointCatcher.displayInitErrorScreen();
        }
    }

    @Inject(method={"handleDelayedCrash()V"}, at={@At(value="HEAD")})
    private void onCheckGameCrashed(CallbackInfo ci) {
        if (!NotEnoughCrashes.enableGameloopCatching()) {
            return;
        }
        if (this.delayedCrash != null) {
            NotEnoughCrashes.logDebug("Handling run loop crash");
            InGameCatcher.handleServerCrash(this.delayedCrash.get());
            this.delayedCrash = null;
        }
    }

    @ModifyArg(method={"run()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;emergencySaveAndCrash(Lnet/minecraft/CrashReport;)V", ordinal=0))
    private CrashReport atTheEndOfFirstCatchBeforePrintingCrashReport(CrashReport report) {
        if (!NotEnoughCrashes.enableGameloopCatching()) {
            return report;
        }
        NotEnoughCrashes.logDebug("Handling client game loop try/catch crash in first catch block");
        InGameCatcher.handleClientCrash(report);
        return report;
    }

    @ModifyArg(method={"run()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;emergencySaveAndCrash(Lnet/minecraft/CrashReport;)V", ordinal=1))
    private CrashReport atTheEndOfSecondCatchBeforePrintingCrashReport(CrashReport report) {
        if (!NotEnoughCrashes.enableGameloopCatching()) {
            return report;
        }
        NotEnoughCrashes.logDebug("Handling client game loop try/catch crash in second catch block");
        InGameCatcher.handleClientCrash(report);
        return report;
    }

    @Inject(method={"emergencySave()V"}, at={@At(value="HEAD")})
    private void beforeCleanUpAfterCrash(CallbackInfo info) {
        if (NotEnoughCrashes.enableGameloopCatching()) {
            InGameCatcher.cleanupBeforeMinecraft(this.progressTasks);
        }
    }

    @Redirect(method={"doLoadLevel(Ljava/lang/String;Lnet/minecraft/util/registry/DynamicRegistryManager$Impl;Ljava/util/function/Function;Lcom/mojang/datafixers/util/Function4;ZLnet/minecraft/client/MinecraftClient$WorldLoadAction;Z)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;emergencySaveAndCrash(Lnet/minecraft/CrashReport;)V"), require=0)
    private void redirectForgePrintCrashReport(CrashReport report) {
        if (!NotEnoughCrashes.enableGameloopCatching()) {
            this.emergencySaveAndCrash(report);
        }
    }
}

