/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagBuilder;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagFile;
import net.minecraft.tags.TagKey;

public class SimpleTagBuilder
extends TagBuilder {
    private final Set<String> uniqueKeys = new HashSet<String>();
    private final ResourceLocation id;

    protected SimpleTagBuilder(ResourceLocation location) {
        this.id = location;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public static SimpleTagBuilder of(ResourceLocation location) {
        return new SimpleTagBuilder(location);
    }

    public static SimpleTagBuilder of(TagKey<?> key) {
        return new SimpleTagBuilder(key.location());
    }

    public TagBuilder add(TagEntry entry) {
        if (this.validateEntry(entry)) {
            return super.add(entry);
        }
        return this;
    }

    public SimpleTagBuilder add(ResourceLocation entry) {
        super.addElement(entry);
        return this;
    }

    public TagBuilder addOptional(ResourceLocation elementLocation) {
        super.addOptionalElement(elementLocation);
        return this;
    }

    private boolean validateEntry(TagEntry entry) {
        if (this.uniqueKeys.contains(entry.toString())) {
            return false;
        }
        this.uniqueKeys.add(entry.toString());
        return true;
    }

    public SimpleTagBuilder addTag(ResourceLocation pId) {
        super.addTag(pId);
        return this;
    }

    public SimpleTagBuilder addTag(TagKey<?> tagKey) {
        return this.addTag(tagKey.location());
    }

    public SimpleTagBuilder addOptionalTag(ResourceLocation pId) {
        super.addOptionalTag(pId);
        return this;
    }

    public SimpleTagBuilder addTag(SimpleTagBuilder otherBuilder) {
        return this.addTag(otherBuilder.getId());
    }

    public SimpleTagBuilder addEntries(Collection<?> entries) {
        entries.forEach(e -> this.add(Utils.getID(e)));
        return this;
    }

    public SimpleTagBuilder addEntry(Object entry) {
        this.add(Utils.getID(entry));
        return this;
    }

    public JsonElement serializeToJson() {
        return (JsonElement)TagFile.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)new TagFile(this.build(), false)).getOrThrow();
    }

    public void addFromJson(JsonObject oldTag) {
        TagFile tagfile = (TagFile)TagFile.CODEC.parse(new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)oldTag)).getOrThrow();
        if (tagfile.replace()) {
            // empty if block
        }
        tagfile.entries().forEach(this::add);
    }
}

