/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.map;

import com.mojang.serialization.Codec;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.map.ExpandedMapData;
import net.mehvahdjukaar.moonlight.core.map.MapDataInternal;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CustomMapData<C extends DirtyCounter, P> {
    public Type<P, ?> getType();

    default public boolean persistOnCopyOrLock() {
        return true;
    }

    default public boolean onItemUpdate(MapItemSavedData data, Entity entity) {
        return false;
    }

    @Nullable
    default public Component onItemTooltip(MapItemSavedData data, ItemStack stack) {
        return null;
    }

    public C createDirtyCounter();

    public void load(CompoundTag var1, HolderLookup.Provider var2);

    public void save(CompoundTag var1, HolderLookup.Provider var2);

    public P createUpdatePatch(C var1);

    public void applyUpdatePatch(P var1);

    default public void setDirty(MapItemSavedData data, Consumer<C> dirtySetter) {
        Type<P, ?> type = this.getType();
        ((ExpandedMapData)data).ml$setCustomDataDirty(type, dirtySetter);
    }

    public record Type<P, T extends CustomMapData<?, P>>(ResourceLocation id, Supplier<T> factory, StreamCodec<? super RegistryFriendlyByteBuf, P> patchCodec) {
        public static final Codec<Type<?, ?>> CODEC = MapDataInternal.CUSTOM_MAP_DATA_TYPES;
        public static final StreamCodec<FriendlyByteBuf, Type<?, ?>> STREAM_CODEC = MapDataInternal.CUSTOM_MAP_DATA_TYPES.getStreamCodec();

        @NotNull
        public T get(MapItemSavedData mapData) {
            return (T)((ExpandedMapData)mapData).ml$getCustomData().get(this);
        }
    }

    public static abstract class Simple<O>
    implements CustomMapData<SimpleDirtyCounter, O> {
        protected O value;

        public Simple(O defaultValue) {
            this.value = defaultValue;
        }

        @Deprecated(forRemoval=true)
        public Simple() {
        }

        @Override
        public Type<O, ?> getType() {
            return null;
        }

        @Override
        public SimpleDirtyCounter createDirtyCounter() {
            return new SimpleDirtyCounter();
        }

        @Override
        public O createUpdatePatch(SimpleDirtyCounter dirtyCounter) {
            return this.value;
        }

        @Override
        public void applyUpdatePatch(O patch) {
            this.value = patch;
        }
    }

    public static class SimpleDirtyCounter
    implements DirtyCounter {
        private boolean dirty = true;

        public void markDirty() {
            this.dirty = true;
        }

        @Override
        public boolean isDirty() {
            return this.dirty;
        }

        @Override
        public void clearDirty() {
            this.dirty = false;
        }
    }

    public record DirtyDataPatch<P, D extends CustomMapData<?, P>>(Type<P, D> type, P patch) {
        public static final StreamCodec<RegistryFriendlyByteBuf, DirtyDataPatch<?, ?>> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, DirtyDataPatch<?, ?>>(){

            public void encode(RegistryFriendlyByteBuf buf, DirtyDataPatch<?, ?> dirtyData) {
                Type.STREAM_CODEC.encode((Object)buf, dirtyData.type);
                1.encodeTyped(buf, dirtyData);
            }

            private static <P> void encodeTyped(RegistryFriendlyByteBuf buf, DirtyDataPatch<P, ?> dirtyData) {
                dirtyData.type.patchCodec().encode((Object)buf, dirtyData.patch);
            }

            public DirtyDataPatch<?, ?> decode(RegistryFriendlyByteBuf buf) {
                Type type = (Type)Type.STREAM_CODEC.decode((Object)buf);
                return 1.decodeTyped(buf, type);
            }

            private static <P, D extends CustomMapData<?, P>> DirtyDataPatch<P, D> decodeTyped(RegistryFriendlyByteBuf buf, Type<P, D> type) {
                Object decode = type.patchCodec().decode((Object)buf);
                return new DirtyDataPatch<Object, D>(type, decode);
            }
        };

        public void apply(Map<Type<?, ?>, CustomMapData<?, ?>> customData) {
            CustomMapData<?, ?> data = customData.get(this.type);
            data.applyUpdatePatch(this.patch);
        }
    }

    public static interface DirtyCounter {
        public boolean isDirty();

        public void clearDirty();
    }
}

