/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.neoforge.mixin.perf.kubejs;

import dev.latvian.mods.kubejs.recipe.RecipesEventJS;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Map;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.annotation.RequiresMod;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RecipesEventJS.class})
@RequiresMod(value="kubejs")
public class RecipeEventJSMixin {
    @Inject(method={"post"}, at={@At(value="RETURN")}, remap=false)
    private void clearRecipeLists(CallbackInfo ci) {
        Field[] fields;
        ModernFix.LOGGER.info("Clearing KubeJS recipe lists...");
        for (Field f : fields = RecipesEventJS.class.getDeclaredFields()) {
            try {
                int size;
                if (Modifier.isStatic(f.getModifiers()) || !Collection.class.isAssignableFrom(f.getType()) && !Map.class.isAssignableFrom(f.getType())) continue;
                f.setAccessible(true);
                Object collection = f.get(this);
                if (collection instanceof Map) {
                    size = ((Map)collection).size();
                    ((Map)collection).clear();
                } else if (collection instanceof Collection) {
                    size = ((Collection)collection).size();
                    ((Collection)collection).clear();
                } else {
                    throw new IllegalStateException();
                }
                ModernFix.LOGGER.debug("Cleared {} with {} entries", (Object)f.getName(), (Object)size);
            }
            catch (ReflectiveOperationException | RuntimeException e) {
                ModernFix.LOGGER.debug("Uh oh, couldn't clear field", (Throwable)e);
            }
        }
    }
}

