/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.tileentities;

import com.ldtteam.structurize.api.RotationMirror;
import com.ldtteam.structurize.storage.StructurePacks;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.fields.modules.IFieldModule;
import com.minecolonies.api.colony.fields.plantation.IPlantationModule;
import com.minecolonies.api.colony.fields.registry.FieldRegistries;
import com.minecolonies.api.compatibility.newstruct.BlueprintMapping;
import com.minecolonies.api.tileentities.AbstractTileEntityPlantationField;
import com.minecolonies.api.tileentities.MinecoloniesTileEntities;
import com.minecolonies.api.util.Utils;
import com.minecolonies.api.util.WorldUtil;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityPlantationField
extends AbstractTileEntityPlantationField {
    private final Map<String, List<BlockPos>> workingPositions = new HashMap<String, List<BlockPos>>();
    private String schematicName = "";
    private String schematicPath = "";
    private String packName = "";
    private BlockPos corner1 = BlockPos.ZERO;
    private BlockPos corner2 = BlockPos.ZERO;
    private RotationMirror rotationMirror = RotationMirror.NONE;
    private Map<BlockPos, List<String>> tagPosMap = new HashMap<BlockPos, List<String>>();
    private IColony currentColony;
    private Set<FieldRegistries.FieldEntry> plantationFieldTypes;

    public TileEntityPlantationField(BlockPos pos, BlockState state) {
        super((BlockEntityType<? extends AbstractTileEntityPlantationField>)((BlockEntityType)MinecoloniesTileEntities.PLANTATION_FIELD.get()), pos, state);
    }

    @Override
    public Set<FieldRegistries.FieldEntry> getPlantationFieldTypes() {
        if (this.plantationFieldTypes == null) {
            this.plantationFieldTypes = this.tagPosMap.values().stream().flatMap(Collection::stream).map(this::getPlantationFieldEntryFromFieldTag).filter(Objects::nonNull).collect(Collectors.toSet());
        }
        return this.plantationFieldTypes;
    }

    @Override
    public List<BlockPos> getWorkingPositions(String tag) {
        this.workingPositions.computeIfAbsent(tag, newTag -> this.tagPosMap.entrySet().stream().filter(f -> ((List)f.getValue()).contains(newTag)).distinct().map(Map.Entry::getKey).map(arg_0 -> ((BlockPos)this.worldPosition).offset(arg_0)).toList());
        return this.workingPositions.get(tag);
    }

    @Override
    public IColony getCurrentColony() {
        if (this.currentColony == null && this.level != null) {
            this.currentColony = IColonyManager.getInstance().getIColony(this.level, this.worldPosition);
        }
        return this.currentColony;
    }

    @Override
    @Nullable
    public ResourceKey<Level> getDimension() {
        IColony colony = this.getCurrentColony();
        if (colony != null) {
            return colony.getDimension();
        }
        return null;
    }

    @Override
    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @Override
    public RotationMirror getRotationMirror() {
        return this.rotationMirror;
    }

    private FieldRegistries.FieldEntry getPlantationFieldEntryFromFieldTag(String fieldTag) {
        return FieldRegistries.getFieldRegistry().stream().filter(fieldEntry -> {
            List<IPlantationModule> modules = fieldEntry.getFieldModuleProducers().stream().map(m -> (IFieldModule)m.apply(null)).filter(IPlantationModule.class::isInstance).map(m -> (IPlantationModule)m).toList();
            return modules.stream().anyMatch(module -> module.getFieldTag().equals(fieldTag));
        }).findFirst().orElse(null);
    }

    public String getSchematicName() {
        return this.schematicName;
    }

    public void setSchematicName(String s) {
        this.schematicName = s;
        this.setChanged();
    }

    public Map<BlockPos, List<String>> getPositionedTags() {
        return this.tagPosMap;
    }

    public void setPositionedTags(Map<BlockPos, List<String>> positionedTags) {
        this.tagPosMap = positionedTags;
        this.setChanged();
    }

    public Tuple<BlockPos, BlockPos> getSchematicCorners() {
        if (this.corner1 == BlockPos.ZERO || this.corner2 == BlockPos.ZERO) {
            return new Tuple((Object)this.worldPosition, (Object)this.worldPosition);
        }
        return new Tuple((Object)this.corner1, (Object)this.corner2);
    }

    public void setSchematicCorners(BlockPos pos1, BlockPos pos2) {
        this.corner1 = pos1;
        this.corner2 = pos2;
        this.setChanged();
    }

    public void readSchematicDataFromNBT(CompoundTag compound) {
        super.readSchematicDataFromNBT(compound);
        CompoundTag blueprintDataProvider = compound.getCompound("blueprintDataProvider");
        if (compound.contains("pack")) {
            String path = blueprintDataProvider.getString("name");
            this.schematicPath = path + File.separator + this.schematicName + ".blueprint";
        } else {
            String[] split;
            if (compound.contains("name")) {
                this.schematicPath = compound.getString("name");
                split = Utils.splitPath(this.schematicPath);
                this.schematicName = split[split.length - 1].replace(".blueprint", "");
            }
            if ((split = Utils.splitPath(this.schematicPath)).length >= 4) {
                this.packName = BlueprintMapping.getStyleMapping(split[2]);
            }
            if (this.packName == null || this.packName.isEmpty()) {
                this.packName = "Colonial";
            }
            if (this.schematicName.contains("/") || this.schematicName.contains("\\")) {
                String[] splitName = Utils.splitPath(this.schematicPath);
                this.schematicName = splitName[splitName.length - 1].replace(".blueprint", "");
            }
            this.schematicPath = StructurePacks.hasPack((String)this.packName) ? StructurePacks.getStructurePack((String)this.packName).getSubPath(StructurePacks.findBlueprint((String)this.packName, (String)this.schematicName)) : this.schematicName;
            if (!this.schematicPath.endsWith(".blueprint")) {
                this.schematicPath = this.schematicPath + ".blueprint";
            }
        }
        if (blueprintDataProvider.contains("pack")) {
            this.packName = blueprintDataProvider.getString("pack");
        }
        if (this.packName == null) {
            this.packName = "Colonial";
        }
    }

    public BlockPos getTilePos() {
        return this.worldPosition;
    }

    public void rotateAndMirror(RotationMirror rotMir) {
        this.rotationMirror = rotMir;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet, @NotNull HolderLookup.Provider provider) {
        CompoundTag compound = packet.getTag();
        this.loadAdditional(compound, provider);
    }

    public void loadAdditional(CompoundTag compound, @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        super.readSchematicDataFromNBT(compound);
        this.rotationMirror = compound.contains("rotMir", 1) ? RotationMirror.values()[compound.getByte("rotMir")] : RotationMirror.of((Rotation)Rotation.values()[compound.getInt("rotation")], (Mirror)(compound.getBoolean("mirror") ? Mirror.FRONT_BACK : Mirror.NONE));
        if (compound.contains("path")) {
            this.schematicPath = compound.getString("path");
        }
        if (compound.contains("name")) {
            this.schematicName = compound.getString("name");
            if (this.schematicPath == null || this.schematicPath.isEmpty()) {
                this.schematicPath = this.schematicName;
                this.schematicName = "";
            }
        }
        this.packName = compound.getString("pack");
        if (!this.schematicPath.endsWith(".blueprint")) {
            this.schematicPath = this.schematicPath + ".blueprint";
        }
    }

    public void saveAdditional(CompoundTag compound, @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        this.writeSchematicDataToNBT(compound);
        compound.putByte("rotMir", (byte)this.rotationMirror.ordinal());
        compound.putString("name", this.schematicName == null ? "" : this.schematicName);
        compound.putString("path", this.schematicPath == null ? "" : this.schematicPath);
        compound.putString("pack", this.packName == null || this.packName.isEmpty() ? "" : this.packName);
    }

    public void setChanged() {
        if (this.level != null) {
            WorldUtil.markChunkDirty(this.level, this.worldPosition);
        }
    }

    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider provider) {
        return this.saveWithId(provider);
    }

    public void setBlueprintPath(String filePath) {
        this.schematicPath = filePath;
        if (!this.schematicPath.endsWith(".blueprint")) {
            this.schematicPath = this.schematicPath + ".blueprint";
        }
        this.setChanged();
    }

    public void setPackName(String packName) {
        this.packName = packName;
        this.setChanged();
    }

    public String getBlueprintPath() {
        return this.schematicPath;
    }

    public String getPackName() {
        return this.packName;
    }
}

