/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.tileentities;

import com.ldtteam.structurize.util.BlockUtils;
import com.minecolonies.api.tileentities.ITickable;
import com.minecolonies.api.tileentities.MinecoloniesTileEntities;
import com.minecolonies.api.util.WorldUtil;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class TileEntityCompostedDirt
extends BlockEntity
implements ITickable {
    private boolean composted = false;
    private int ticker = 0;
    private double percentage = 1.0;
    private static final int TICKER_LIMIT = 300;
    private final Random random = new Random();
    private ItemStack flower;

    public TileEntityCompostedDirt(BlockPos pos, BlockState state) {
        super((BlockEntityType)MinecoloniesTileEntities.COMPOSTED_DIRT.get(), pos, state);
    }

    @Override
    public void tick() {
        Level world = this.getLevel();
        if (!world.isClientSide && this.composted && this.ticker % 20 == 0) {
            this.updateTick(world);
        }
        ++this.ticker;
    }

    private void updateTick(@NotNull Level worldIn) {
        BlockPos position;
        if (this.flower == null || this.flower.isEmpty()) {
            this.composted = false;
            return;
        }
        if (this.composted) {
            ((ServerLevel)worldIn).sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (double)this.getBlockPos().getX() + 0.5, (double)(this.getBlockPos().getY() + 1), (double)this.getBlockPos().getZ() + 0.5, 1, 0.2, 0.0, 0.2, 0.0);
        }
        if (this.random.nextDouble() * 100.0 <= this.percentage && worldIn.getBlockState(position = this.worldPosition.above()).getBlock() instanceof AirBlock) {
            if (this.flower.getItem() instanceof BlockItem) {
                if (((BlockItem)this.flower.getItem()).getBlock() instanceof DoublePlantBlock) {
                    DoublePlantBlock cfr_ignored_0 = (DoublePlantBlock)((BlockItem)this.flower.getItem()).getBlock();
                    DoublePlantBlock.placeAt((LevelAccessor)worldIn, (BlockState)((BlockItem)this.flower.getItem()).getBlock().defaultBlockState(), (BlockPos)position, (int)3);
                } else {
                    worldIn.setBlockAndUpdate(position, ((BlockItem)this.flower.getItem()).getBlock().defaultBlockState());
                }
            } else {
                worldIn.setBlockAndUpdate(position, BlockUtils.getBlockStateFromStack((ItemStack)this.flower));
            }
        }
        if (this.ticker >= 6000) {
            this.ticker = 0;
            this.composted = false;
        }
    }

    public void setChanged() {
        if (this.level != null) {
            WorldUtil.markChunkDirty(this.level, this.worldPosition);
        }
    }

    public void compost(double percentage, @NotNull ItemStack flower) {
        if (percentage >= 0.0 && percentage <= 100.0) {
            this.percentage = percentage;
            try {
                this.flower = flower;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.composted = true;
    }

    public boolean isComposted() {
        return this.composted;
    }
}

