/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.research;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.research.IResearchRequirement;
import com.minecolonies.api.research.ModResearchRequirements;
import com.minecolonies.api.research.registry.ResearchRequirementEntry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;

public class ResearchResearchRequirement
implements IResearchRequirement {
    private static final String TAG_ID = "id";
    private static final String TAG_NAME = "name";
    private final ResourceLocation researchId;
    private final MutableComponent researchName;

    public ResearchResearchRequirement(ResourceLocation researchId) {
        this.researchId = researchId;
        this.researchName = Component.translatableEscape((String)("com." + researchId.getNamespace() + ".research." + researchId.getPath().replaceAll("[ /]", ".") + ".name"), (Object[])new Object[0]);
    }

    public ResearchResearchRequirement(ResourceLocation researchId, MutableComponent researchName) {
        this.researchId = researchId;
        this.researchName = researchName;
    }

    public ResearchResearchRequirement(CompoundTag nbt) {
        this.researchId = ResourceLocation.parse((String)nbt.getString(TAG_ID));
        this.researchName = Component.translatableEscape((String)nbt.getString(TAG_NAME), (Object[])new Object[0]);
    }

    public ResourceLocation getResearchId() {
        return this.researchId;
    }

    @Override
    public boolean isFulfilled(IColony colony) {
        return colony.getResearchManager().getResearchTree().hasCompletedResearch(this.researchId);
    }

    @Override
    public MutableComponent getDesc() {
        return Component.translatableEscape((String)"com.minecolonies.coremod.research.requirement.research", (Object[])new Object[]{this.researchName});
    }

    @Override
    public ResearchRequirementEntry getRegistryEntry() {
        return (ResearchRequirementEntry)ModResearchRequirements.researchResearchRequirement.get();
    }

    @Override
    public CompoundTag writeToNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.putString(TAG_ID, this.researchId.toString());
        nbt.putString(TAG_NAME, this.researchName.getContents() instanceof TranslatableContents ? ((TranslatableContents)this.researchName.getContents()).getKey() : "");
        return nbt;
    }
}

