/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.research;

import com.google.gson.JsonObject;
import com.minecolonies.api.research.IGlobalResearchBranch;
import com.minecolonies.api.research.ResearchBranchType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;

public class GlobalResearchBranch
implements IGlobalResearchBranch {
    public static final String RESEARCH_BRANCH_NAME_PROP = "branch-name";
    private static final String RESEARCH_SUBTITLE_PROP = "subtitle";
    public static final String RESEARCH_BRANCH_TYPE_PROP = "branch-type";
    public static final String RESEARCH_BASE_TIME_PROP = "base-time";
    private static final String RESEARCH_HIDDEN_PROP = "hidden";
    private static final String RESEARCH_SORT_PROP = "sortOrder";
    private final TranslatableContents name;
    private final TranslatableContents subtitle;
    private final ResearchBranchType type;
    private final double baseTime;
    private final int sortOrder;
    private final boolean hidden;

    @Override
    public TranslatableContents getName() {
        return this.name;
    }

    @Override
    public TranslatableContents getSubtitle() {
        return this.subtitle;
    }

    @Override
    public int getBaseTime(int depth) {
        return (int)(72.0 * this.baseTime * Math.pow(2.0, depth - 1));
    }

    @Override
    public double getHoursTime(int depth) {
        return (double)this.getBaseTime(depth) * 25.0 / 60.0 / 60.0;
    }

    @Override
    public int getSortOrder() {
        return this.sortOrder;
    }

    @Override
    public ResearchBranchType getType() {
        return this.type;
    }

    @Override
    public boolean getHidden() {
        return this.hidden;
    }

    public GlobalResearchBranch(ResourceLocation id) {
        this.name = id.getPath().isEmpty() ? new TranslatableContents("", null, TranslatableContents.NO_ARGS) : new TranslatableContents(id.getPath().substring(0, 1).toUpperCase() + id.getPath().substring(1), null, TranslatableContents.NO_ARGS);
        this.subtitle = new TranslatableContents("", null, TranslatableContents.NO_ARGS);
        this.baseTime = 1.0;
        this.type = ResearchBranchType.DEFAULT;
        this.hidden = false;
        this.sortOrder = 1000;
    }

    public GlobalResearchBranch(ResourceLocation id, JsonObject researchJson) {
        this.name = researchJson.has(RESEARCH_BRANCH_NAME_PROP) && researchJson.get(RESEARCH_BRANCH_NAME_PROP).isJsonPrimitive() && researchJson.get(RESEARCH_BRANCH_NAME_PROP).getAsJsonPrimitive().isString() ? new TranslatableContents(researchJson.get(RESEARCH_BRANCH_NAME_PROP).getAsJsonPrimitive().getAsString(), null, TranslatableContents.NO_ARGS) : (id.getPath().isEmpty() ? new TranslatableContents("", null, TranslatableContents.NO_ARGS) : new TranslatableContents(id.getPath().substring(0, 1).toUpperCase() + id.getPath().substring(1), null, TranslatableContents.NO_ARGS));
        this.subtitle = researchJson.has(RESEARCH_SUBTITLE_PROP) && researchJson.get(RESEARCH_SUBTITLE_PROP).isJsonPrimitive() && researchJson.get(RESEARCH_SUBTITLE_PROP).getAsJsonPrimitive().isString() ? new TranslatableContents(researchJson.get(RESEARCH_SUBTITLE_PROP).getAsJsonPrimitive().getAsString(), null, TranslatableContents.NO_ARGS) : new TranslatableContents("", null, TranslatableContents.NO_ARGS);
        this.baseTime = researchJson.has(RESEARCH_BASE_TIME_PROP) && researchJson.get(RESEARCH_BASE_TIME_PROP).isJsonPrimitive() && researchJson.get(RESEARCH_BASE_TIME_PROP).getAsJsonPrimitive().isNumber() ? researchJson.get(RESEARCH_BASE_TIME_PROP).getAsJsonPrimitive().getAsDouble() : 1.0;
        this.sortOrder = researchJson.has(RESEARCH_SORT_PROP) && researchJson.get(RESEARCH_SORT_PROP).isJsonPrimitive() && researchJson.get(RESEARCH_SORT_PROP).getAsJsonPrimitive().isNumber() ? researchJson.get(RESEARCH_SORT_PROP).getAsJsonPrimitive().getAsInt() : 1000;
        this.type = researchJson.has(RESEARCH_BRANCH_TYPE_PROP) && researchJson.get(RESEARCH_BRANCH_TYPE_PROP).isJsonPrimitive() && researchJson.get(RESEARCH_BRANCH_TYPE_PROP).getAsJsonPrimitive().isString() ? ResearchBranchType.valueOfTag(researchJson.get(RESEARCH_BRANCH_TYPE_PROP).getAsJsonPrimitive().getAsString()) : ResearchBranchType.DEFAULT;
        this.hidden = researchJson.has(RESEARCH_HIDDEN_PROP) && researchJson.get(RESEARCH_HIDDEN_PROP).isJsonPrimitive() && researchJson.get(RESEARCH_HIDDEN_PROP).getAsJsonPrimitive().isBoolean() ? researchJson.get(RESEARCH_HIDDEN_PROP).getAsJsonPrimitive().getAsBoolean() : false;
    }

    public GlobalResearchBranch(CompoundTag nbt) {
        this.name = new TranslatableContents(nbt.getString(RESEARCH_BRANCH_NAME_PROP), null, TranslatableContents.NO_ARGS);
        this.subtitle = new TranslatableContents(nbt.getString(RESEARCH_SUBTITLE_PROP), null, TranslatableContents.NO_ARGS);
        this.type = ResearchBranchType.valueOfTag(nbt.getString(RESEARCH_BRANCH_TYPE_PROP));
        this.baseTime = nbt.getDouble(RESEARCH_BASE_TIME_PROP);
        this.sortOrder = nbt.getInt(RESEARCH_SORT_PROP);
        this.hidden = nbt.getBoolean(RESEARCH_HIDDEN_PROP);
    }

    @Override
    public CompoundTag writeToNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.putString(RESEARCH_BRANCH_NAME_PROP, this.name.getKey());
        nbt.putString(RESEARCH_SUBTITLE_PROP, this.subtitle.getKey());
        nbt.putString(RESEARCH_BRANCH_TYPE_PROP, this.type.tag);
        nbt.putDouble(RESEARCH_BASE_TIME_PROP, this.baseTime);
        nbt.putInt(RESEARCH_SORT_PROP, this.sortOrder);
        nbt.putBoolean(RESEARCH_HIDDEN_PROP, this.hidden);
        return nbt;
    }
}

