/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony.citizen;

import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.util.Log;
import com.minecolonies.core.network.messages.server.AbstractColonyServerMessage;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class AdjustSkillCitizenMessage
extends AbstractColonyServerMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"adjust_skill_citizen", AdjustSkillCitizenMessage::new);
    private final int citizenId;
    private final int quantity;
    private final Skill skill;

    public AdjustSkillCitizenMessage(IColony colony, @NotNull ICitizenDataView citizenDataView, int quantity, Skill skill) {
        super(TYPE, colony);
        this.citizenId = citizenDataView.getId();
        this.quantity = quantity;
        this.skill = skill;
    }

    protected AdjustSkillCitizenMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.citizenId = buf.readInt();
        this.quantity = buf.readInt();
        this.skill = Skill.values()[buf.readInt()];
    }

    @Override
    protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.citizenId);
        buf.writeInt(this.quantity);
        buf.writeInt(this.skill.ordinal());
    }

    @Override
    protected void onExecute(IPayloadContext ctxIn, ServerPlayer player, IColony colony) {
        ICitizenData citizenData = colony.getCitizenManager().getCivilian(this.citizenId);
        if (citizenData == null) {
            Log.getLogger().warn("AdjustSkillCitizenMessage citizenData is null");
            return;
        }
        Optional<AbstractEntityCitizen> optionalEntityCitizen = citizenData.getEntity();
        if (!optionalEntityCitizen.isPresent()) {
            Log.getLogger().warn("AdjustSkillCitizenMessage entity citizen is null");
            return;
        }
        boolean isCreative = player.isCreative();
        if (!isCreative) {
            Log.getLogger().warn("AdjustSkillCitizenMessage player must be creative.");
            return;
        }
        citizenData.getCitizenSkillHandler().incrementLevel(this.skill, this.quantity);
        citizenData.markDirty(0);
    }
}

