/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server;

import com.ldtteam.common.network.AbstractServerPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.ldtteam.structurize.storage.ServerFutureProcessor;
import com.ldtteam.structurize.storage.StructurePacks;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.items.component.ColonyId;
import com.minecolonies.api.items.component.HutBlockData;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.Utils;
import com.minecolonies.core.tileentities.TileEntityColonyBuilding;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class DirectPlaceMessage
extends AbstractServerPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"direct_place", DirectPlaceMessage::new);
    private final BlockState state;
    private final BlockPos pos;
    private final ItemStack stack;

    public DirectPlaceMessage(BlockState state, BlockPos pos, ItemStack stack) {
        super(TYPE);
        this.state = state;
        this.pos = pos;
        this.stack = stack;
    }

    protected DirectPlaceMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.state = Block.stateById((int)buf.readInt());
        this.pos = buf.readBlockPos();
        this.stack = Utils.deserializeCodecMess(buf);
    }

    protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        buf.writeInt(Block.getId((BlockState)this.state));
        buf.writeBlockPos(this.pos);
        Utils.serializeCodecMess(buf, this.stack);
    }

    protected void onExecute(IPayloadContext ctxIn, ServerPlayer player) {
        Level world = player.getCommandSenderWorld();
        IColony colony = IColonyManager.getInstance().getColonyByPosFromWorld(world, this.pos);
        InventoryUtils.reduceStackInItemHandler((IItemHandler)new InvWrapper((Container)player.getInventory()), this.stack);
        if (colony == null && this.state.getBlock() == ModBlocks.blockHutTownHall || colony != null && colony.getPermissions().hasPermission((Player)player, Action.MANAGE_HUTS)) {
            ColonyId colonyId = ColonyId.readFromItemStack(this.stack);
            if (colony != null && colonyId.hasColonyId() && colony.getID() != colonyId.id()) {
                MessageUtils.format("com.minecolonies.coremod.gui.buildtool.wrongcolony", colonyId.id()).sendTo(new Player[]{player});
                return;
            }
            player.getCommandSenderWorld().setBlockAndUpdate(this.pos, this.state);
            BlockEntity blockEntity = world.getBlockEntity(this.pos);
            if (blockEntity instanceof TileEntityColonyBuilding) {
                TileEntityColonyBuilding hut = (TileEntityColonyBuilding)blockEntity;
                hut.setStructurePack(StructurePacks.selectedPack);
                ServerFutureProcessor.queueBlueprint((ServerFutureProcessor.BlueprintProcessingData)new ServerFutureProcessor.BlueprintProcessingData(StructurePacks.findBlueprintFuture((String)StructurePacks.selectedPack.getName(), blueprint -> blueprint.getBlockState(blueprint.getPrimaryBlockOffset()).getBlock() == this.state.getBlock(), (HolderLookup.Provider)player.level().registryAccess()), world, blueprint -> {
                    IBuilding building;
                    if (blueprint == null) {
                        return;
                    }
                    String fullPath = blueprint.getFilePath().toString();
                    fullPath = fullPath.replace(StructurePacks.selectedPack.getPath().toString() + "/", "");
                    hut.setBlueprintPath(fullPath + "/" + blueprint.getFileName().substring(0, blueprint.getFileName().length() - 1) + "1.blueprint");
                    this.state.getBlock().setPlacedBy(world, this.pos, this.state, (LivingEntity)player, this.stack);
                    HutBlockData hutComponent = HutBlockData.readFromItemStack(this.stack);
                    if (hutComponent != null && (building = colony.getBuildingManager().getBuilding(this.pos)) != null) {
                        building.setBuildingLevel(hutComponent.level());
                        building.setDeconstructed();
                    }
                }));
            }
        }
    }
}

