/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.client;

import com.ldtteam.common.network.AbstractClientPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.core.client.render.worldevent.PathfindingDebugRenderer;
import com.minecolonies.core.entity.pathfinding.MNode;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class SyncPathReachedMessage
extends AbstractClientPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forClient((String)"minecolonies", (String)"sync_path_reached", SyncPathReachedMessage::new);
    public final Set<BlockPos> reached;

    public SyncPathReachedMessage(Set<BlockPos> reached) {
        super(TYPE);
        this.reached = new HashSet<BlockPos>(reached);
    }

    protected void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeCollection(this.reached, FriendlyByteBuf::writeBlockPos);
    }

    protected SyncPathReachedMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.reached = (Set)buf.readCollection(HashSet::new, FriendlyByteBuf::readBlockPos);
    }

    protected void onExecute(IPayloadContext ctxIn, Player player) {
        for (MNode node : PathfindingDebugRenderer.lastDebugNodesPath) {
            for (BlockPos reachedPos : this.reached) {
                if (reachedPos.getX() != node.x || reachedPos.getY() != node.y || reachedPos.getZ() != node.z) continue;
                node.setReachedByWorker(true);
            }
        }
    }
}

