/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.client;

import com.ldtteam.common.network.AbstractClientPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.core.client.gui.townhall.WindowTownHallColonyManage;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class OpenColonyFoundingCovenantMessage
extends AbstractClientPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forClient((String)"minecolonies", (String)"open_colony_founding_covenant", OpenColonyFoundingCovenantMessage::new);
    private String closestName;
    private int closestDistance;
    private BlockPos townHallPos;

    public OpenColonyFoundingCovenantMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(type);
        this.closestName = buf.readUtf(Short.MAX_VALUE);
        this.closestDistance = buf.readInt();
        this.townHallPos = buf.readBlockPos();
    }

    public OpenColonyFoundingCovenantMessage(String closestName, int closestDistance, BlockPos townHallPos) {
        super(TYPE);
        this.closestName = closestName;
        this.closestDistance = closestDistance;
        this.townHallPos = townHallPos;
    }

    protected void onExecute(IPayloadContext ctxIn, Player player) {
        new WindowTownHallColonyManage(this.townHallPos, this.closestName, this.closestDistance, "", false).open();
    }

    public void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeUtf(this.closestName);
        buf.writeInt(this.closestDistance);
        buf.writeBlockPos(this.townHallPos);
    }
}

