/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.items;

import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.workorders.IWorkOrderView;
import com.minecolonies.api.items.component.BuildingId;
import com.minecolonies.api.items.component.WarehouseSnapshot;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.client.gui.WindowResourceList;
import com.minecolonies.core.colony.buildings.moduleviews.BuildingResourcesModuleView;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingBuilder;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingWareHouse;
import com.minecolonies.core.items.AbstractItemMinecolonies;
import com.minecolonies.core.network.messages.server.ResourceScrollSaveWarehouseSnapshotMessage;
import com.minecolonies.core.tileentities.TileEntityRack;
import com.minecolonies.core.tileentities.TileEntityWareHouse;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemResourceScroll
extends AbstractItemMinecolonies {
    public ItemResourceScroll(Item.Properties properties) {
        super("resourcescroll", properties.stacksTo(1));
    }

    private static void openWindow(ItemStack stack, Player player) {
        IBuildingView buildingView = BuildingId.readBuildingViewFromItemStack(stack);
        if (!(buildingView instanceof BuildingBuilder.View)) {
            MessageUtils.format((Component)Component.translatableEscape((String)"com.minecolonies.coremod.item.scroll.needcolony", (Object[])new Object[0])).sendTo(player);
            return;
        }
        BuildingBuilder.View builderBuildingView = (BuildingBuilder.View)buildingView;
        String currentHash = ItemResourceScroll.getWorkOrderHash(buildingView);
        WarehouseSnapshot warehouseSnapshotComponent = WarehouseSnapshot.readFromItemStack(stack);
        boolean snapshotNeedsUpdate = !Objects.equals(currentHash, warehouseSnapshotComponent.hash());
        HashMap<String, Integer> warehouseSnapshot = new HashMap();
        if (snapshotNeedsUpdate) {
            new ResourceScrollSaveWarehouseSnapshotMessage(buildingView.getID()).sendToServer();
        } else if (!warehouseSnapshotComponent.hash().isEmpty()) {
            warehouseSnapshot = warehouseSnapshotComponent.snapshot();
        }
        new WindowResourceList(builderBuildingView, warehouseSnapshot).open();
    }

    @NotNull
    private static String getWorkOrderHash(IBuildingView buildingView) {
        Optional<IWorkOrderView> currentWorkOrder = buildingView.getColony().getWorkOrders().stream().filter(o -> o.getClaimedBy().equals((Object)buildingView.getID())).max(Comparator.comparingInt(IWorkOrderView::getPriority));
        if (currentWorkOrder.isEmpty()) {
            return "";
        }
        long location = currentWorkOrder.get().getLocation().asLong();
        return location + "__" + currentWorkOrder.get().getPackName();
    }

    private static void updateWarehouseSnapshot(BlockPos warehousePos, ItemStack stack, Player player) {
        IBuildingView buildingView = BuildingId.readBuildingViewFromItemStack(stack);
        if (!(buildingView instanceof BuildingBuilder.View)) {
            MessageUtils.format("com.minecolonies.coremod.item.scroll.needcolony", new Object[0]).sendTo(player);
            return;
        }
        String currentHash = ItemResourceScroll.getWorkOrderHash(buildingView);
        WarehouseSnapshot warehouseSnapshotData = ItemResourceScroll.gatherWarehouseSnapshot(buildingView, warehousePos, currentHash, player);
        if (warehouseSnapshotData != null) {
            new ResourceScrollSaveWarehouseSnapshotMessage(buildingView.getID(), warehouseSnapshotData.snapshot(), warehouseSnapshotData.hash()).sendToServer();
        } else {
            new ResourceScrollSaveWarehouseSnapshotMessage(buildingView.getID()).sendToServer();
        }
    }

    @Nullable
    private static WarehouseSnapshot gatherWarehouseSnapshot(IBuildingView buildingView, BlockPos warehouseBlockPos, String hash, Player player) {
        IBuildingView warehouse = buildingView.getColony().getBuilding(warehouseBlockPos);
        if (warehouse == null) {
            MessageUtils.format("com.minecolonies.coremod.item.scroll.wrong_colony", new Object[0]).sendTo(player);
            return null;
        }
        if (hash.isBlank()) {
            return null;
        }
        BuildingResourcesModuleView resourcesModule = buildingView.getModuleViewByType(BuildingResourcesModuleView.class);
        HashMap<String, Integer> items = new HashMap<String, Integer>();
        for (BlockPos container : warehouse.getContainerList()) {
            BlockEntity blockEntity = warehouse.getColony().getWorld().getBlockEntity(container);
            if (!(blockEntity instanceof TileEntityRack)) continue;
            TileEntityRack rack = (TileEntityRack)blockEntity;
            rack.getAllContent().forEach((item, amount) -> {
                int hashCode = item.getItemStack().getComponentsPatch().hashCode();
                String key = item.getItemStack().getDescriptionId() + "-" + hashCode;
                if (!resourcesModule.getResources().containsKey(key)) {
                    return;
                }
                int oldAmount = items.getOrDefault(key, 0);
                items.put(key, oldAmount + amount);
            });
        }
        return new WarehouseSnapshot(items, hash);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext ctx) {
        ItemStack scroll = ctx.getPlayer().getItemInHand(ctx.getHand());
        BlockEntity entity = ctx.getLevel().getBlockEntity(ctx.getClickedPos());
        if (ctx.getLevel().isClientSide) {
            if (entity instanceof AbstractTileEntityColonyBuilding) {
                AbstractTileEntityColonyBuilding buildingEntity = (AbstractTileEntityColonyBuilding)entity;
                if (buildingEntity instanceof TileEntityWareHouse) {
                    ItemResourceScroll.updateWarehouseSnapshot(buildingEntity.getTilePos(), scroll, ctx.getPlayer());
                }
            } else {
                ItemResourceScroll.openWindow(scroll, ctx.getPlayer());
            }
        } else if (entity instanceof AbstractTileEntityColonyBuilding) {
            AbstractTileEntityColonyBuilding buildingEntity = (AbstractTileEntityColonyBuilding)entity;
            if (buildingEntity.getBuilding() instanceof BuildingBuilder) {
                buildingEntity.getBuilding().writeToItemStack(scroll);
                MessageUtils.format("com.minecolonies.coremod.item.scroll.registered", buildingEntity.getColony().getName()).sendTo(ctx.getPlayer());
            } else if (buildingEntity.getBuilding() instanceof BuildingWareHouse) {
                MessageUtils.format("com.minecolonies.coremod.item.scroll.snapshot", new Object[0]).sendTo(ctx.getPlayer());
            } else if (buildingEntity.getBuilding() != null) {
                MutableComponent buildingTypeComponent = MessageUtils.format(buildingEntity.getBuilding().getBuildingType().getTranslationKey(), new Object[0]).create();
                MessageUtils.format("com.minecolonies.coremod.item.scroll.wrong_building", buildingTypeComponent, buildingEntity.getColony().getName()).sendTo(ctx.getPlayer());
            }
        }
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand hand) {
        ItemStack resourceScroll = playerIn.getItemInHand(hand);
        if (!worldIn.isClientSide) {
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)resourceScroll);
        }
        ItemResourceScroll.openWindow(resourceScroll, playerIn);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)resourceScroll);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext ctx, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, ctx, tooltip, flagIn);
        IBuildingView buildingView = BuildingId.readBuildingViewFromItemStack(stack);
        if (buildingView instanceof BuildingBuilder.View) {
            BuildingBuilder.View builderBuildingView = (BuildingBuilder.View)buildingView;
            String name = builderBuildingView.getWorkerName();
            tooltip.add((Component)(name != null && !name.trim().isEmpty() ? Component.literal((String)(String.valueOf(ChatFormatting.DARK_PURPLE) + name)) : Component.translatableEscape((String)"com.minecolonies.coremod.item.scroll.no_builder", (Object[])new Object[0])));
        }
    }
}

