/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.generation.defaults.workers;

import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.core.generation.CustomRecipeProvider;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class DefaultBlacksmithCraftingProvider
extends CustomRecipeProvider {
    private static final String BLACKSMITH = ModJobs.BLACKSMITH_ID.getPath();

    public DefaultBlacksmithCraftingProvider(@NotNull PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(packOutput, lookupProvider);
    }

    @NotNull
    public String getName() {
        return "DefaultBlacksmithCraftingProvider";
    }

    @Override
    protected void registerRecipes(@NotNull Consumer<CustomRecipeProvider.CustomRecipeBuilder> consumer) {
        this.plate(consumer, 4, 1, (ItemLike)ModItems.plateArmorHelmet);
        this.plate(consumer, 7, 3, (ItemLike)ModItems.plateArmorChest);
        this.plate(consumer, 6, 4, (ItemLike)ModItems.plateArmorLegs);
        this.plate(consumer, 3, 1, (ItemLike)ModItems.plateArmorBoots);
        this.netherite(consumer, (ItemLike)Items.DIAMOND_SWORD, (ItemLike)Items.NETHERITE_SWORD);
        this.netherite(consumer, (ItemLike)Items.DIAMOND_PICKAXE, (ItemLike)Items.NETHERITE_PICKAXE);
        this.netherite(consumer, (ItemLike)Items.DIAMOND_AXE, (ItemLike)Items.NETHERITE_AXE);
        this.netherite(consumer, (ItemLike)Items.DIAMOND_SHOVEL, (ItemLike)Items.NETHERITE_SHOVEL);
        this.netherite(consumer, (ItemLike)Items.DIAMOND_HOE, (ItemLike)Items.NETHERITE_HOE);
        this.netherite(consumer, (ItemLike)Items.DIAMOND_HELMET, (ItemLike)Items.NETHERITE_HELMET);
        this.netherite(consumer, (ItemLike)Items.DIAMOND_CHESTPLATE, (ItemLike)Items.NETHERITE_CHESTPLATE);
        this.netherite(consumer, (ItemLike)Items.DIAMOND_LEGGINGS, (ItemLike)Items.NETHERITE_LEGGINGS);
        this.netherite(consumer, (ItemLike)Items.DIAMOND_BOOTS, (ItemLike)Items.NETHERITE_BOOTS);
    }

    private void plate(@NotNull Consumer<CustomRecipeProvider.CustomRecipeBuilder> consumer, int ironCount, int coalCount, @NotNull ItemLike output) {
        this.recipe(BLACKSMITH, "crafting", BuiltInRegistries.ITEM.getKey((Object)output.asItem()).getPath()).inputs(List.of(new ItemStorage(new ItemStack((ItemLike)Items.IRON_INGOT, ironCount)), new ItemStorage(new ItemStack((ItemLike)Items.LEATHER)), new ItemStorage(new ItemStack((ItemLike)Items.COAL, coalCount)))).result(new ItemStack(output)).minBuildingLevel(4).minResearchId(ResearchConstants.PLATE_ARMOR).showTooltip(true).build(consumer);
    }

    private void netherite(@NotNull Consumer<CustomRecipeProvider.CustomRecipeBuilder> consumer, @NotNull ItemLike input, @NotNull ItemLike output) {
        this.recipe(BLACKSMITH, "crafting", BuiltInRegistries.ITEM.getKey((Object)output.asItem()).getPath()).inputs(List.of(new ItemStorage(new ItemStack(input)), new ItemStorage(new ItemStack((ItemLike)Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE)), new ItemStorage(new ItemStack((ItemLike)Items.NETHERITE_INGOT)), new ItemStorage(new ItemStack((ItemLike)Items.DIAMOND, 7)), new ItemStorage(new ItemStack((ItemLike)Items.NETHERRACK)))).result(new ItemStack(output)).secondaryOutputs(Collections.singletonList(new ItemStack((ItemLike)Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE))).minBuildingLevel(4).build(consumer);
    }
}

