/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.generation;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.jetbrains.annotations.NotNull;

public abstract class SimpleLootTableProvider
extends LootTableProvider {
    protected SimpleLootTableProvider(@NotNull PackOutput output, @NotNull CompletableFuture<HolderLookup.Provider> provider) {
        super(output, new HashSet(), new ArrayList(), provider);
    }

    public static ResourceKey<LootTable> table(@NotNull ResourceLocation id) {
        return ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)id);
    }

    public static LootPoolSingletonContainer.Builder<?> itemStack(@NotNull ItemStack stack) {
        if (!stack.isEmpty()) {
            LootPoolSingletonContainer.Builder builder = LootItem.lootTableItem((ItemLike)stack.getItem());
            if (!stack.isComponentsPatchEmpty()) {
                for (Map.Entry entry : stack.getComponentsPatch().entrySet()) {
                    ((Optional)entry.getValue()).ifPresent(SimpleLootTableProvider.setComponent(entry, builder));
                }
            }
            if (stack.getCount() > 1) {
                builder.apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)stack.getCount())));
            }
            return builder;
        }
        return EmptyLootItem.emptyItem();
    }

    @NotNull
    private static <T> Consumer<T> setComponent(Map.Entry<DataComponentType<?>, Optional<?>> entry, LootPoolSingletonContainer.Builder<?> builder) {
        return value -> builder.apply((LootItemFunction.Builder)SetComponentsFunction.setComponent((DataComponentType)((DataComponentType)entry.getKey()), (Object)value));
    }
}

