/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.workers.production;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.modules.ICraftingBuildingModule;
import com.minecolonies.api.colony.requestsystem.requestable.StackList;
import com.minecolonies.api.compatibility.tinkers.TinkersToolHelper;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.ai.workers.util.GuardGear;
import com.minecolonies.api.entity.ai.workers.util.GuardGearBuilder;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.items.component.AdventureData;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.DamageSourceKeys;
import com.minecolonies.api.util.EntityUtils;
import com.minecolonies.api.util.IItemHandlerCapProvider;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.constant.GuardConstants;
import com.minecolonies.core.colony.buildings.modules.BuildingModules;
import com.minecolonies.core.colony.buildings.modules.ExpeditionLogModule;
import com.minecolonies.core.colony.buildings.modules.expedition.ExpeditionLog;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingNetherWorker;
import com.minecolonies.core.colony.jobs.JobNetherWorker;
import com.minecolonies.core.entity.ai.workers.crafting.AbstractEntityAICrafting;
import com.minecolonies.core.items.ItemAdventureToken;
import com.minecolonies.core.util.TeleportHelper;
import com.minecolonies.core.util.citizenutils.CitizenItemUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.portal.PortalShape;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityAIWorkNether
extends AbstractEntityAICrafting<JobNetherWorker, BuildingNetherWorker> {
    private static final int TICK_DELAY = 40;
    private static final String OBJECTIVE_HUT_LEVEL = "HutLevel";
    private static final String OBJECTIVE_SECONDARY_SKILL = "SecSkillLevel";
    private static final float SECONDARY_DAMAGE_REDUCTION = 0.005f;
    private final Map<EquipmentSlot, ItemStack> virtualEquipmentSlots = new HashMap<EquipmentSlot, ItemStack>();
    final List<ItemStack> netherEdible = IColonyManager.getInstance().getCompatibilityManager().getEdibles(((BuildingNetherWorker)this.building).getBuildingLevel() - 1).stream().map(ItemStorage::getItemStack).collect(Collectors.toList());
    public final List<List<GuardGear>> itemsNeeded = new ArrayList<List<GuardGear>>();

    public EntityAIWorkNether(@NotNull JobNetherWorker job) {
        super(job);
        super.registerTargets(new AITarget<Object>(AIWorkerState.NETHER_LEAVE, this::leaveForNether, 40), new AITarget<Object>(AIWorkerState.NETHER_AWAY, this::stayInNether, 40), new AITarget<Object>(AIWorkerState.NETHER_RETURN, this::returnFromNether, 40), new AITarget<Object>(AIWorkerState.NETHER_OPENPORTAL, this::openPortal, 40), new AITarget<Object>(AIWorkerState.NETHER_CLOSEPORTAL, this::closePortal, 40));
        this.worker.setCanPickUpLoot(true);
        this.itemsNeeded.add(GuardGearBuilder.buildGearForLevel(3, Integer.MAX_VALUE, GuardConstants.LEATHER_BUILDING_LEVEL_RANGE, GuardConstants.DIA_BUILDING_LEVEL_RANGE));
        this.itemsNeeded.add(GuardGearBuilder.buildGearForLevel(2, 4, GuardConstants.LEATHER_BUILDING_LEVEL_RANGE, GuardConstants.DIA_BUILDING_LEVEL_RANGE));
        this.itemsNeeded.add(GuardGearBuilder.buildGearForLevel(0, 3, GuardConstants.LEATHER_BUILDING_LEVEL_RANGE, GuardConstants.IRON_BUILDING_LEVEL_RANGE));
        this.itemsNeeded.add(GuardGearBuilder.buildGearForLevel(0, 2, GuardConstants.LEATHER_BUILDING_LEVEL_RANGE, GuardConstants.CHAIN_BUILDING_LEVEL_RANGE));
        this.itemsNeeded.add(GuardGearBuilder.buildGearForLevel(0, 1, GuardConstants.LEATHER_BUILDING_LEVEL_RANGE, GuardConstants.GOLD_BUILDING_LEVEL_RANGE));
    }

    @Override
    protected void updateRenderMetaData() {
        StringBuilder renderData = new StringBuilder(this.getState() == AIWorkerState.CRAFT || this.getState() == AIWorkerState.NETHER_LEAVE || this.getState() == AIWorkerState.NETHER_RETURN || this.getState() == AIWorkerState.NETHER_OPENPORTAL || this.getState() == AIWorkerState.NETHER_CLOSEPORTAL ? "working" : "");
        for (int slot = 0; slot < this.worker.getInventoryCitizen().getSlots(); ++slot) {
            ItemStack stack = this.worker.getInventoryCitizen().getStackInSlot(slot);
            if (stack.getItem() == Items.TORCH && renderData.indexOf("torch") == -1) {
                renderData.append("torch");
                continue;
            }
            if (stack.canPerformAction(ItemAbilities.PICKAXE_DIG) && renderData.indexOf("pickaxe") == -1) {
                renderData.append("pickaxe");
                continue;
            }
            if (!stack.canPerformAction(ItemAbilities.SHOVEL_DIG) || renderData.indexOf("shovel") != -1) continue;
            renderData.append("shovel");
        }
        this.worker.setRenderMetadata(renderData.toString());
    }

    @Override
    public Class<BuildingNetherWorker> getExpectedBuildingClass() {
        return BuildingNetherWorker.class;
    }

    @Override
    public IAIState getStateAfterPickUp() {
        return AIWorkerState.START_WORKING;
    }

    @Override
    public boolean canBeInterrupted() {
        return !this.worker.isInvisible();
    }

    private void goToVault() {
        this.worker.playSound(SoundEvents.PORTAL_TRIGGER, this.worker.getRandom().nextFloat() * 0.5f + 0.25f, 0.25f);
        this.worker.setInvisible(true);
        this.worker.setSilent(true);
        BlockPos vaultPos = ((BuildingNetherWorker)this.building).getVaultLocation();
        if (vaultPos != null) {
            TeleportHelper.teleportCitizen(this.worker, (Level)this.world, vaultPos);
        }
    }

    private void returnFromVault(boolean force) {
        BlockPos vaultPos = ((BuildingNetherWorker)this.building).getVaultLocation();
        BlockPos portalPos = ((BuildingNetherWorker)this.building).getPortalLocation();
        if (portalPos != null && vaultPos != null && EntityUtils.isLivingAtSite((LivingEntity)this.worker, vaultPos.getX(), vaultPos.getY(), vaultPos.getZ(), 2)) {
            TeleportHelper.teleportCitizen(this.worker, (Level)this.world, portalPos);
            this.worker.setSilent(false);
            this.worker.playSound(SoundEvents.PORTAL_TRIGGER, this.worker.getRandom().nextFloat() * 0.5f + 0.25f, 0.25f);
            if (!force) {
                return;
            }
        }
        this.worker.setInvisible(false);
        this.worker.setSilent(false);
    }

    @Override
    protected IAIState decide() {
        IAIState crafterState;
        if (((JobNetherWorker)this.job).isInNether()) {
            if (!this.worker.isInvisible()) {
                this.goToVault();
            }
            return AIWorkerState.NETHER_AWAY;
        }
        if (this.worker.isInvisible()) {
            this.returnFromVault(true);
        }
        if ((crafterState = super.decide()) != AIWorkerState.IDLE && crafterState != AIWorkerState.START_WORKING) {
            return crafterState;
        }
        this.checkAndRequestArmor();
        IAIState tempState = this.checkAndRequestFood();
        if (tempState != this.getState()) {
            return tempState;
        }
        IRecipeStorage rs = ((BuildingNetherWorker.CraftingModule)((BuildingNetherWorker)this.building).getFirstModuleOccurance(BuildingNetherWorker.CraftingModule.class)).getFirstRecipe(ItemStack::isEmpty);
        boolean hasItemsAvailable = true;
        if (rs != null) {
            for (ItemStorage item : rs.getInput()) {
                if (this.checkIfRequestForItemExistOrCreateAsync(new ItemStack((ItemLike)item.getItem(), 1), item.getAmount(), item.getAmount())) continue;
                hasItemsAvailable = false;
            }
        }
        if (!hasItemsAvailable) {
            this.setDelay(60);
            return AIWorkerState.IDLE;
        }
        BlockPos portal = ((BuildingNetherWorker)this.building).getPortalLocation();
        if (portal == null) {
            Log.getLogger().warn("--- Missing Portal Tag In Nether Worker Building! Aborting Operation! ---");
            this.setDelay(120);
            return AIWorkerState.IDLE;
        }
        boolean missingAxe = this.checkForToolOrWeapon((EquipmentTypeEntry)ModEquipmentTypes.axe.get());
        boolean missingPick = this.checkForToolOrWeapon((EquipmentTypeEntry)ModEquipmentTypes.pickaxe.get());
        boolean missingShovel = this.checkForToolOrWeapon((EquipmentTypeEntry)ModEquipmentTypes.shovel.get());
        boolean missingSword = this.checkForToolOrWeapon((EquipmentTypeEntry)ModEquipmentTypes.sword.get());
        boolean missingLighter = this.checkForToolOrWeapon((EquipmentTypeEntry)ModEquipmentTypes.flint_and_steel.get());
        if (missingAxe || missingPick || missingShovel || missingSword || missingLighter) {
            this.worker.getCitizenData().setIdleAtJob(true);
            this.setDelay(60);
            return AIWorkerState.IDLE;
        }
        if (this.currentRecipeStorage == null) {
            BlockState block;
            ICraftingBuildingModule module = (ICraftingBuildingModule)((BuildingNetherWorker)this.building).getFirstModuleOccurance(BuildingNetherWorker.CraftingModule.class);
            this.currentRecipeStorage = module.getFirstFulfillableRecipe(ItemStackUtils::isEmpty, 1, false);
            if (((BuildingNetherWorker)this.building).isReadyForTrip()) {
                this.worker.getCitizenData().setIdleAtJob(true);
            }
            if (this.currentRecipeStorage == null && ((BuildingNetherWorker)this.building).shallClosePortalOnReturn() && (block = this.world.getBlockState(portal)).is(Blocks.NETHER_PORTAL)) {
                return AIWorkerState.NETHER_CLOSEPORTAL;
            }
            return this.getState();
        }
        if (!((BuildingNetherWorker)this.building).isReadyForTrip()) {
            this.worker.getCitizenData().setIdleAtJob(false);
            this.setDelay(120);
            return AIWorkerState.IDLE;
        }
        if (this.walkTo != null || !this.walkToBuilding()) {
            return this.getState();
        }
        if (!this.worker.getInventoryCitizen().hasSpace()) {
            return AIWorkerState.INVENTORY_FULL;
        }
        IAIState checkResult = this.checkForItems(this.currentRecipeStorage);
        if (checkResult == AIWorkerState.GET_RECIPE) {
            this.currentRecipeStorage = null;
            this.worker.getCitizenData().setIdleAtJob(true);
            this.setDelay(60);
            return AIWorkerState.IDLE;
        }
        if (checkResult != AIWorkerState.CRAFT) {
            return checkResult;
        }
        return AIWorkerState.NETHER_LEAVE;
    }

    protected IAIState leaveForNether() {
        if (!this.worker.getInventoryCitizen().hasSpace()) {
            return AIWorkerState.INVENTORY_FULL;
        }
        if (this.currentRecipeStorage == null) {
            ((JobNetherWorker)this.job).setInNether(false);
            this.worker.getCitizenData().setIdleAtJob(true);
            return AIWorkerState.IDLE;
        }
        if (this.world.getScoreboard().getObjective(OBJECTIVE_HUT_LEVEL) == null) {
            this.world.getScoreboard().addObjective(OBJECTIVE_HUT_LEVEL, ObjectiveCriteria.DUMMY, (Component)Component.literal((String)"Worker Building Level"), ObjectiveCriteria.RenderType.INTEGER, false, null);
        }
        if (this.world.getScoreboard().getObjective(OBJECTIVE_SECONDARY_SKILL) == null) {
            this.world.getScoreboard().addObjective(OBJECTIVE_SECONDARY_SKILL, ObjectiveCriteria.DUMMY, (Component)Component.literal((String)"Worker Secondary Skill Level"), ObjectiveCriteria.RenderType.INTEGER, false, null);
        }
        Objective hutLevelObjective = this.world.getScoreboard().getObjective(OBJECTIVE_HUT_LEVEL);
        Objective secondarySkillLevelObjective = this.world.getScoreboard().getObjective(OBJECTIVE_SECONDARY_SKILL);
        this.world.getScoreboard().getOrCreatePlayerScore((ScoreHolder)this.worker, hutLevelObjective).set(((BuildingNetherWorker)this.building).getBuildingLevel());
        this.world.getScoreboard().getOrCreatePlayerScore((ScoreHolder)this.worker, secondarySkillLevelObjective).set(this.getSecondarySkillLevel());
        ExpeditionLog expeditionLog = ((ExpeditionLogModule)((BuildingNetherWorker)this.building).getFirstModuleOccurance(ExpeditionLogModule.class)).getLog();
        expeditionLog.reset();
        expeditionLog.setStatus(ExpeditionLog.Status.STARTING);
        expeditionLog.setCitizen(this.worker);
        BlockPos portal = ((BuildingNetherWorker)this.building).getPortalLocation();
        if (portal != null && this.currentRecipeStorage != null) {
            BlockState block = this.world.getBlockState(portal);
            if (block.is(Blocks.NETHER_PORTAL)) {
                if (!this.walkToWorkPos(portal)) {
                    return this.getState();
                }
                this.goToVault();
                ((BuildingNetherWorker)this.building).recordTrip();
                ((JobNetherWorker)this.job).setInNether(true);
                expeditionLog.setStatus(ExpeditionLog.Status.IN_PROGRESS);
                this.logAllEquipment(expeditionLog, false);
                List<ItemStack> result = this.currentRecipeStorage.fullfillRecipeAndCopy(this.getLootContext(), (List<IItemHandler>)ImmutableList.of((Object)this.worker.getItemHandlerCitizen()), false);
                if (result != null) {
                    result = new ArrayList<ItemStack>(result);
                    Collections.shuffle(result, this.worker.getCitizenData().getRandom());
                    ((JobNetherWorker)this.job).addCraftedResultsList(result);
                }
                this.worker.getCitizenData().setIdleAtJob(false);
                return AIWorkerState.NETHER_AWAY;
            }
            return AIWorkerState.NETHER_OPENPORTAL;
        }
        this.worker.getCitizenData().setIdleAtJob(true);
        return AIWorkerState.IDLE;
    }

    protected IAIState stayInNether() {
        if (((BuildingNetherWorker)this.building).getVaultLocation() == null) {
            BlockPos portal = ((BuildingNetherWorker)this.building).getPortalLocation();
            if (portal != null && !this.walkToWorkPos(portal)) {
                return this.getState();
            }
            if (!this.worker.isInvisible()) {
                this.worker.setInvisible(true);
            }
        }
        ExpeditionLog expeditionLog = ((ExpeditionLogModule)((BuildingNetherWorker)this.building).getFirstModuleOccurance(ExpeditionLogModule.class)).getLog();
        if (!((JobNetherWorker)this.job).getCraftedResults().isEmpty()) {
            ItemStack currStack = ((JobNetherWorker)this.job).getCraftedResults().poll();
            if (currStack.getItem() instanceof ItemAdventureToken) {
                @Nullable AdventureData component = AdventureData.readFromItemStack(currStack);
                if (component != null) {
                    this.equipArmor(true);
                    this.worker.setItemSlot(EquipmentSlot.MAINHAND, this.findTool((EquipmentTypeEntry)ModEquipmentTypes.sword.get()));
                    DamageSource source = this.world.damageSources().source(DamageSourceKeys.NETHER);
                    EntityType<?> mobType = component.entityType();
                    LivingEntity mob = (LivingEntity)mobType.create((Level)this.world);
                    float mobHealth = mob.getHealth();
                    float incomingDamage = component.damage();
                    incomingDamage -= incomingDamage * ((float)this.getSecondarySkillLevel() * 0.005f);
                    int hit = 0;
                    while (mobHealth > 0.0f && !this.worker.isDeadOrDying()) {
                        this.worker.hurtTime = 0;
                        this.worker.invulnerableTime = 0;
                        float damageToDo = 3.0f;
                        boolean doDamage = this.worker.getRandom().nextBoolean();
                        boolean takeDamage = this.worker.getRandom().nextBoolean();
                        ItemStack sword = this.worker.getItemBySlot(EquipmentSlot.MAINHAND);
                        if (!sword.isEmpty()) {
                            Item item2 = sword.getItem();
                            if (item2 instanceof SwordItem) {
                                SwordItem swordItem = (SwordItem)item2;
                                damageToDo += (float)swordItem.getDamage(sword);
                            } else {
                                damageToDo = (float)((double)damageToDo + TinkersToolHelper.getDamage(sword));
                            }
                            damageToDo += EnchantmentHelper.modifyDamage((ServerLevel)((ServerLevel)this.worker.level()), (ItemStack)sword, (Entity)mob, (DamageSource)this.worker.level().damageSources().source(DamageSourceKeys.DEFAULT, (Entity)this.worker), (float)1.0f) / 2.5f;
                            if (doDamage) {
                                sword.hurtAndBreak(1, (ServerLevel)this.worker.level(), (LivingEntity)this.worker, item -> this.worker.setItemSlot(EquipmentSlot.MAINHAND, this.findTool((EquipmentTypeEntry)ModEquipmentTypes.sword.get())));
                            }
                        }
                        if (doDamage) {
                            mobHealth -= damageToDo;
                        }
                        if (takeDamage && !this.worker.hurt(source, incomingDamage)) {
                            incomingDamage = this.worker.calculateDamageAfterAbsorbs(source, incomingDamage);
                            this.worker.setHealth(this.worker.getHealth() - incomingDamage);
                        }
                        if (hit % 2 == 0) {
                            float healAmount = this.checkHeal(this.worker);
                            float saturationFactor = 0.25f;
                            if (healAmount > 0.0f) {
                                this.worker.heal(healAmount);
                                this.worker.getCitizenData().decreaseSaturation(healAmount * 0.25f);
                            }
                        } else if (this.worker.getCitizenData().getSaturation() < 10.0) {
                            this.attemptToEat();
                        }
                        ++hit;
                    }
                    expeditionLog.setCitizen(this.worker);
                    this.logAllEquipment(expeditionLog, true);
                    if (this.worker.isDeadOrDying()) {
                        expeditionLog.setKilled();
                        InventoryUtils.clearItemHandler(this.worker.getItemHandlerCitizen());
                        ((JobNetherWorker)this.job).getCraftedResults().clear();
                        ((JobNetherWorker)this.job).getProcessedResults().clear();
                        return AIWorkerState.IDLE;
                    }
                    LootParams context = this.getLootContext();
                    LootTable loot = this.world.getServer().reloadableRegistries().getLootTable(mob.getLootTable());
                    ObjectArrayList mobLoot = loot.getRandomItems(context);
                    ((JobNetherWorker)this.job).addProcessedResultsList((Collection<ItemStack>)mobLoot);
                    expeditionLog.addMob(mobType);
                    expeditionLog.addLoot((List<ItemStack>)mobLoot);
                    this.worker.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
                    this.equipArmor(false);
                    this.worker.getCitizenExperienceHandler().addExperience(CitizenItemUtils.applyMending(this.worker, component.xp()));
                }
            } else if (!currStack.isEmpty()) {
                int itemDelay = 0;
                Item mobType = currStack.getItem();
                if (mobType instanceof BlockItem) {
                    BlockItem bi = (BlockItem)mobType;
                    Block block = bi.getBlock();
                    ItemStack tool = this.findTool(block.defaultBlockState(), this.worker.blockPosition());
                    if (tool.getItem() instanceof TieredItem) {
                        this.worker.setItemSlot(EquipmentSlot.MAINHAND, tool);
                        for (int i = 0; i < currStack.getCount() && !tool.isEmpty(); ++i) {
                            LootParams context = this.getLootContext();
                            LootTable loot = this.world.getServer().reloadableRegistries().getLootTable(block.getLootTable());
                            ObjectArrayList mobLoot = loot.getRandomItems(context);
                            ((JobNetherWorker)this.job).addProcessedResultsList((Collection<ItemStack>)mobLoot);
                            expeditionLog.addLoot((List<ItemStack>)mobLoot);
                            tool.hurtAndBreak(1, (ServerLevel)this.worker.level(), (LivingEntity)this.worker, item -> {});
                            if (tool.isEmpty()) {
                                tool = this.findTool(block.defaultBlockState(), this.worker.blockPosition());
                                this.worker.setItemSlot(EquipmentSlot.MAINHAND, tool);
                            }
                            this.worker.getCitizenExperienceHandler().addExperience(CitizenItemUtils.applyMending(this.worker, this.xpOnDrop(block)));
                            itemDelay += 40;
                        }
                        this.worker.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
                        this.logAllEquipment(expeditionLog, false);
                    } else {
                        itemDelay = 40;
                    }
                } else {
                    ((JobNetherWorker)this.job).addProcessedResultsList((Collection<ItemStack>)ImmutableList.of((Object)currStack));
                    expeditionLog.addLoot(Collections.singletonList(currStack));
                    itemDelay = 40 * currStack.getCount();
                }
                this.setDelay(itemDelay);
            }
            return this.getState();
        }
        if (!((JobNetherWorker)this.job).getProcessedResults().isEmpty()) {
            if (!this.worker.isDeadOrDying()) {
                expeditionLog.setStatus(ExpeditionLog.Status.RETURNING_HOME);
                ItemStack item3 = ((JobNetherWorker)this.job).getProcessedResults().poll();
                if (InventoryUtils.addItemStackToItemHandler(this.worker.getItemHandlerCitizen(), item3)) {
                    this.worker.decreaseSaturationForContinuousAction();
                    this.worker.getCitizenExperienceHandler().addExperience(0.2);
                }
            } else {
                ((JobNetherWorker)this.job).getProcessedResults().clear();
            }
            return this.getState();
        }
        expeditionLog.setStatus(ExpeditionLog.Status.COMPLETED);
        return AIWorkerState.NETHER_RETURN;
    }

    private int xpOnDrop(Block block) {
        RandomSource rnd = this.worker.getRandom();
        if (block == Blocks.COAL_ORE) {
            return rnd.nextInt(0, 2);
        }
        if (block == Blocks.DIAMOND_ORE) {
            return rnd.nextInt(3, 7);
        }
        if (block == Blocks.EMERALD_ORE) {
            return rnd.nextInt(3, 7);
        }
        if (block == Blocks.LAPIS_ORE) {
            return rnd.nextInt(2, 5);
        }
        if (block == Blocks.NETHER_QUARTZ_ORE) {
            return rnd.nextInt(2, 5);
        }
        return block == Blocks.NETHER_GOLD_ORE ? rnd.nextInt(0, 1) : 0;
    }

    protected IAIState returnFromNether() {
        if (this.worker.isInvisible()) {
            this.returnFromVault(false);
            return this.getState();
        }
        if (((BuildingNetherWorker)this.building).shallClosePortalOnReturn() && this.world.getBlockState(((BuildingNetherWorker)this.building).getPortalLocation()).is(Blocks.NETHER_PORTAL)) {
            return AIWorkerState.NETHER_CLOSEPORTAL;
        }
        if (!this.walkToBuilding()) {
            return this.getState();
        }
        this.worker.getCitizenData().setIdleAtJob(true);
        ((JobNetherWorker)this.job).setInNether(false);
        this.currentRecipeStorage = null;
        return AIWorkerState.INVENTORY_FULL;
    }

    protected IAIState openPortal() {
        BlockPos portal = ((BuildingNetherWorker)this.building).getPortalLocation();
        if (portal != null && this.currentRecipeStorage != null) {
            if (!this.walkToWorkPos(portal)) {
                return this.getState();
            }
            BlockState block = this.world.getBlockState(portal);
            Optional ps = PortalShape.findPortalShape((LevelAccessor)this.world, (BlockPos)portal, p -> p.isValid(), (Direction.Axis)Direction.Axis.X);
            if (!ps.isPresent()) {
                return AIWorkerState.IDLE;
            }
            if (!block.is(Blocks.NETHER_PORTAL)) {
                this.useFlintAndSteel();
                ((PortalShape)ps.get()).createPortalBlocks();
                return AIWorkerState.NETHER_LEAVE;
            }
        }
        return AIWorkerState.START_WORKING;
    }

    protected IAIState closePortal() {
        BlockPos portal = ((BuildingNetherWorker)this.building).getPortalLocation();
        BlockState block = this.world.getBlockState(portal);
        if (block.is(Blocks.NETHER_PORTAL)) {
            if (!this.walkToWorkPos(portal)) {
                return this.getState();
            }
            this.useFlintAndSteel();
            this.world.setBlockAndUpdate(((BuildingNetherWorker)this.building).getPortalLocation(), Blocks.AIR.defaultBlockState());
        }
        if (((JobNetherWorker)this.job).isInNether()) {
            return AIWorkerState.NETHER_RETURN;
        }
        this.currentRecipeStorage = null;
        return AIWorkerState.INVENTORY_FULL;
    }

    private void useFlintAndSteel() {
        ItemStack tool = this.findTool((EquipmentTypeEntry)ModEquipmentTypes.flint_and_steel.get());
        tool.hurtAndBreak(1, this.world, (LivingEntity)this.worker, item -> {});
    }

    private ItemStack findItem(@NotNull Predicate<ItemStack> predicate) {
        int slotOfStack = InventoryUtils.findFirstSlotInItemHandlerNotEmptyWith(this.worker.getItemHandlerCitizen(), predicate);
        return slotOfStack < 0 ? ItemStack.EMPTY : this.worker.getInventoryCitizen().getStackInSlot(slotOfStack);
    }

    private ItemStack findTool(@NotNull EquipmentTypeEntry tool) {
        return this.findItem(stack -> ItemStackUtils.hasEquipmentLevel(stack, tool, 0, ((BuildingNetherWorker)this.building).getMaxEquipmentLevel()));
    }

    private ItemStack findTool(@NotNull BlockState target, BlockPos pos) {
        int slotOfStack = this.getMostEfficientTool(target, pos);
        return slotOfStack < 0 ? ItemStack.EMPTY : this.worker.getInventoryCitizen().getStackInSlot(slotOfStack);
    }

    private void setEquipSlot(EquipmentSlot equipSlot, boolean equip) {
        if (equip) {
            for (List<GuardGear> itemList : this.itemsNeeded) {
                for (GuardGear item : itemList) {
                    int toBeEquipped;
                    if (!item.getType().equals((Object)equipSlot) || ((BuildingNetherWorker)this.building).getBuildingLevel() < item.getMinBuildingLevelRequired() || ((BuildingNetherWorker)this.building).getBuildingLevel() > item.getMaxBuildingLevelRequired() || item.test(this.worker.getInventoryCitizen().getArmorInSlot(item.getType())) || (toBeEquipped = InventoryUtils.findFirstSlotInItemHandlerNotEmptyWith(this.worker.getItemHandlerCitizen(), item)) <= -1) continue;
                    ItemStack stack = this.worker.getInventoryCitizen().getStackInSlot(toBeEquipped);
                    this.worker.getInventoryCitizen().transferArmorToSlot(item.getType(), toBeEquipped);
                    this.virtualEquipmentSlots.put(item.getType(), stack);
                }
            }
        } else {
            this.worker.getInventoryCitizen().moveArmorToInventory(equipSlot);
            this.virtualEquipmentSlots.put(equipSlot, ItemStack.EMPTY);
        }
    }

    private void equipArmor(boolean equip) {
        this.setEquipSlot(EquipmentSlot.HEAD, equip);
        this.setEquipSlot(EquipmentSlot.CHEST, equip);
        this.setEquipSlot(EquipmentSlot.LEGS, equip);
        this.setEquipSlot(EquipmentSlot.FEET, equip);
    }

    private void logAllEquipment(@NotNull ExpeditionLog expeditionLog, boolean alreadyEquipped) {
        if (!alreadyEquipped) {
            this.equipArmor(true);
        }
        StackList edible = new StackList(this.getEdiblesList(), "Edible Food", 1);
        ArrayList<ItemStack> equipment = new ArrayList<ItemStack>();
        equipment.add(this.findTool((EquipmentTypeEntry)ModEquipmentTypes.sword.get()));
        equipment.add(this.worker.getInventoryCitizen().getArmorInSlot(EquipmentSlot.HEAD));
        equipment.add(this.worker.getInventoryCitizen().getArmorInSlot(EquipmentSlot.CHEST));
        equipment.add(this.worker.getInventoryCitizen().getArmorInSlot(EquipmentSlot.LEGS));
        equipment.add(this.worker.getInventoryCitizen().getArmorInSlot(EquipmentSlot.FEET));
        equipment.add(this.findTool((EquipmentTypeEntry)ModEquipmentTypes.pickaxe.get()));
        equipment.add(this.findTool((EquipmentTypeEntry)ModEquipmentTypes.axe.get()));
        equipment.add(this.findTool((EquipmentTypeEntry)ModEquipmentTypes.shovel.get()));
        equipment.add(this.findItem(edible::matches));
        expeditionLog.setEquipment(equipment);
        if (!alreadyEquipped) {
            this.equipArmor(false);
        }
    }

    private List<ItemStack> getEdiblesList() {
        Set<ItemStorage> allowedItems = ((BuildingNetherWorker)this.building).getModule(BuildingModules.NETHERMINER_MENU).getMenu();
        this.netherEdible.removeIf(item -> allowedItems.contains(new ItemStorage((ItemStack)item)));
        return this.netherEdible;
    }

    protected void attemptToEat() {
        StackList edible = new StackList(this.getEdiblesList(), "Edible Food", 1);
        int slot = InventoryUtils.findFirstSlotInProviderNotEmptyWith((IItemHandlerCapProvider)this.worker, edible::matches);
        ICitizenData citizenData = this.worker.getCitizenData();
        if (slot > -1) {
            ItemStack stack = this.worker.getInventoryCitizen().getStackInSlot(slot);
            ItemStackUtils.consumeFood(stack, this.worker, null);
        }
    }

    protected void checkAndRequestArmor() {
        for (List<GuardGear> itemList : this.itemsNeeded) {
            for (GuardGear item : itemList) {
                int slot;
                if (((BuildingNetherWorker)this.building).getBuildingLevel() < item.getMinBuildingLevelRequired() || ((BuildingNetherWorker)this.building).getBuildingLevel() > item.getMaxBuildingLevelRequired()) continue;
                int bestSlot = -1;
                int bestLevel = -1;
                IItemHandler bestHandler = null;
                if (this.virtualEquipmentSlots.containsKey(item.getType()) && !ItemStackUtils.isEmpty(this.virtualEquipmentSlots.get(item.getType()))) {
                    bestLevel = item.getItemNeeded().getMiningLevel(this.virtualEquipmentSlots.get(item.getType()));
                } else {
                    ItemStack invItem = this.findItem(item::test);
                    if (!invItem.isEmpty()) {
                        if (!this.virtualEquipmentSlots.containsKey(item.getType()) || ItemStackUtils.isEmpty(this.virtualEquipmentSlots.get(item.getType()))) {
                            this.virtualEquipmentSlots.put(item.getType(), invItem);
                            bestLevel = item.getItemNeeded().getMiningLevel(invItem);
                        }
                    } else {
                        this.virtualEquipmentSlots.put(item.getType(), ItemStack.EMPTY);
                    }
                }
                Map<IItemHandler, List<Integer>> items = InventoryUtils.findAllSlotsInProviderWith(this.building, item::test);
                if (items.isEmpty()) {
                    if (ItemStackUtils.isEmpty(this.virtualEquipmentSlots.get(item.getType()))) {
                        this.checkForToolOrWeaponAsync(item.getItemNeeded(), item.getMinArmorLevel(), item.getMaxArmorLevel());
                    }
                } else {
                    for (Map.Entry<IItemHandler, List<Integer>> entry : items.entrySet()) {
                        for (Integer slot2 : entry.getValue()) {
                            int currentLevel;
                            ItemStack stack2 = entry.getKey().getStackInSlot(slot2.intValue());
                            if (ItemStackUtils.isEmpty(stack2) || (currentLevel = item.getItemNeeded().getMiningLevel(stack2)) <= bestLevel) continue;
                            bestLevel = currentLevel;
                            bestSlot = slot2;
                            bestHandler = entry.getKey();
                        }
                    }
                }
                if (bestHandler == null) continue;
                if (!ItemStackUtils.isEmpty(this.virtualEquipmentSlots.get(item.getType())) && (slot = InventoryUtils.findFirstSlotInItemHandlerNotEmptyWith((IItemHandler)this.worker.getInventoryCitizen(), stack -> stack == this.virtualEquipmentSlots.get(item.getType()))) > -1) {
                    InventoryUtils.transferItemStackIntoNextFreeSlotInProvider((IItemHandler)this.worker.getInventoryCitizen(), slot, this.building);
                }
                this.virtualEquipmentSlots.put(item.getType(), bestHandler.getStackInSlot(bestSlot));
                InventoryUtils.transferItemStackIntoNextFreeSlotInItemHandler(bestHandler, bestSlot, (IItemHandler)this.worker.getInventoryCitizen());
            }
        }
    }

    protected IAIState checkAndRequestFood() {
        if (InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), stack -> ((BuildingNetherWorker)this.building).getModule(BuildingModules.NETHERMINER_MENU).getMenu().contains(new ItemStorage((ItemStack)stack))) >= 16) {
            return this.getState();
        }
        if (InventoryUtils.hasBuildingEnoughElseCount((IBuilding)this.building, stack -> ((BuildingNetherWorker)this.building).getModule(BuildingModules.NETHERMINER_MENU).getMenu().contains(new ItemStorage((ItemStack)stack)), 1) >= 1) {
            this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(stack -> ((BuildingNetherWorker)this.building).getModule(BuildingModules.NETHERMINER_MENU).getMenu().contains(new ItemStorage((ItemStack)stack)), 16);
            return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
        }
        return this.getState();
    }

    private float checkHeal(AbstractEntityCitizen citizen) {
        ICitizenData citizenData = citizen.getCitizenData();
        double healAmount = 0.0;
        if (citizen.getHealth() < citizen.getMaxHealth()) {
            double limitDecrease = citizen.getCitizenColonyHandler().getColonyOrRegister().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.SATLIMIT);
            if (citizenData.getSaturation() >= 20.0 + limitDecrease) {
                healAmount = 2.0 * (1.0 + citizen.getCitizenColonyHandler().getColonyOrRegister().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.REGENERATION));
            } else {
                if (citizenData.getSaturation() < 6.0) {
                    return (float)healAmount;
                }
                healAmount = 1.0 * (1.0 + citizen.getCitizenColonyHandler().getColonyOrRegister().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.REGENERATION));
            }
            citizen.heal((float)healAmount);
        }
        return (float)healAmount;
    }
}

