/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.workers.guard.training;

import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.DamageSourceKeys;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingCombatAcademy;
import com.minecolonies.core.colony.jobs.JobCombatTraining;
import com.minecolonies.core.entity.ai.workers.guard.training.AbstractEntityAITraining;
import com.minecolonies.core.entity.pathfinding.navigation.EntityNavigationUtils;
import com.minecolonies.core.util.WorkerUtil;
import com.minecolonies.core.util.citizenutils.CitizenItemUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Items;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class EntityAICombatTraining
extends AbstractEntityAITraining<JobCombatTraining, BuildingCombatAcademy> {
    private static final int ACTIONS_PER_BUILDING_LEVEL = 5;
    private static final double XP_BASE_RATE = 2.0;
    private static final int PARTNER_TRAINING_CHANCE = 25;
    private static final int TRAININGS_DELAY = 60;
    private static final int MIN_DISTANCE_TO_TRAIN = 5;
    private BlockPos currentCombatTarget;
    private AbstractEntityCitizen trainingPartner;
    private int targetCounter;

    public EntityAICombatTraining(@NotNull JobCombatTraining job) {
        super(job);
        super.registerTargets(new AITarget<Object>(AIWorkerState.COMBAT_TRAINING, this::decideOnTrainingType, 20), new AITarget<Object>(AIWorkerState.FIND_TRAINING_PARTNER, this::findTrainingPartner, 20), new AITarget<Object>(AIWorkerState.KNIGHT_TRAIN_WITH_PARTNER, this::trainWithPartner, 20), new AITarget<Object>(AIWorkerState.FIND_DUMMY_PARTNER, this::findDummyPartner, 20), new AITarget<Object>(AIWorkerState.KNIGHT_ATTACK_DUMMY, this::attackDummy, 20), new AITarget<Object>(AIWorkerState.KNIGHT_ATTACK_PROTECT, this::attack, 60));
    }

    private IAIState decideOnTrainingType() {
        if (((BuildingCombatAcademy)this.building).hasCombatPartner(this.worker) || this.worker.getRandom().nextInt(100) < 25) {
            return AIWorkerState.FIND_TRAINING_PARTNER;
        }
        return AIWorkerState.FIND_DUMMY_PARTNER;
    }

    @Override
    public IAIState decide() {
        if (((BuildingCombatAcademy)this.building).hasCombatPartner(this.worker)) {
            return AIWorkerState.KNIGHT_TRAIN_WITH_PARTNER;
        }
        return super.decide();
    }

    private IAIState findTrainingPartner() {
        BuildingCombatAcademy academy = (BuildingCombatAcademy)this.building;
        this.trainingPartner = academy.hasCombatPartner(this.worker) ? academy.getCombatPartner(this.worker) : academy.getRandomCombatPartner(this.worker);
        if (this.trainingPartner == null) {
            return AIWorkerState.COMBAT_TRAINING;
        }
        return AIWorkerState.KNIGHT_TRAIN_WITH_PARTNER;
    }

    private IAIState trainWithPartner() {
        if (this.trainingPartner == null || !this.getModuleForJob().getAssignedCitizen().contains(this.trainingPartner.getCitizenData())) {
            this.trainingPartner = null;
            return AIWorkerState.COMBAT_TRAINING;
        }
        if (BlockPosUtil.getDistance2D(this.worker.blockPosition(), this.trainingPartner.blockPosition()) > 5L && !this.walkToWorkPos(this.trainingPartner.blockPosition())) {
            return AIWorkerState.KNIGHT_TRAIN_WITH_PARTNER;
        }
        return AIWorkerState.KNIGHT_ATTACK_PROTECT;
    }

    private IAIState attack() {
        if (this.trainingPartner == null) {
            return AIWorkerState.START_WORKING;
        }
        if (BlockPosUtil.getDistance2D(this.worker.blockPosition(), this.trainingPartner.blockPosition()) > 5L) {
            this.currentPathingTarget = this.trainingPartner.blockPosition();
            this.stateAfterPathing = AIWorkerState.KNIGHT_TRAIN_WITH_PARTNER;
            return AIWorkerState.GO_TO_TARGET;
        }
        if (this.currentAttackDelay <= 0) {
            this.worker.getCitizenExperienceHandler().addExperience(2.0);
            this.worker.decreaseSaturationForAction();
            this.worker.lookAt((Entity)this.trainingPartner, 180.0f, 180.0f);
            WorkerUtil.faceBlock(this.trainingPartner.blockPosition().above(), this.worker);
            this.worker.stopUsingItem();
            if (this.worker.getRandom().nextBoolean()) {
                int shieldSlot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)this.getInventory(), Items.SHIELD);
                if (shieldSlot != -1) {
                    this.worker.playSound(SoundEvents.SHIELD_BLOCK, 1.0f, (float)SoundUtils.getRandomPitch(this.worker.getRandom()));
                    CitizenItemUtils.setHeldItem(this.worker, InteractionHand.OFF_HAND, shieldSlot);
                    this.worker.startUsingItem(InteractionHand.OFF_HAND);
                    this.worker.getLookControl().setLookAt((Entity)this.trainingPartner, 180.0f, 180.0f);
                }
            } else {
                this.worker.swing(InteractionHand.MAIN_HAND);
                this.worker.playSound(SoundEvents.PLAYER_ATTACK_SWEEP, 1.0f, (float)SoundUtils.getRandomPitch(this.worker.getRandom()));
                this.trainingPartner.hurt(this.world.damageSources().source(DamageSourceKeys.TRAINING, (Entity)this.worker), 0.0f);
                CitizenItemUtils.damageItemInHand(this.worker, InteractionHand.MAIN_HAND, 1);
            }
            EntityNavigationUtils.walkAwayFrom(this.worker, this.trainingPartner.blockPosition(), 4, 1.0);
            ++this.targetCounter;
            if (this.targetCounter > ((BuildingCombatAcademy)this.building).getBuildingLevel() * 5) {
                ((BuildingCombatAcademy)this.building).resetPartner(this.worker);
                this.targetCounter = 0;
                return AIWorkerState.START_WORKING;
            }
        } else {
            this.reduceAttackDelay();
            return AIWorkerState.KNIGHT_ATTACK_PROTECT;
        }
        this.currentAttackDelay = 60;
        return AIWorkerState.KNIGHT_ATTACK_PROTECT;
    }

    private IAIState findDummyPartner() {
        BuildingCombatAcademy academy = (BuildingCombatAcademy)this.building;
        if (this.targetCounter >= academy.getBuildingLevel() * 5) {
            this.worker.stopUsingItem();
            this.targetCounter = 0;
            return AIWorkerState.DECIDE;
        }
        if (((BuildingCombatAcademy)this.building).hasCombatPartner(this.worker)) {
            return AIWorkerState.KNIGHT_TRAIN_WITH_PARTNER;
        }
        BlockPos targetPos = academy.getRandomCombatTarget(this.worker.getRandom());
        if (targetPos == null) {
            this.worker.stopUsingItem();
            return AIWorkerState.DECIDE;
        }
        this.currentCombatTarget = targetPos;
        ++this.targetCounter;
        this.currentPathingTarget = targetPos;
        this.stateAfterPathing = AIWorkerState.KNIGHT_ATTACK_DUMMY;
        return AIWorkerState.GO_TO_TARGET;
    }

    private IAIState attackDummy() {
        if (this.currentCombatTarget == null) {
            return AIWorkerState.START_WORKING;
        }
        if (this.currentAttackDelay <= 0) {
            this.worker.getCitizenExperienceHandler().addExperience(2.0);
            this.worker.decreaseSaturationForAction();
            WorkerUtil.faceBlock(this.currentCombatTarget, this.worker);
            this.worker.stopUsingItem();
            if (this.worker.getRandom().nextBoolean()) {
                int shieldSlot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)this.getInventory(), Items.SHIELD);
                if (shieldSlot != -1) {
                    this.worker.playSound(SoundEvents.SHIELD_BLOCK, 1.0f, (float)SoundUtils.getRandomPitch(this.worker.getRandom()));
                    CitizenItemUtils.setHeldItem(this.worker, InteractionHand.OFF_HAND, shieldSlot);
                    this.worker.startUsingItem(InteractionHand.OFF_HAND);
                }
            } else {
                this.worker.swing(InteractionHand.MAIN_HAND);
                this.worker.playSound(SoundEvents.PLAYER_ATTACK_SWEEP, 1.0f, (float)SoundUtils.getRandomPitch(this.worker.getRandom()));
                CitizenItemUtils.damageItemInHand(this.worker, InteractionHand.MAIN_HAND, 1);
            }
        } else {
            this.reduceAttackDelay();
            return AIWorkerState.KNIGHT_ATTACK_DUMMY;
        }
        this.currentAttackDelay = 60;
        return AIWorkerState.FIND_DUMMY_PARTNER;
    }

    @Override
    protected boolean isSetup() {
        if (this.checkForToolOrWeapon((EquipmentTypeEntry)ModEquipmentTypes.sword.get())) {
            return false;
        }
        if (this.checkForToolOrWeapon((EquipmentTypeEntry)ModEquipmentTypes.shield.get())) {
            return false;
        }
        int weaponSlot = InventoryUtils.getFirstSlotOfItemHandlerContainingEquipment((IItemHandler)this.getInventory(), (EquipmentTypeEntry)ModEquipmentTypes.sword.get(), 0, ((BuildingCombatAcademy)this.building).getMaxEquipmentLevel());
        if (weaponSlot != -1) {
            CitizenItemUtils.setHeldItem(this.worker, InteractionHand.MAIN_HAND, weaponSlot);
        }
        return true;
    }

    @Override
    public Class<BuildingCombatAcademy> getExpectedBuildingClass() {
        return BuildingCombatAcademy.class;
    }
}

