/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.compatibility.jei.transfer;

import com.minecolonies.api.inventory.container.ContainerCraftingFurnace;
import com.minecolonies.core.network.messages.server.TransferRecipeCraftingTeachingMessage;
import java.util.HashMap;
import java.util.Optional;
import javax.annotation.Nullable;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import org.jetbrains.annotations.NotNull;

public class PrivateSmeltingTeachingTransferHandler
implements IRecipeTransferHandler<ContainerCraftingFurnace, RecipeHolder<SmeltingRecipe>> {
    private final IRecipeTransferHandlerHelper handlerHelper;

    public PrivateSmeltingTeachingTransferHandler(@NotNull IRecipeTransferHandlerHelper handlerHelper) {
        this.handlerHelper = handlerHelper;
    }

    @NotNull
    public Optional<MenuType<ContainerCraftingFurnace>> getMenuType() {
        return Optional.empty();
    }

    @NotNull
    public RecipeType<RecipeHolder<SmeltingRecipe>> getRecipeType() {
        return RecipeTypes.SMELTING;
    }

    @NotNull
    public Class<ContainerCraftingFurnace> getContainerClass() {
        return ContainerCraftingFurnace.class;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(@NotNull ContainerCraftingFurnace craftingGUIBuilding, @NotNull RecipeHolder<SmeltingRecipe> recipe, @NotNull IRecipeSlotsView recipeSlots, @NotNull Player player, boolean maxTransfer, boolean doTransfer) {
        ItemStack input = recipeSlots.getSlotViews(RecipeIngredientRole.INPUT).stream().flatMap(slot -> slot.getDisplayedIngredient((IIngredientType)VanillaTypes.ITEM_STACK).stream()).findFirst().orElse(ItemStack.EMPTY);
        if (!input.isEmpty() && doTransfer) {
            craftingGUIBuilding.setFurnaceInput(input);
            HashMap<Integer, ItemStack> guiIngredients = new HashMap<Integer, ItemStack>();
            guiIngredients.put(0, input);
            TransferRecipeCraftingTeachingMessage message = new TransferRecipeCraftingTeachingMessage(guiIngredients, false);
            message.sendToServer();
        }
        return null;
    }
}

