/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.compatibility.jei;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.ldtteam.blockui.UiRenderMacros;
import com.ldtteam.common.fakelevel.SingleBlockFakeLevel;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.crafting.registry.CraftingType;
import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.util.Log;
import com.minecolonies.core.colony.CitizenData;
import com.minecolonies.core.colony.crafting.LootTableAnalyzer;
import com.minecolonies.core.entity.citizen.EntityCitizen;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotRichTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.ITextWidget;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.AbstractRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JobBasedRecipeCategory<T>
extends AbstractRecipeCategory<T> {
    private static final Map<EquipmentTypeEntry, List<ItemStack>> TOOL_CACHE = new HashMap<EquipmentTypeEntry, List<ItemStack>>();
    protected static final ResourceLocation TEXTURE = new ResourceLocation("minecolonies", "textures/gui/jei_recipe.png");
    @NotNull
    protected final IJob<?> job;
    @NotNull
    private final ItemStack catalyst;
    @NotNull
    private final IDrawableStatic background;
    @NotNull
    protected final IDrawableStatic slot;
    @NotNull
    protected final IDrawableStatic chanceSlot;
    @NotNull
    private final List<FormattedText> description;
    @NotNull
    private final LoadingCache<T, List<InfoBlock>> infoBlocksCache;
    private static final Cache<IJob<?>, EntityCitizen> citizenCache = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofMinutes(2L)).build();
    protected static final int WIDTH = 167;
    protected static final int HEIGHT = 120;
    protected static final int CITIZEN_X = 2;
    protected static final int CITIZEN_Y = 46;
    protected static final int CITIZEN_W = 47;
    protected static final int CITIZEN_H = 71;

    protected JobBasedRecipeCategory(@NotNull IJob<?> job, @NotNull RecipeType<T> type, @NotNull ItemStack icon, @NotNull IGuiHelper guiHelper) {
        super(type, JobBasedRecipeCategory.getTitleAsTextComponent(job), guiHelper.createDrawableItemStack(icon), 167, 120);
        this.job = job;
        this.catalyst = icon;
        this.background = guiHelper.createDrawable(TEXTURE, 0, 0, 167, 120);
        this.slot = guiHelper.getSlotDrawable();
        this.chanceSlot = guiHelper.createDrawable(TEXTURE, 0, 121, 18, 18);
        this.description = JobBasedRecipeCategory.translateDescription("com.minecolonies.coremod.jei." + this.job.getJobRegistryEntry().getKey().getPath());
        this.infoBlocksCache = CacheBuilder.newBuilder().maximumSize(6L).build(new CacheLoader<T, List<InfoBlock>>(){

            @NotNull
            public List<InfoBlock> load(@NotNull T key) {
                return JobBasedRecipeCategory.this.calculateInfoBlocks(key);
            }
        });
    }

    @NotNull
    public ItemStack getCatalyst() {
        return this.catalyst;
    }

    @NotNull
    protected static ItemStack getCatalyst(@NotNull BuildingEntry building) {
        return new ItemStack(building.getBuildingBlock());
    }

    @NotNull
    public IJob<?> getJob() {
        return this.job;
    }

    @NotNull
    private static Component getTitleAsTextComponent(IJob<?> job) {
        return Component.translatableEscape((String)job.getJobRegistryEntry().getTranslationKey(), (Object[])new Object[0]);
    }

    public List<T> findRecipes(@NotNull Map<CraftingType, List<IGenericRecipe>> vanilla, @NotNull List<Animal> animals, @NotNull Level world) {
        return Collections.emptyList();
    }

    protected void addToolSlot(@NotNull IRecipeLayoutBuilder builder, @NotNull EquipmentTypeEntry requiredTool, int x, int y, boolean withBackground) {
        IRecipeSlotBuilder slot = builder.addSlot(RecipeIngredientRole.CATALYST, x, y).setSlotName("tool");
        if (requiredTool != ModEquipmentTypes.none.get()) {
            List<ItemStack> tools;
            if (withBackground) {
                slot.setStandardSlotBackground();
            }
            if ((tools = TOOL_CACHE.get(requiredTool)) == null) {
                tools = MinecoloniesAPIProxy.getInstance().getColonyManager().getCompatibilityManager().getListOfAllItems().stream().filter(requiredTool::checkIsEquipment).sorted(Comparator.comparing(requiredTool::getMiningLevel)).toList();
                TOOL_CACHE.put(requiredTool, tools);
            }
            slot.addItemStacks(tools);
        }
    }

    public void draw(@NotNull T recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics stack, double mouseX, double mouseY) {
        this.background.draw(stack);
        float scale = 29.583332f;
        int citizen_cx = 25;
        int citizen_cy = 81;
        int citizen_by = 117;
        int offsetY = 4;
        EntityCitizen citizen = JobBasedRecipeCategory.createCitizenWithJob(this.job);
        if (citizen != null) {
            float headYaw = (float)Math.atan((25.0 - mouseX) / 40.0) * 40.0f;
            float yaw = (float)Math.atan((25.0 - mouseX) / 40.0) * 20.0f;
            float pitch = (float)Math.atan((77.0 - mouseY) / 40.0) * 20.0f;
            Lighting.setupForFlatItems();
            UiRenderMacros.drawEntity((PoseStack)stack.pose(), (int)25, (int)113, (double)29.583332061767578, (float)headYaw, (float)yaw, (float)pitch, (Entity)citizen);
            Lighting.setupFor3DItems();
        }
    }

    public void createRecipeExtras(@NotNull IRecipeExtrasBuilder builder, @NotNull T recipe, @NotNull IFocusGroup focuses) {
        builder.addText(this.description, this.getWidth(), 44).setColor(ChatFormatting.BLACK.getColor().intValue());
        for (InfoBlock block : (List)this.infoBlocksCache.getUnchecked(recipe)) {
            ((ITextWidget)builder.addText((FormattedText)Component.literal((String)block.text), block.bounds.getWidth(), block.bounds.getHeight()).setPosition(block.bounds.getX(), block.bounds.getY())).setColor(ChatFormatting.YELLOW.getColor().intValue()).setShadow(true);
        }
    }

    public void getTooltip(@NotNull ITooltipBuilder tooltip, @NotNull T recipe, @NotNull IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        for (InfoBlock block : (List)this.infoBlocksCache.getUnchecked(recipe)) {
            if (block.tip == null || !block.bounds.contains((int)mouseX, (int)mouseY)) continue;
            tooltip.add((FormattedText)Component.literal((String)block.tip));
        }
    }

    @NotNull
    private List<InfoBlock> calculateInfoBlocks(@NotNull T recipe) {
        List<Component> lines = this.generateInfoBlocks(recipe);
        Minecraft mc = Minecraft.getInstance();
        ArrayList<InfoBlock> result = new ArrayList<InfoBlock>();
        int y = 46;
        for (Component line : lines) {
            TranslatableContents contents;
            String key;
            String text = line.getString();
            int width = (int)mc.font.getSplitter().stringWidth(text);
            Objects.requireNonNull(mc.font);
            int height = 9;
            int x = 167 - width;
            String tip = null;
            ComponentContents componentContents = line.getContents();
            if (componentContents instanceof TranslatableContents && I18n.exists((String)(key = (contents = (TranslatableContents)componentContents).getKey() + ".tip"))) {
                tip = Component.translatableEscape((String)key, (Object[])contents.getArgs()).getString();
            }
            result.add(new InfoBlock(text, tip, new Rect2i(x, y, width, height)));
            y += height + 2;
        }
        return result;
    }

    @NotNull
    protected abstract List<Component> generateInfoBlocks(@NotNull T var1);

    @Nullable
    private static EntityCitizen createCitizenWithJob(@NotNull IJob<?> job) {
        try {
            return (EntityCitizen)citizenCache.get(job, () -> {
                SingleBlockFakeLevel level = new SingleBlockFakeLevel((Level)Minecraft.getInstance().level);
                EntityCitizen citizen = new EntityCitizen(ModEntities.CITIZEN, (Level)level);
                citizen.setFemale(citizen.getRandom().nextBoolean());
                citizen.setTextureId(citizen.getRandom().nextInt(255));
                citizen.getEntityData().set(EntityCitizen.DATA_TEXTURE_SUFFIX, (Object)CitizenData.SUFFIXES.get(citizen.getRandom().nextInt(CitizenData.SUFFIXES.size())));
                citizen.setModelId(job.getModel());
                return citizen;
            });
        }
        catch (Throwable e) {
            Log.getLogger().error("Error creating citizen for {}", (Object)job.getJobRegistryEntry().getTranslationKey(), (Object)e);
            return null;
        }
    }

    @NotNull
    private static List<FormattedText> translateDescription(String ... keys) {
        return Arrays.stream(keys).map(Component::translatable).collect(Collectors.toList());
    }

    private static class InfoBlock {
        public final String text;
        public final String tip;
        public final Rect2i bounds;

        public InfoBlock(String text, String tip, Rect2i bounds) {
            this.text = text;
            this.tip = tip;
            this.bounds = bounds;
        }
    }

    protected static class LootTableTooltipCallback
    implements IRecipeSlotRichTooltipCallback {
        private final LootTableAnalyzer.LootDrop drop;
        private final ResourceKey<LootTable> id;

        public LootTableTooltipCallback(LootTableAnalyzer.LootDrop drop, ResourceKey<LootTable> id) {
            this.drop = drop;
            this.id = id;
        }

        public void onRichTooltip(@NotNull IRecipeSlotView recipeSlotView, @NotNull ITooltipBuilder tooltip) {
            boolean showAdvanced;
            String key = "com.minecolonies.coremod.jei." + (this.drop.getQuality() < 0.0f ? "chancenegskill.tip" : (this.drop.getQuality() > 0.0f ? "chanceskill.tip" : "chance.tip"));
            float probability = this.drop.getProbability() * 100.0f;
            if (probability >= 1.0f) {
                tooltip.add((FormattedText)Component.translatableEscape((String)key, (Object[])new Object[]{Math.round(probability)}));
            } else {
                tooltip.add((FormattedText)Component.translatableEscape((String)key, (Object[])new Object[]{Float.valueOf((float)Math.round(probability * 100.0f) / 100.0f)}));
            }
            if (this.drop.getConditional()) {
                tooltip.add((FormattedText)Component.translatableEscape((String)"com.minecolonies.coremod.jei.conditions.tip", (Object[])new Object[0]));
            }
            boolean bl = showAdvanced = Minecraft.getInstance().options.advancedItemTooltips || Screen.hasShiftDown();
            if (showAdvanced) {
                MutableComponent recipeId = Component.translatableEscape((String)"com.minecolonies.coremod.jei.loottableid", (Object[])new Object[]{this.id.location().toString()});
                tooltip.add((FormattedText)recipeId.withStyle(ChatFormatting.DARK_GRAY));
            }
        }
    }

    protected static class RecipeIdTooltipCallback
    implements IRecipeSlotRichTooltipCallback {
        private final ResourceLocation id;
        private final IModIdHelper modIdHelper;

        public RecipeIdTooltipCallback(ResourceLocation id, IModIdHelper modIdHelper) {
            this.id = id;
            this.modIdHelper = modIdHelper;
        }

        public void onRichTooltip(@NotNull IRecipeSlotView recipeSlotView, @NotNull ITooltipBuilder tooltip) {
            boolean showAdvanced;
            String ingredientModId;
            String recipeModId;
            ItemStack ingredient = recipeSlotView.getDisplayedIngredient().flatMap(d -> d.getIngredient((IIngredientType)VanillaTypes.ITEM_STACK)).orElse(ItemStack.EMPTY);
            if (this.modIdHelper.isDisplayingModNameEnabled() && !(recipeModId = this.id.getNamespace()).equals(ingredientModId = ingredient.getItem().getCreatorModId(ingredient))) {
                String modName = this.modIdHelper.getFormattedModNameForModId(recipeModId);
                MutableComponent recipeBy = Component.translatableEscape((String)"jei.tooltip.recipe.by", (Object[])new Object[]{modName});
                tooltip.add((FormattedText)recipeBy.withStyle(ChatFormatting.GRAY));
            }
            boolean bl = showAdvanced = Minecraft.getInstance().options.advancedItemTooltips || Screen.hasShiftDown();
            if (showAdvanced) {
                MutableComponent recipeId = Component.translatableEscape((String)"jei.tooltip.recipe.id", (Object[])new Object[]{this.id.toString()});
                tooltip.add((FormattedText)recipeId.withStyle(ChatFormatting.DARK_GRAY));
            }
        }
    }
}

