/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.commands.generalcommands;

import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.commands.commandTypes.IMCCommand;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import it.unimi.dsi.fastutil.longs.LongBidirectionalIterator;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class CommandUnloadForcedChunks
implements IMCCommand {
    @Override
    public int onExecute(CommandContext<CommandSourceStack> context) {
        Player player;
        Level level;
        Entity sender = ((CommandSourceStack)context.getSource()).getEntity();
        if (sender instanceof Player && (level = (player = (Player)sender).level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Level world = sender.level();
            LongBidirectionalIterator longBidirectionalIterator = serverLevel.getChunkSource().chunkMap.visibleChunkMap.keySet().iterator();
            while (longBidirectionalIterator.hasNext()) {
                long chunk = (Long)longBidirectionalIterator.next();
                serverLevel.setChunkForced(ChunkPos.getX((long)chunk), ChunkPos.getZ((long)chunk), false);
            }
            MessageUtils.format((Component)Component.literal((String)"Successfully removed forceload flag!")).sendTo(player);
            return 1;
        }
        return 0;
    }

    @Override
    public boolean checkPreCondition(CommandContext<CommandSourceStack> context) {
        Entity sender = ((CommandSourceStack)context.getSource()).getEntity();
        return sender instanceof Player && ((Player)sender).isCreative();
    }

    @Override
    public String getName() {
        return "forceunloadchunks";
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).executes(this::checkPreConditionAndExecute);
    }
}

