/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.commands.colonycommands;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.configuration.ServerConfiguration;
import com.minecolonies.core.MineColonies;
import com.minecolonies.core.commands.commandTypes.IMCColonyOfficerCommand;
import com.minecolonies.core.commands.commandTypes.IMCCommand;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public class CommandColonyInfo
implements IMCColonyOfficerCommand {
    public static final String ID_TEXT = "ID: ";
    public static final String NAME_TEXT = "Name: ";
    public static final String MAYOR_TEXT = "Mayor: ";
    private static final String COORDINATES_TEXT = "Coordinates: ";
    private static final String COORDINATES_XYZ = "x=%s y=%s z=%s";
    private static final String CITIZENS = "Citizens: ";
    private static final String LAST_CONTACT_TEXT = "Last contact with Owner or Officer: %d hours ago!";
    private static final String IS_DELETABLE = "If true this colony cannot be deleted: ";
    private static final String CANNOT_BE_RAIDED = "This colony is unable to be raided";

    @Override
    public int onExecute(CommandContext<CommandSourceStack> context) {
        int colonyID = IntegerArgumentType.getInteger(context, (String)"colonyID");
        IColony colony = IColonyManager.getInstance().getColonyByDimension(colonyID, (ResourceKey<Level>)((CommandSourceStack)context.getSource()).getLevel().dimension());
        if (colony == null) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatableEscape((String)"com.minecolonies.command.colonyidnotfound", (Object[])new Object[]{colonyID}), true);
            return 0;
        }
        if (!((CommandSourceStack)context.getSource()).hasPermission(4) && !((Boolean)((ServerConfiguration)MineColonies.getConfig().getServer()).canPlayerUseShowColonyInfoCommand.get()).booleanValue()) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatableEscape((String)"com.minecolonies.command.notenabledinconfig", (Object[])new Object[0]), true);
            return 0;
        }
        BlockPos position = colony.getCenter();
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)(ID_TEXT + colony.getID() + " Name: " + colony.getName())), true);
        String mayor = colony.getPermissions().getOwnerName();
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)(MAYOR_TEXT + mayor)), true);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)(CITIZENS + colony.getCitizenManager().getCurrentCitizenCount() + "/" + colony.getCitizenManager().getMaxCitizens())), true);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)(COORDINATES_TEXT + String.format(COORDINATES_XYZ, position.getX(), position.getY(), position.getZ()))).setStyle(Style.EMPTY.withColor(ChatFormatting.GREEN)), true);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)String.format(LAST_CONTACT_TEXT, colony.getLastContactInHours())), true);
        if (!colony.getRaiderManager().canHaveRaiderEvents()) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)CANNOT_BE_RAIDED), true);
        }
        return 1;
    }

    @Override
    public String getName() {
        return "info";
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(IMCCommand.newArgument("colonyID", IntegerArgumentType.integer((int)1)).executes(this::checkPreConditionAndExecute));
    }
}

