/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.managers;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.ICitizen;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.ICitizenDataManager;
import com.minecolonies.api.colony.ICivilianData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.HiringMode;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.managers.interfaces.ICitizenManager;
import com.minecolonies.api.configuration.ServerConfiguration;
import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.api.entity.citizen.AbstractCivilianEntity;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.happiness.IHappinessModifier;
import com.minecolonies.api.eventbus.events.colony.citizens.CitizenAddedModEvent;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.EntityUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.core.MineColonies;
import com.minecolonies.core.colony.CitizenData;
import com.minecolonies.core.colony.Colony;
import com.minecolonies.core.colony.buildings.modules.AbstractAssignedCitizenModule;
import com.minecolonies.core.colony.buildings.modules.BuildingModules;
import com.minecolonies.core.colony.buildings.modules.LivingBuildingModule;
import com.minecolonies.core.colony.buildings.modules.WorkAtHomeBuildingModule;
import com.minecolonies.core.colony.buildings.modules.WorkerBuildingModule;
import com.minecolonies.core.colony.eventhooks.citizenEvents.CitizenSpawnedEvent;
import com.minecolonies.core.colony.jobs.AbstractJobGuard;
import com.minecolonies.core.colony.jobs.JobUndertaker;
import com.minecolonies.core.entity.citizen.EntityCitizen;
import com.minecolonies.core.network.messages.client.colony.ColonyViewCitizenViewMessage;
import com.minecolonies.core.network.messages.client.colony.ColonyViewRemoveCitizenMessage;
import com.minecolonies.core.quests.QuestInstance;
import com.minecolonies.core.quests.triggers.CitizenTriggerReturnData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.entity.EntityAccess;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CitizenManager
implements ICitizenManager {
    @NotNull
    private final Map<Integer, ICitizenData> citizens = new HashMap<Integer, ICitizenData>();
    private boolean isCitizensDirty = false;
    private int topCitizenId = 0;
    private int maxCitizens = 0;
    private int potentialMaxCitizens;
    private final Colony colony;
    private int respawnInterval = 600;
    private Random random = new Random();
    private boolean areCitizensSleeping;

    public CitizenManager(Colony colony) {
        this.colony = colony;
    }

    @Override
    public void registerCivilian(AbstractCivilianEntity entity) {
        if (entity.getCivilianID() == 0 || this.citizens.get(entity.getCivilianID()) == null) {
            if (!entity.isAddedToLevel()) {
                Log.getLogger().warn("Discarding entity not added to world, should be only called after:", (Throwable)new Exception());
            }
            entity.remove(Entity.RemovalReason.DISCARDED);
            return;
        }
        ICitizenData data = this.citizens.get(entity.getCivilianID());
        if (data == null || !entity.getUUID().equals(data.getUUID())) {
            if (!entity.isAddedToLevel()) {
                Log.getLogger().warn("Discarding entity not added to world, should be only called after:", (Throwable)new Exception());
            }
            entity.remove(Entity.RemovalReason.DISCARDED);
            return;
        }
        Optional<AbstractEntityCitizen> existingCitizen = data.getEntity();
        if (existingCitizen.isEmpty()) {
            data.setEntity(entity);
            return;
        }
        if (!entity.isAddedToLevel()) {
            Log.getLogger().warn("Discarding entity not added to world, should be only called after:", (Throwable)new Exception());
        }
        entity.remove(Entity.RemovalReason.DISCARDED);
    }

    @Override
    public void unregisterCivilian(AbstractCivilianEntity entity) {
        ICitizenData data = this.citizens.get(entity.getCivilianID());
        if (data != null && data.getEntity().isPresent() && data.getEntity().get() == entity) {
            this.citizens.get(entity.getCivilianID()).setEntity(null);
        }
    }

    @Override
    public void read(@NotNull HolderLookup.Provider provider, @NotNull CompoundTag compound) {
        this.citizens.forEach((id, citizen) -> citizen.getEntity().ifPresent(e -> e.remove(Entity.RemovalReason.DISCARDED)));
        this.citizens.clear();
        this.citizens.putAll(NBTUtils.streamCompound(compound.getList("citizens", 10)).map(s -> this.deserializeCitizen(provider, (CompoundTag)s)).collect(Collectors.toMap(ICitizen::getId, Function.identity())));
        this.colony.updateHasChilds();
    }

    private ICitizenData deserializeCitizen(@NotNull HolderLookup.Provider provider, @NotNull CompoundTag compound) {
        ICitizenData data = ICitizenDataManager.getInstance().createFromNBT(provider, compound, this.colony);
        this.topCitizenId = Math.max(this.topCitizenId, data.getId());
        return data;
    }

    @Override
    public void write(@NotNull HolderLookup.Provider provider, @NotNull CompoundTag compoundNBT) {
        @NotNull ListTag citizenTagList = this.citizens.values().stream().map(citizen -> (CompoundTag)citizen.serializeNBT(provider)).collect(NBTUtils.toListNBT());
        compoundNBT.put("citizens", (Tag)citizenTagList);
    }

    @Override
    public void sendPackets(@NotNull Set<ServerPlayer> closeSubscribers, @NotNull Set<ServerPlayer> newSubscribers) {
        if (this.isCitizensDirty || !newSubscribers.isEmpty()) {
            HashSet<ServerPlayer> players = new HashSet<ServerPlayer>();
            if (this.isCitizensDirty) {
                players.addAll(closeSubscribers);
            }
            players.addAll(newSubscribers);
            for (ICitizenData citizen : this.citizens.values()) {
                if (!citizen.isDirty() && newSubscribers.isEmpty()) continue;
                new ColonyViewCitizenViewMessage(this.colony, citizen).sendToPlayer(players);
            }
        }
    }

    public ICitizenData spawnOrCreateCivilian(@Nullable ICivilianData data, Level world, BlockPos spawnPos, boolean force) {
        if (!this.colony.getBuildingManager().hasTownHall() || !this.colony.canMoveIn() && !force) {
            return (ICitizenData)data;
        }
        BlockPos spawnLocation = spawnPos;
        if (this.colony.hasTownHall() && (spawnLocation == null || spawnLocation.equals((Object)BlockPos.ZERO))) {
            spawnLocation = this.colony.getBuildingManager().getTownHall().getPosition();
        }
        if (WorldUtil.isEntityBlockLoaded((LevelAccessor)world, spawnLocation)) {
            BlockPos calculatedSpawn = EntityUtils.getSpawnPoint(world, spawnLocation);
            if (calculatedSpawn != null) {
                return this.spawnCitizenOnPosition((ICitizenData)data, world, force, calculatedSpawn);
            }
            if (this.colony.hasTownHall() && (calculatedSpawn = EntityUtils.getSpawnPoint(world, this.colony.getBuildingManager().getTownHall().getID())) != null) {
                return this.spawnCitizenOnPosition((ICitizenData)data, world, force, calculatedSpawn);
            }
            MessageUtils.format("com.minecolonies.coremod.citizens.nospace", spawnLocation.getX(), spawnLocation.getY(), spawnLocation.getZ()).sendTo(this.colony).forAllPlayers();
        }
        return (ICitizenData)data;
    }

    @NotNull
    private ICitizenData spawnCitizenOnPosition(@Nullable ICitizenData data, @NotNull Level world, boolean force, BlockPos spawnPoint) {
        ServerLevel serverLevel;
        Entity existing;
        ICitizenData citizenData = data;
        if (citizenData == null) {
            citizenData = this.createAndRegisterCivilianData();
            if (this.getMaxCitizens() >= this.getCurrentCitizenCount() && !force) {
                if (this.maxCitizensFromResearch() <= (double)this.getCurrentCitizenCount()) {
                    MessageUtils.format("block.blockhuttownhall.messagemaxsize.research", this.colony.getName()).sendTo(this.colony).forAllPlayers();
                } else {
                    MessageUtils.format("block.blockhuttownhall.messagemaxsize.config", this.colony.getName()).sendTo(this.colony).forAllPlayers();
                }
            }
            this.colony.getEventDescriptionManager().addEventDescription(new CitizenSpawnedEvent(spawnPoint, citizenData.getName()));
        }
        if (world instanceof ServerLevel && (existing = (serverLevel = (ServerLevel)world).getEntity(citizenData.getUUID())) != null) {
            existing.discard();
            existing = serverLevel.getEntity(citizenData.getUUID());
            if (existing != null) {
                serverLevel.entityManager.stopTracking((EntityAccess)existing);
            }
        }
        EntityCitizen entity = (EntityCitizen)ModEntities.CITIZEN.create(world);
        entity.setUUID(citizenData.getUUID());
        entity.setPos((double)spawnPoint.getX() + 0.5, (double)spawnPoint.getY() + 0.1, (double)spawnPoint.getZ() + 0.5);
        entity.setCitizenId(citizenData.getId());
        entity.getCitizenColonyHandler().setColonyId(this.colony.getID());
        world.addFreshEntity((Entity)entity);
        if (entity.isAddedToLevel()) {
            entity.getCitizenColonyHandler().registerWithColony(citizenData.getColony().getID(), citizenData.getId());
        }
        this.markDirty();
        return citizenData;
    }

    @Override
    public ICitizenData createAndRegisterCivilianData() {
        for (int i = 1; i <= this.getCurrentCitizenCount() + 1; ++i) {
            if (this.getCivilian(i) != null) continue;
            this.topCitizenId = i;
            break;
        }
        CitizenData citizenData = new CitizenData(this.topCitizenId, this.colony);
        citizenData.initForNewCivilian();
        this.citizens.put(citizenData.getId(), citizenData);
        return citizenData;
    }

    @Override
    public ICitizenData resurrectCivilianData(@NotNull CompoundTag compoundNBT, boolean resetId, @NotNull Level world, BlockPos spawnPos) {
        for (int i = 1; i <= this.getCurrentCitizenCount() + 1; ++i) {
            if (this.getCivilian(i) != null) continue;
            this.topCitizenId = i;
            break;
        }
        if (resetId) {
            compoundNBT.putInt("id", this.topCitizenId);
        }
        ICitizenData citizenData = this.deserializeCitizen((HolderLookup.Provider)world.registryAccess(), compoundNBT);
        citizenData.onResurrect();
        this.citizens.put(citizenData.getId(), citizenData);
        this.spawnOrCreateCitizen(citizenData, world, spawnPos);
        IMinecoloniesAPI.getInstance().getEventBus().post(new CitizenAddedModEvent(citizenData, CitizenAddedModEvent.CitizenAddedSource.RESURRECTED));
        return citizenData;
    }

    @Override
    public void removeCivilian(@NotNull ICivilianData citizen) {
        if (!(citizen instanceof ICitizenData)) {
            return;
        }
        this.citizens.remove(citizen.getId());
        for (IBuilding building : this.colony.getBuildingManager().getBuildings().values()) {
            for (AbstractAssignedCitizenModule assignedCitizenModule : building.getModulesByType(AbstractAssignedCitizenModule.class)) {
                assignedCitizenModule.removeCitizen((ICitizenData)citizen);
            }
        }
        this.colony.getWorkManager().clearWorkForCitizen((ICitizenData)citizen);
        new ColonyViewRemoveCitizenMessage(this.colony, citizen.getId()).sendToPlayer(this.colony.getPackageManager().getCloseSubscribers());
        this.calculateMaxCitizens();
        this.markDirty();
        this.colony.markDirty();
    }

    @Override
    public ICitizenData getJoblessCitizen() {
        for (ICitizenData citizen : this.citizens.values()) {
            if (citizen.getWorkBuilding() != null || citizen.isChild()) continue;
            return citizen;
        }
        return null;
    }

    @Override
    public void calculateMaxCitizens() {
        int newMaxCitizens = 0;
        int potentialMax = 0;
        for (IBuilding b : this.colony.getBuildingManager().getBuildings().values()) {
            AbstractAssignedCitizenModule module;
            if (b.getBuildingLevel() <= 0) continue;
            if (b.hasModule(BuildingModules.BED) && b.hasModule(WorkAtHomeBuildingModule.class)) {
                module = (WorkAtHomeBuildingModule)b.getFirstModuleOccurance(WorkAtHomeBuildingModule.class);
                newMaxCitizens += b.getAllAssignedCitizen().size();
                potentialMax += ((WorkerBuildingModule)module).getModuleMax() - b.getAllAssignedCitizen().size();
                continue;
            }
            if (!b.hasModule(LivingBuildingModule.class)) continue;
            module = (LivingBuildingModule)b.getFirstModuleOccurance(LivingBuildingModule.class);
            if (HiringMode.LOCKED.equals((Object)module.getHiringMode())) {
                newMaxCitizens += module.getAssignedCitizen().size();
                continue;
            }
            newMaxCitizens += ((LivingBuildingModule)module).getModuleMax();
        }
        if (this.getMaxCitizens() != newMaxCitizens || this.getPotentialMaxCitizens() != potentialMax + newMaxCitizens) {
            this.setMaxCitizens(newMaxCitizens);
            this.setPotentialMaxCitizens(potentialMax + newMaxCitizens);
            this.colony.markDirty();
        }
    }

    @Override
    public void spawnOrCreateCitizen() {
        this.spawnOrCreateCitizen(null, (Level)this.colony.getWorld(), null);
    }

    @Override
    @NotNull
    public Map<Integer, ICivilianData> getCivilianDataMap() {
        return Collections.unmodifiableMap(this.citizens);
    }

    @Override
    public void markDirty() {
        this.colony.markDirty();
        this.isCitizensDirty = true;
    }

    @Override
    public ICitizenData getCivilian(int citizenId) {
        return this.citizens.get(citizenId);
    }

    @Override
    public void clearDirty() {
        this.isCitizensDirty = false;
        this.citizens.values().forEach(ICivilianData::clearDirty);
    }

    @Override
    public List<ICitizenData> getCitizens() {
        return new ArrayList<ICitizenData>(this.citizens.values());
    }

    @Override
    public int getMaxCitizens() {
        return (int)Math.max(1.0, Math.min((double)this.maxCitizens, Math.min(this.maxCitizensFromResearch(), (double)((Integer)((ServerConfiguration)MineColonies.getConfig().getServer()).maxCitizenPerColony.get()).intValue())));
    }

    @Override
    public int getPotentialMaxCitizens() {
        return (int)Math.max(1.0, Math.min((double)this.potentialMaxCitizens, Math.min(this.maxCitizensFromResearch(), (double)((Integer)((ServerConfiguration)MineColonies.getConfig().getServer()).maxCitizenPerColony.get()).intValue())));
    }

    @Override
    public double maxCitizensFromResearch() {
        if (MinecoloniesAPIProxy.getInstance().getGlobalResearchTree().hasResearchEffect(ResearchConstants.CITIZEN_CAP)) {
            int max = Math.max(25, (int)this.colony.getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.CITIZEN_CAP));
            return Math.min(max, (Integer)((ServerConfiguration)MineColonies.getConfig().getServer()).maxCitizenPerColony.get());
        }
        return ((Integer)((ServerConfiguration)MineColonies.getConfig().getServer()).maxCitizenPerColony.get()).intValue();
    }

    @Override
    public int getCurrentCitizenCount() {
        return this.citizens.size();
    }

    @Override
    public void setMaxCitizens(int newMaxCitizens) {
        this.maxCitizens = newMaxCitizens;
    }

    @Override
    public void setPotentialMaxCitizens(int newPotentialMax) {
        this.potentialMaxCitizens = newPotentialMax;
    }

    @Override
    public void injectModifier(IHappinessModifier modifier) {
        for (ICitizenData citizenData : this.citizens.values()) {
            citizenData.getCitizenHappinessHandler().addModifier(modifier);
        }
    }

    @Override
    public void checkCitizensForHappiness() {
        for (ICitizenData citizenData : this.citizens.values()) {
            citizenData.getCitizenHappinessHandler().processDailyHappiness(citizenData);
        }
    }

    @Override
    public boolean tickCitizenData(int tickRate) {
        for (ICitizenData iCitizenData : this.getCitizens()) {
            iCitizenData.update(tickRate);
        }
        return false;
    }

    @Override
    public void onColonyTick(IColony colony) {
        if (colony.hasTownHall()) {
            this.getCitizens().stream().filter(Objects::nonNull).forEach(ICivilianData::updateEntityIfNecessary);
        }
        if (colony.canMoveIn() && colony.hasTownHall() && this.getCitizens().size() < (Integer)((ServerConfiguration)MineColonies.getConfig().getServer()).initialCitizenAmount.get()) {
            this.respawnInterval -= 500 + 60 * colony.getBuildingManager().getTownHall().getBuildingLevel();
            if (this.respawnInterval <= 0) {
                this.respawnInterval = 1200;
                int femaleCount = 0;
                for (ICitizenData citizens : this.getCitizens()) {
                    femaleCount += citizens.isFemale() ? 1 : 0;
                }
                boolean firstCitizen = this.getCitizens().size() == 0;
                ICitizenData newCitizen = this.createAndRegisterCivilianData();
                if (firstCitizen) {
                    colony.getQuestManager().injectAvailableQuest(new QuestInstance(new ResourceLocation("minecolonies", "tutorial/welcome"), colony, List.of(new CitizenTriggerReturnData(newCitizen))));
                }
                if (this.getCitizens().size() == 1) {
                    newCitizen.setGenderAndGenerateName(this.random.nextBoolean());
                } else if ((double)femaleCount < (double)(this.getCitizens().size() - 1) / 2.0) {
                    newCitizen.setGenderAndGenerateName(true);
                } else {
                    newCitizen.setGenderAndGenerateName(false);
                }
                this.spawnOrCreateCivilian(newCitizen, colony.getWorld(), (BlockPos)null, true);
                IMinecoloniesAPI.getInstance().getEventBus().post(new CitizenAddedModEvent(newCitizen, CitizenAddedModEvent.CitizenAddedSource.INITIAL));
                colony.getEventDescriptionManager().addEventDescription(new CitizenSpawnedEvent(colony.getBuildingManager().getTownHall().getPosition(), newCitizen.getName()));
            }
        }
    }

    @Override
    public void updateCitizenMourn(ICitizenData data, boolean mourn) {
        for (ICitizenData citizen : this.getCitizens()) {
            if (mourn) {
                if (!(citizen.getJob() instanceof AbstractJobGuard) && !(citizen.getJob() instanceof JobUndertaker) && (citizen.isRelatedTo(data) || citizen.doesLiveWith(data))) {
                    citizen.getCitizenMournHandler().addDeceasedCitizen(data.getName());
                }
            } else {
                citizen.getCitizenMournHandler().removeDeceasedCitizen(data.getName());
            }
            citizen.onDeath(data.getId());
        }
    }

    @Override
    public ICitizenData getRandomCitizen() {
        return (ICitizenData)this.citizens.values().toArray()[this.random.nextInt(this.citizens.values().size())];
    }

    @Override
    public void updateCitizenSleep(boolean sleep) {
        this.areCitizensSleeping = sleep;
    }

    @Override
    public void onCitizenSleep() {
        for (ICitizenData citizenData : this.citizens.values()) {
            if (citizenData.isAsleep() || citizenData.getJob() instanceof AbstractJobGuard) continue;
            return;
        }
        if (!this.areCitizensSleeping) {
            MessageUtils.format("com.minecolonies.coremod.entity.citizen.sleep", new Object[0]).sendTo(this.colony).forAllPlayers();
        }
        this.areCitizensSleeping = true;
    }

    @Override
    public void onWakeUp() {
        for (ICitizenData citizenData : this.citizens.values()) {
            if (citizenData.getCitizenMournHandler().isMourning()) {
                citizenData.getCitizenMournHandler().clearDeceasedCitizen();
                citizenData.getCitizenMournHandler().setMourning(false);
                continue;
            }
            if (!citizenData.getCitizenMournHandler().shouldMourn()) continue;
            citizenData.getCitizenMournHandler().setMourning(true);
        }
    }

    @Override
    public void afterBuildingLoad() {
        this.calculateMaxCitizens();
        for (ICitizenData data : this.citizens.values()) {
            data.onBuildingLoad();
        }
    }
}

