/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.interactionhandling;

import com.ldtteam.blockui.views.BOWindow;
import com.minecolonies.api.colony.ICitizen;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.interactionhandling.AbstractInteractionResponseHandler;
import com.minecolonies.api.colony.interactionhandling.IChatPriority;
import com.minecolonies.api.colony.interactionhandling.InteractionValidatorRegistry;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.Utils;
import com.minecolonies.core.client.gui.citizen.MainWindowCitizen;
import com.minecolonies.core.network.messages.server.colony.InteractionResponse;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public abstract class ServerCitizenInteraction
extends AbstractInteractionResponseHandler {
    private static final String TAG_DELAY = "delay";
    private static final String TAG_PARENT = "parent";
    private static final String TAG_PARENTS = "parents";
    private static final String TAG_VALIDATOR_ID = "validator";
    private int displayAtWorldTick = 0;
    private Predicate<ICitizenData> validator;
    protected Component validatorId;
    protected Set<Component> parents = new HashSet<Component>();

    @SafeVarargs
    public ServerCitizenInteraction(Component inquiry, boolean primary, IChatPriority priority, Predicate<ICitizenData> validator, @NotNull Component validatorId, Tuple<Component, Component> ... responseTuples) {
        super(inquiry, primary, priority, responseTuples);
        this.validator = validator;
        this.validatorId = validatorId;
        if (this.validatorId == null) {
            this.validatorId = Component.empty();
            Log.getLogger().error("Validator id is null: " + String.valueOf(this.getClass()) + " " + String.valueOf(this.getInquiry()), (Throwable)new Exception());
        }
    }

    public ServerCitizenInteraction(ICitizen data) {
    }

    @Override
    public boolean isVisible(Level world) {
        return this.displayAtWorldTick == 0 || (long)this.displayAtWorldTick < world.getGameTime();
    }

    @Override
    public boolean isValid(ICitizenData citizen) {
        return this.validator == null && !this.parents.isEmpty() || this.validator != null && this.validator.test(citizen);
    }

    public void addParent(Component parent) {
        this.parents.add(parent);
    }

    @Override
    public void removeParent(Component oldParent) {
        this.parents.remove(oldParent);
    }

    @Override
    public void onServerResponseTriggered(int responseId, Player player, ICitizenData data) {
        Component response = this.getPossibleResponses().get(responseId);
        this.tryHandleIgnoreResponse(response, player);
    }

    private void tryHandleIgnoreResponse(Component response, Player player) {
        if (response.getContents() instanceof TranslatableContents) {
            if (((TranslatableContents)response.getContents()).getKey().equals("com.minecolonies.coremod.gui.chat.ignore")) {
                this.displayAtWorldTick = (int)(player.level().getGameTime() + 432000L);
            } else if (((TranslatableContents)response.getContents()).getKey().equals("com.minecolonies.coremod.gui.chat.remindmelater")) {
                this.displayAtWorldTick = (int)(player.level().getGameTime() + 72000L);
            } else if (((TranslatableContents)response.getContents()).getKey().equals("com.minecolonies.coremod.gui.chat.okay") || ((TranslatableContents)response.getContents()).getKey().equals("com.minecolonies.coremod.gui.chat.skipchitchat")) {
                this.displayAtWorldTick = (int)(player.level().getGameTime() + 6000L);
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean onClientResponseTriggered(int responseId, Player player, ICitizenDataView data, BOWindow window) {
        Component response = this.getPossibleResponses().get(responseId);
        this.tryHandleIgnoreResponse(response, player);
        if (((TranslatableContents)this.getPossibleResponses().get(responseId).getContents()).getKey().equals("com.minecolonies.coremod.gui.chat.skipchitchat")) {
            MainWindowCitizen windowCitizen = new MainWindowCitizen(data);
            windowCitizen.open();
        }
        new InteractionResponse(data.getColonyId(), data.getId(), (ResourceKey<Level>)player.level().dimension(), this.getInquiry(), responseId).sendToServer();
        return true;
    }

    @Override
    public CompoundTag serializeNBT(@NotNull HolderLookup.Provider provider) {
        CompoundTag compoundNBT = super.serializeNBT(provider);
        compoundNBT.putInt(TAG_DELAY, this.displayAtWorldTick);
        ListTag list = new ListTag();
        for (Component element : this.parents) {
            list.add((Object)Utils.serializeCodecMess(ComponentSerialization.CODEC, provider, element));
        }
        compoundNBT.put(TAG_PARENTS, (Tag)list);
        compoundNBT.put(TAG_VALIDATOR_ID, Utils.serializeCodecMess(ComponentSerialization.CODEC, provider, this.validatorId));
        return compoundNBT;
    }

    @Override
    public void deserializeNBT(@NotNull HolderLookup.Provider provider, @NotNull CompoundTag compoundNBT) {
        super.deserializeNBT(provider, compoundNBT);
        this.displayAtWorldTick = compoundNBT.getInt(TAG_DELAY);
        this.parents.clear();
        ListTag list = compoundNBT.getList(TAG_PARENTS, 10);
        for (Tag tag : list) {
            this.parents.add((Component)Utils.deserializeCodecMess(ComponentSerialization.CODEC, provider, tag));
        }
        this.validatorId = (Component)Utils.deserializeCodecMess(ComponentSerialization.CODEC, provider, compoundNBT.get(TAG_VALIDATOR_ID));
        this.loadValidator();
    }

    protected void loadValidator() {
        this.validator = InteractionValidatorRegistry.getStandardInteractionValidatorPredicate(this.validatorId);
    }

    @Override
    public Component getId() {
        return this.getInquiry();
    }
}

