/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.fields.registry;

import com.minecolonies.api.colony.fields.IField;
import com.minecolonies.api.colony.fields.registry.FieldRegistries;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Log;
import io.netty.buffer.Unpooled;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public final class FieldDataManager {
    private static final String TAG_FIELD_NAME = "name";
    private static final String TAG_FIELD_POSITION = "position";
    private static final String TAG_FIELD_DATA = "data";

    private FieldDataManager() {
    }

    public static IField compoundToField(@NotNull HolderLookup.Provider provider, @NotNull CompoundTag compound) {
        BlockPos position;
        ResourceLocation fieldName = ResourceLocation.parse((String)compound.getString(TAG_FIELD_NAME));
        IField field = FieldDataManager.resourceLocationToField(fieldName, position = BlockPosUtil.read(compound, TAG_FIELD_POSITION));
        if (field != null) {
            field.deserializeNBT(provider, compound.getCompound(TAG_FIELD_DATA));
        }
        return field;
    }

    public static IField resourceLocationToField(@NotNull ResourceLocation fieldName, @NotNull BlockPos position) {
        FieldRegistries.FieldEntry fieldEntry = (FieldRegistries.FieldEntry)FieldRegistries.getFieldRegistry().get(fieldName);
        if (fieldEntry == null) {
            Log.getLogger().error("Unknown field type '{}'.", (Object)fieldName);
            return null;
        }
        return fieldEntry.produceField(position);
    }

    public static IField bufferToField(@NotNull RegistryFriendlyByteBuf buf) {
        FieldRegistries.FieldEntry fieldType = (FieldRegistries.FieldEntry)buf.readById(arg_0 -> FieldRegistries.getFieldRegistry().byIdOrThrow(arg_0));
        BlockPos position = buf.readBlockPos();
        IField field = fieldType.produceField(position);
        field.deserialize(buf);
        return field;
    }

    public static RegistryFriendlyByteBuf fieldToBuffer(@NotNull IField field, @NotNull RegistryAccess provider) {
        RegistryFriendlyByteBuf buf = new RegistryFriendlyByteBuf(Unpooled.buffer(), provider);
        buf.writeById(arg_0 -> FieldRegistries.getFieldRegistry().getIdOrThrow(arg_0), (Object)field.getFieldType());
        buf.writeBlockPos(field.getPosition());
        field.serialize(buf);
        return buf;
    }

    public static CompoundTag fieldToCompound(@NotNull HolderLookup.Provider provider, @NotNull IField field) {
        CompoundTag compound = new CompoundTag();
        compound.putString(TAG_FIELD_NAME, field.getFieldType().getRegistryName().toString());
        BlockPosUtil.write(compound, TAG_FIELD_POSITION, field.getPosition());
        compound.put(TAG_FIELD_DATA, (Tag)field.serializeNBT(provider));
        return compound;
    }
}

