/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.events.raid.egyptianevent;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.colonyEvents.EventStatus;
import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.api.entity.mobs.AbstractEntityMinecoloniesRaider;
import com.minecolonies.api.sounds.RaidSounds;
import com.minecolonies.core.colony.events.raid.HordeRaidEvent;
import com.minecolonies.core.entity.mobs.raider.egyptians.EntityArcherMummyRaider;
import com.minecolonies.core.entity.mobs.raider.egyptians.EntityMummyRaider;
import com.minecolonies.core.entity.mobs.raider.egyptians.EntityPharaoRaider;
import com.minecolonies.core.network.messages.client.PlayAudioMessage;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public class EgyptianRaidEvent
extends HordeRaidEvent {
    public static final ResourceLocation EGYPTIAN_RAID_EVENT_TYPE_ID = new ResourceLocation("minecolonies", "egyptian_raid");
    private int musicCooldown = 0;

    public EgyptianRaidEvent(IColony colony) {
        super(colony);
    }

    @Override
    public ResourceLocation getEventTypeID() {
        return EGYPTIAN_RAID_EVENT_TYPE_ID;
    }

    @Override
    public void onStart() {
        super.onStart();
        PlayAudioMessage.sendToAll(this.getColony(), true, false, new PlayAudioMessage(RaidSounds.DESERT_RAID_WARNING));
    }

    @Override
    protected void updateRaidBar() {
        super.updateRaidBar();
        this.raidBar.setDarkenScreen(true);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (--this.musicCooldown <= 0) {
            PlayAudioMessage.sendToAll(this.getColony(), true, true, new PlayAudioMessage(RaidSounds.DESERT_RAID));
            this.musicCooldown = 12;
        }
    }

    @Override
    public void registerEntity(Entity entity) {
        if (!(entity instanceof AbstractEntityMinecoloniesRaider) || !entity.isAlive()) {
            entity.remove(Entity.RemovalReason.DISCARDED);
            return;
        }
        if (entity instanceof EntityPharaoRaider && this.boss.keySet().size() < this.horde.numberOfBosses) {
            this.boss.put(entity, entity.getUUID());
            return;
        }
        if (entity instanceof EntityArcherMummyRaider && this.archers.keySet().size() < this.horde.numberOfArchers) {
            this.archers.put(entity, entity.getUUID());
            return;
        }
        if (entity instanceof EntityMummyRaider && this.normal.keySet().size() < this.horde.numberOfRaiders) {
            this.normal.put(entity, entity.getUUID());
            return;
        }
        entity.remove(Entity.RemovalReason.DISCARDED);
    }

    @Override
    public void onEntityDeath(LivingEntity entity) {
        super.onEntityDeath(entity);
        if (!(entity instanceof AbstractEntityMinecoloniesRaider)) {
            return;
        }
        if (entity instanceof EntityPharaoRaider) {
            this.boss.remove(entity);
            --this.horde.numberOfBosses;
        }
        if (entity instanceof EntityArcherMummyRaider) {
            this.archers.remove(entity);
            --this.horde.numberOfArchers;
        }
        if (entity instanceof EntityMummyRaider) {
            this.normal.remove(entity);
            --this.horde.numberOfRaiders;
        }
        --this.horde.hordeSize;
        if (this.horde.hordeSize == 0) {
            this.status = EventStatus.DONE;
        }
        this.sendHordeMessage();
    }

    public static EgyptianRaidEvent loadFromNBT(IColony colony, CompoundTag compound, @NotNull HolderLookup.Provider provider) {
        EgyptianRaidEvent event = new EgyptianRaidEvent(colony);
        event.deserializeNBT(provider, compound);
        return event;
    }

    @Override
    public EntityType<?> getNormalRaiderType() {
        return ModEntities.MUMMY;
    }

    @Override
    public EntityType<?> getArcherRaiderType() {
        return ModEntities.ARCHERMUMMY;
    }

    @Override
    public EntityType<?> getBossRaiderType() {
        return ModEntities.PHARAO;
    }

    @Override
    protected MutableComponent getDisplayName() {
        return Component.translatableEscape((String)"com.minecolonies.coremod.raid.egyptian.name", (Object[])new Object[0]);
    }
}

