/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.events.raid;

import com.ldtteam.structurize.api.RotationMirror;
import com.ldtteam.structurize.storage.ServerFutureProcessor;
import com.ldtteam.structurize.storage.StructurePacks;
import com.minecolonies.api.colony.ColonyState;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.colonyEvents.EventStatus;
import com.minecolonies.api.colony.colonyEvents.IColonyRaidEvent;
import com.minecolonies.api.colony.colonyEvents.IColonyStructureSpawnEvent;
import com.minecolonies.api.entity.mobs.AbstractEntityMinecoloniesRaider;
import com.minecolonies.api.entity.mobs.RaiderMobUtils;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.api.util.constant.ColonyConstants;
import com.minecolonies.core.colony.events.raid.pirateEvent.ShipBasedRaiderUtils;
import com.minecolonies.core.colony.events.raid.pirateEvent.ShipSize;
import com.minecolonies.core.entity.pathfinding.pathresults.PathResult;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.BossEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.pathfinder.Path;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractShipRaidEvent
implements IColonyRaidEvent,
IColonyStructureSpawnEvent {
    protected static final int WAYPOINT_SPACING = 30;
    public static final String TAG_DAYS_LEFT = "pirateDaysLeft";
    public static final String TAG_SPAWNER_COUNT = "spawnerCount";
    public static final String TAG_POS = "pos";
    public static final String TAG_SPAWNERS = "spawners";
    public static final String TAG_SHIPSIZE = "shipSize";
    public static final String TAG_SHIP_ROTMIR = "shipRotMir";
    public static final String TAG_RAIDER_THRESHOLD_TRACKER = "raiderkillthresholdtracker";
    public static final String TAG_MAX_RAIDER_COUNT = "maxRaiderCount";
    private static final int MAX_LANDING_DISTANCE = 200;
    private static final int MIN_CENTER_DISTANCE = 200;
    private static final int ADD_MAX_PIRATES = 10;
    protected EventStatus status = EventStatus.STARTING;
    protected final ServerBossEvent raidBar = new ServerBossEvent((Component)Component.literal((String)"Colony Raid"), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.NOTCHED_10);
    private int id;
    protected IColony colony;
    protected BlockPos spawnPoint;
    protected ShipSize shipSize;
    private int daysToGo = 3;
    protected Map<Entity, UUID> raiders = new WeakHashMap<Entity, UUID>();
    private List<Tuple<EntityType<?>, BlockPos>> respawns = new ArrayList();
    protected RotationMirror shipRotationMirror = RotationMirror.NONE;
    private List<BlockPos> spawners = new ArrayList<BlockPos>();
    private int maxSpawners = 0;
    protected PathResult spawnPathResult;
    protected List<BlockPos> wayPoints = new ArrayList<BlockPos>();
    protected int maxRaiderCount = 0;
    protected int spawnerThresholdKillTracker = 0;

    public AbstractShipRaidEvent(@NotNull IColony colony) {
        this.colony = colony;
        this.id = colony.getEventManager().getAndTakeNextEventID();
    }

    @Override
    public void onStart() {
        this.status = EventStatus.PREPARING;
        ServerFutureProcessor.queueBlueprint((ServerFutureProcessor.BlueprintProcessingData)new ServerFutureProcessor.BlueprintProcessingData(StructurePacks.getBlueprintFuture((String)"Minecolonies Original", (String)("decorations/ships/" + this.shipSize.schematicPrefix + this.getShipDesc() + ".blueprint"), (HolderLookup.Provider)this.colony.getWorld().registryAccess()), this.colony.getWorld(), blueprint -> {
            blueprint.setRotationMirror(this.shipRotationMirror, this.colony.getWorld());
            if (this.spawnPathResult != null && this.spawnPathResult.isDone()) {
                BlockPos endpoint;
                Path path = this.spawnPathResult.getPath();
                if (path != null && path.canReach() && ShipBasedRaiderUtils.canPlaceShipAt(endpoint = path.getEndNode().asBlockPos().below(), blueprint, this.colony.getWorld())) {
                    this.spawnPoint = endpoint;
                }
                this.wayPoints = ShipBasedRaiderUtils.createWaypoints(this.colony.getWorld(), path, 30);
            }
            if (!ShipBasedRaiderUtils.canPlaceShipAt(this.spawnPoint, blueprint, this.colony.getWorld())) {
                this.spawnPoint = this.spawnPoint.below();
            }
            if (!ShipBasedRaiderUtils.spawnPirateShip(this.spawnPoint, this.colony, blueprint, this)) {
                this.status = EventStatus.CANCELED;
                return;
            }
            this.updateRaidBar();
            MessageUtils.format("event.minecolonies.raidmessage_p" + this.shipSize.messageID, BlockPosUtil.calcDirection(this.colony.getCenter(), this.spawnPoint).getLongText(), this.colony.getName()).withPriority(MessageUtils.MessagePriority.DANGER).sendTo(this.colony).forManagers();
            this.colony.markDirty();
        }));
    }

    protected void updateRaidBar() {
        Component directionName = BlockPosUtil.calcDirection(this.colony.getCenter(), this.spawnPoint).getLongText();
        this.raidBar.setName((Component)this.getDisplayName().append(" - ").append(directionName));
        for (Player player : this.colony.getPackageManager().getCloseSubscribers()) {
            this.raidBar.addPlayer((ServerPlayer)player);
        }
        this.raidBar.setVisible(true);
    }

    protected abstract MutableComponent getDisplayName();

    @Override
    public void onUpdate() {
        BlockPos spawnPos;
        this.status = EventStatus.PROGRESSING;
        this.colony.getRaiderManager().setNightsSinceLastRaid(0);
        if (this.spawners.size() <= 0 && this.raiders.size() == 0 && this.respawns.isEmpty()) {
            this.status = EventStatus.WAITING;
            return;
        }
        this.updateRaidBar();
        if (!this.respawns.isEmpty()) {
            for (Tuple<EntityType<?>, BlockPos> entry : this.respawns) {
                BlockPos spawnPos2 = ShipBasedRaiderUtils.getLoadedPositionTowardsCenter(entry.getB(), this.colony, 200, this.spawnPoint, 200, 10, this.isUnderWater());
                if (spawnPos2 == null) continue;
                RaiderMobUtils.spawn(entry.getA(), 1, spawnPos2, this.colony.getWorld(), this.colony, this.id);
            }
            this.respawns.clear();
            return;
        }
        this.spawners.removeIf(spawner -> this.colony.getWorld() != null && WorldUtil.isBlockLoaded((LevelAccessor)this.colony.getWorld(), spawner) && this.colony.getWorld().getBlockState(spawner).getBlock() != Blocks.SPAWNER);
        if (this.raiders.size() < this.spawners.size() * 2 && (spawnPos = ShipBasedRaiderUtils.getLoadedPositionTowardsCenter(this.spawnPoint, this.colony, 200, this.spawnPoint, 200, 10, this.isUnderWater())) != null) {
            if (spawnPos.distSqr((Vec3i)this.spawnPoint) < 25.0) {
                spawnPos = ShipBasedRaiderUtils.findSpawnPosOnShip(spawnPos, this.colony.getWorld(), 3);
            }
            RaiderMobUtils.spawn(this.getNormalRaiderType(), this.shipSize.normal, spawnPos, this.colony.getWorld(), this.colony, this.id);
            RaiderMobUtils.spawn(this.getArcherRaiderType(), this.shipSize.archer, spawnPos, this.colony.getWorld(), this.colony, this.id);
            RaiderMobUtils.spawn(this.getBossRaiderType(), this.shipSize.boss, spawnPos, this.colony.getWorld(), this.colony, this.id);
        }
        if (this.colony.getRaiderManager().areSpiesEnabled() || this.spawners.isEmpty()) {
            for (Entity entity : this.getEntities()) {
                if (!(entity instanceof LivingEntity)) continue;
                ((LivingEntity)entity).addEffect(new MobEffectInstance(MobEffects.GLOWING, 550));
            }
        }
    }

    public boolean isUnderWater() {
        return false;
    }

    @Override
    public void onFinish() {
        MessageUtils.format("com.minecolonies.coremod.raid.sailing.away", BlockPosUtil.calcDirection(this.colony.getCenter(), this.spawnPoint).getLongText()).sendTo(this.colony).forManagers();
        for (Entity entity : this.raiders.keySet()) {
            entity.remove(Entity.RemovalReason.DISCARDED);
        }
        this.raidBar.setVisible(false);
        this.raidBar.removeAllPlayers();
    }

    @Override
    public void onTileEntityBreak(BlockEntity te) {
        if (te instanceof SpawnerBlockEntity) {
            this.spawners.remove(te.getBlockPos());
            this.raidBar.setProgress((float)this.spawners.size() / (float)this.maxSpawners);
            this.checkRaidEnd();
        }
    }

    private void checkRaidEnd() {
        if (this.raiders.isEmpty() && this.spawners.isEmpty()) {
            this.status = EventStatus.WAITING;
            this.colony.getRaiderManager().onRaidEventFinished(this);
            this.daysToGo = 1;
            MessageUtils.format("com.minecolonies.coremod.raid.end." + this.getEventTypeID().getPath() + ColonyConstants.rand.nextInt(3), BlockPosUtil.calcDirection(this.colony.getCenter(), this.spawnPoint).getLongText()).sendTo(this.colony, true).forManagers();
        }
    }

    @Override
    public void onNightFall() {
        --this.daysToGo;
        if (this.daysToGo <= 0) {
            this.status = EventStatus.DONE;
        }
    }

    @Override
    public void onEntityDeath(LivingEntity entity) {
        ++this.spawnerThresholdKillTracker;
        if (!this.spawners.isEmpty() && this.spawnerThresholdKillTracker > this.maxRaiderCount / this.maxSpawners) {
            this.colony.getWorld().removeBlock(this.spawners.remove(0), false);
            this.raidBar.setProgress((float)this.spawners.size() / (float)this.maxSpawners);
            this.spawnerThresholdKillTracker = 0;
        }
        this.raiders.remove(entity);
        this.checkRaidEnd();
    }

    @Override
    public void registerEntity(Entity entity) {
        if (!(entity instanceof AbstractEntityMinecoloniesRaider) || !entity.isAlive() || this.status != EventStatus.PROGRESSING) {
            entity.remove(Entity.RemovalReason.DISCARDED);
            return;
        }
        if (this.raiders.keySet().size() < this.getMaxRaiders()) {
            this.raiders.put(entity, entity.getUUID());
        } else {
            entity.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    @Override
    public void unregisterEntity(Entity entity) {
        if (!this.raiders.containsKey(entity) || this.status != EventStatus.PROGRESSING || this.colony.getState() != ColonyState.ACTIVE) {
            return;
        }
        this.raiders.remove(entity);
        this.respawns.add(new Tuple<EntityType, BlockPos>(entity.getType(), entity.blockPosition()));
    }

    private int getMaxRaiders() {
        return this.spawners.size() * 2 + 10;
    }

    public void setShipSize(ShipSize shipSize) {
        this.shipSize = shipSize;
    }

    public void setShipRotation(RotationMirror shipRotationMirror) {
        this.shipRotationMirror = shipRotationMirror;
    }

    @Override
    public void setColony(@NotNull IColony colony) {
        this.colony = colony;
    }

    @Override
    public void setSpawnPoint(BlockPos spawnPoint) {
        this.spawnPoint = spawnPoint;
    }

    @Override
    public BlockPos getSpawnPos() {
        return this.spawnPoint;
    }

    @Override
    public List<Entity> getEntities() {
        return new ArrayList<Entity>(this.raiders.keySet());
    }

    @Override
    public EventStatus getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(EventStatus status) {
        this.status = status;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public List<Tuple<String, BlockPos>> getSchematicSpawns() {
        ArrayList<Tuple<String, BlockPos>> paths = new ArrayList<Tuple<String, BlockPos>>();
        paths.add(new Tuple<CallSite, BlockPos>((CallSite)((Object)("decorations/ships/" + this.shipSize.schematicPrefix + this.getShipDesc() + ".blueprint")), this.spawnPoint));
        return paths;
    }

    public CompoundTag serializeNBT(@NotNull HolderLookup.Provider provider) {
        CompoundTag compound = new CompoundTag();
        compound.putInt("mc_event_id", this.id);
        compound.putInt(TAG_DAYS_LEFT, this.daysToGo);
        compound.putInt("eventStatus", this.status.ordinal());
        @NotNull ListTag spawnerListCompound = new ListTag();
        for (BlockPos entry : this.spawners) {
            spawnerListCompound.add((Object)NBTUtils.writeBlockPos(entry));
        }
        compound.put(TAG_SPAWNERS, (Tag)spawnerListCompound);
        compound.putInt(TAG_SPAWNER_COUNT, this.maxSpawners);
        BlockPosUtil.write(compound, "spawnPos", this.spawnPoint);
        compound.putInt(TAG_SHIPSIZE, this.shipSize.ordinal());
        compound.putByte(TAG_SHIP_ROTMIR, (byte)this.shipRotationMirror.ordinal());
        BlockPosUtil.writePosListToNBT(compound, "waypoints", this.wayPoints);
        compound.putInt(TAG_MAX_RAIDER_COUNT, this.maxRaiderCount);
        compound.putInt(TAG_RAIDER_THRESHOLD_TRACKER, this.spawnerThresholdKillTracker);
        return compound;
    }

    public void deserializeNBT(@NotNull HolderLookup.Provider provider, CompoundTag compound) {
        this.id = compound.getInt("mc_event_id");
        this.status = EventStatus.values()[compound.getInt("eventStatus")];
        this.daysToGo = compound.getInt(TAG_DAYS_LEFT);
        @NotNull ListTag spawnerListCompound = compound.getList(TAG_SPAWNERS, 11);
        for (int i = 0; i < spawnerListCompound.size(); ++i) {
            this.spawners.add(NBTUtils.readBlockPos(spawnerListCompound.get(i)));
        }
        this.maxSpawners = compound.getInt(TAG_SPAWNER_COUNT);
        this.spawnPoint = BlockPosUtil.read(compound, "spawnPos");
        this.shipSize = ShipSize.values()[compound.getInt(TAG_SHIPSIZE)];
        this.shipRotationMirror = RotationMirror.values()[compound.getByte(TAG_SHIP_ROTMIR)];
        this.wayPoints = BlockPosUtil.readPosListFromNBT(compound, "waypoints");
        this.maxRaiderCount = compound.getInt(TAG_MAX_RAIDER_COUNT);
        this.spawnerThresholdKillTracker = compound.getInt(TAG_RAIDER_THRESHOLD_TRACKER);
    }

    @Override
    public void addSpawner(BlockPos pos) {
        this.spawners.add(pos);
        ++this.maxSpawners;
    }

    @Override
    public List<BlockPos> getWayPoints() {
        return this.wayPoints;
    }

    public void setSpawnPath(PathResult result) {
        this.spawnPathResult = result;
    }

    @Override
    public boolean isRaidActive() {
        if (this.getStatus() == EventStatus.PROGRESSING) {
            return !this.spawners.isEmpty() || !this.raiders.isEmpty() || !this.respawns.isEmpty();
        }
        return this.getStatus() == EventStatus.PROGRESSING || this.getStatus() == EventStatus.PREPARING;
    }

    @Override
    public void setMaxRaiderCount(int maxRaiderCount) {
        this.maxRaiderCount = maxRaiderCount;
    }
}

