/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import com.minecolonies.api.util.constant.ColonyConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Pond {
    public static final int WATER_POOL_WIDTH_REQUIREMENT = 5;
    public static final int WATER_DEPTH_REQUIREMENT = 2;

    public static boolean checkPond(@NotNull BlockGetter world, @NotNull BlockPos water, @Nullable BlockPos.MutableBlockPos problematicPosition) {
        block0: for (BlockPos.MutableBlockPos tempPos : BlockPos.spiralAround((BlockPos)water, (int)2, (Direction)Direction.SOUTH, (Direction)Direction.EAST)) {
            for (int y = 0; y < 2; ++y) {
                if (!Pond.isWaterForFishing(world, (BlockPos)tempPos.setY(tempPos.getY() - y))) {
                    if (problematicPosition != null) {
                        problematicPosition.set((Vec3i)tempPos);
                    }
                    return false;
                }
                if (ColonyConstants.rand.nextInt(100) < 30) continue block0;
            }
        }
        return true;
    }

    public static boolean isWaterForFishing(BlockGetter world, BlockPos pos) {
        BlockState state = world.getBlockState(pos);
        if (!state.isAir() && !state.is(Blocks.LILY_PAD)) {
            FluidState fluidstate = state.getFluidState();
            return fluidstate.is(FluidTags.WATER) && fluidstate.isSource() && state.getCollisionShape(world, pos).isEmpty();
        }
        return false;
    }
}

