/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.items.component;

import com.minecolonies.api.items.component.ModDataComponents;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public record RallyData(List<BlockPos> towers, boolean active) {
    public static final RallyData EMPTY = new RallyData(List.of(), false);
    public static final Codec<RallyData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.list((Codec)BlockPos.CODEC).fieldOf("pos").forGetter(RallyData::towers), (App)Codec.BOOL.fieldOf("active").forGetter(RallyData::active)).apply((Applicative)builder, RallyData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, RallyData> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC.apply(ByteBufCodecs.list()), RallyData::towers, (StreamCodec)ByteBufCodecs.BOOL, RallyData::active, RallyData::new);

    public RallyData withActive(boolean active) {
        return new RallyData(this.towers, active);
    }

    public RallyData withPosRemoval(BlockPos posToRemove) {
        ArrayList<BlockPos> copy = new ArrayList<BlockPos>(this.towers);
        return copy.remove(posToRemove) ? new RallyData(Collections.unmodifiableList(copy), this.active) : this;
    }

    public RallyData withPosAddition(BlockPos posToAdd) {
        ArrayList<BlockPos> copy = new ArrayList<BlockPos>(this.towers);
        copy.add(posToAdd);
        return new RallyData(Collections.unmodifiableList(copy), this.active);
    }

    public void writeToItemStack(ItemStack itemStack) {
        itemStack.set(ModDataComponents.RALLY_COMPONENT, (Object)this);
    }

    public static RallyData readFromItemStack(ItemStack itemStack) {
        return (RallyData)itemStack.getOrDefault(ModDataComponents.RALLY_COMPONENT, (Object)EMPTY);
    }

    public static void updateItemStack(ItemStack itemStack, UnaryOperator<RallyData> updater) {
        ((RallyData)updater.apply(RallyData.readFromItemStack(itemStack))).writeToItemStack(itemStack);
    }
}

