/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.items.component;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.items.component.ColonyId;
import com.minecolonies.api.items.component.ModDataComponents;
import com.minecolonies.api.util.BlockPosUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.UnaryOperator;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public record BuildingId(BlockPos id) {
    public static final BuildingId EMPTY = new BuildingId(BlockPosUtil.SAFE_ZERO);
    public static final Codec<BuildingId> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)BlockPos.CODEC.fieldOf("id").forGetter(BuildingId::id)).apply((Applicative)builder, BuildingId::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, BuildingId> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, BuildingId::id, BuildingId::new);

    public boolean hasId() {
        return !this.id.equals((Object)BuildingId.EMPTY.id);
    }

    public void writeToItemStack(ItemStack itemStack) {
        itemStack.set(ModDataComponents.HUT_ID_COMPONENT, (Object)this);
    }

    public static BuildingId readFromItemStack(ItemStack itemStack) {
        return (BuildingId)itemStack.getOrDefault(ModDataComponents.HUT_ID_COMPONENT, (Object)EMPTY);
    }

    public static void updateItemStack(ItemStack itemStack, UnaryOperator<BuildingId> updater) {
        ((BuildingId)updater.apply(BuildingId.readFromItemStack(itemStack))).writeToItemStack(itemStack);
    }

    @Nullable
    public static IBuilding readBuildingFromItemStack(ItemStack itemStack) {
        IColony colony = ColonyId.readColonyFromItemStack(itemStack);
        BuildingId buildingId = BuildingId.readFromItemStack(itemStack);
        return colony == null || buildingId == EMPTY ? null : colony.getBuildingManager().getBuilding(buildingId.id);
    }

    @Nullable
    public static IBuildingView readBuildingViewFromItemStack(ItemStack itemStack) {
        IColonyView colony = ColonyId.readColonyViewFromItemStack(itemStack);
        BuildingId buildingId = BuildingId.readFromItemStack(itemStack);
        return colony == null || buildingId == EMPTY ? null : colony.getBuilding(buildingId.id);
    }
}

